/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.UpdateManagerLogWriter;
import org.eclipse.update.internal.core.UpdateSession;
import org.eclipse.update.internal.core.connection.ConnectionThreadManagerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class UpdateCore
extends Plugin {
    public static boolean DEBUG;
    public static boolean DEBUG_SHOW_INSTALL;
    public static boolean DEBUG_SHOW_PARSING;
    public static boolean DEBUG_SHOW_WARNINGS;
    public static boolean DEBUG_SHOW_CONFIGURATION;
    public static boolean DEBUG_SHOW_TYPE;
    public static boolean DEBUG_SHOW_WEB;
    public static boolean DEBUG_SHOW_IHANDLER;
    public static boolean DEBUG_SHOW_RECONCILER;
    public static String HTTP_PROXY_HOST;
    public static String HTTP_PROXY_PORT;
    public static String HTTP_PROXY_ENABLE;
    public static final String P_HTTP_HOST = "http.proxyHost";
    public static final String P_HTTP_PORT = "http.proxyPort";
    public static final String P_HTTP_PROXY = "http.proxySet";
    private static final String PREFIX = "org.eclipse.update.core";
    public static final String P_HISTORY_SIZE = "org.eclipse.update.core.historySize";
    public static final String P_CHECK_SIGNATURE = "org.eclipse.update.core.checkSignature";
    public static final String P_AUTOMATICALLY_CHOOSE_MIRROR = "org.eclipse.update.core.automaticallyChooseMirror";
    public static final String P_UPDATE_VERSIONS = "org.eclipse.update.core.updateVersions";
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";
    public static int DEFAULT_HISTORY;
    private static UpdateCore plugin;
    private static UpdateManagerLogWriter log;
    private static final String LOG_FILE = "install.log";
    private BundleContext context;
    private ServiceTracker pkgAdminTracker;
    private ServiceTracker verifierFactoryTracker;
    private UpdateSession updateSession = null;

    static {
        HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
        HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
        HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
        DEFAULT_HISTORY = 100;
    }

    public UpdateCore() {
        plugin = this;
    }

    public static UpdateCore getPlugin() {
        return plugin;
    }

    private boolean getBooleanDebugOption(String flag, boolean dflt) {
        String result = Platform.getDebugOption((String)flag);
        if (result == null) {
            return dflt;
        }
        return result.trim().equalsIgnoreCase("true");
    }

    public static void debug(String s) {
        StringBuffer msg = new StringBuffer();
        msg.append(UpdateCore.getPlugin().toString());
        msg.append("^");
        msg.append(Integer.toHexString(Thread.currentThread().hashCode()));
        msg.append(" ");
        msg.append(s);
        System.out.println(msg.toString());
    }

    public static void warn(String s) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "WARNING: " + s;
            }
            UpdateCore.log(s, null);
        }
    }

    public static void warn(String s, Throwable e) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "UPDATE MANAGER INFO: " + s;
            }
            UpdateCore.log(s, e);
        }
    }

    public static void log(IStatus status) {
        UpdateCore.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        UpdateCore.log("", e);
    }

    public static void log(String msg, Throwable e) {
        IStatus status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : Utilities.newCoreException(msg, e).getStatus();
        if (status != null) {
            UpdateCore.log(status);
        }
    }

    public static void log(IInstallConfiguration newConfiguration) {
        if (log != null) {
            log.log(newConfiguration);
        }
    }

    private static File getInstallLogFile() throws IOException {
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL configurationLocation = config.getConfigurationLocation();
        if (configurationLocation == null) {
            UpdateCore.warn("Unable to retrieve location for update manager log file");
            return null;
        }
        File updateStateLocation = null;
        if ("file".equalsIgnoreCase(configurationLocation.getProtocol())) {
            File path = new File(configurationLocation.getFile());
            updateStateLocation = new File(path.getParentFile(), LOG_FILE);
        }
        return updateStateLocation;
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        DEBUG = this.getBooleanDebugOption("org.eclipse.update.core/debug", false);
        if (DEBUG) {
            DEBUG_SHOW_WARNINGS = this.getBooleanDebugOption("org.eclipse.update.core/debug/warning", false);
            DEBUG_SHOW_PARSING = this.getBooleanDebugOption("org.eclipse.update.core/debug/parsing", false);
            DEBUG_SHOW_INSTALL = this.getBooleanDebugOption("org.eclipse.update.core/debug/install", false);
            DEBUG_SHOW_CONFIGURATION = this.getBooleanDebugOption("org.eclipse.update.core/debug/configuration", false);
            DEBUG_SHOW_TYPE = this.getBooleanDebugOption("org.eclipse.update.core/debug/type", false);
            DEBUG_SHOW_WEB = this.getBooleanDebugOption("org.eclipse.update.core/debug/web", false);
            DEBUG_SHOW_IHANDLER = this.getBooleanDebugOption("org.eclipse.update.core/debug/installhandler", false);
            DEBUG_SHOW_RECONCILER = this.getBooleanDebugOption("org.eclipse.update.core/debug/reconciler", false);
        }
        try {
            File logFile = UpdateCore.getInstallLogFile();
            if (logFile != null) {
                log = new UpdateManagerLogWriter(logFile);
            }
        }
        catch (IOException e) {
            UpdateCore.warn("", e);
        }
        this.initProxySettings();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        JarContentReference.shutdown();
        Utilities.shutdown();
        if (log != null) {
            log.shutdown();
        }
        ConnectionThreadManagerFactory.getConnectionManager().shutdown();
        this.context = null;
        if (this.pkgAdminTracker != null) {
            this.pkgAdminTracker.close();
            this.pkgAdminTracker = null;
        }
        if (this.verifierFactoryTracker != null) {
            this.verifierFactoryTracker.close();
            this.verifierFactoryTracker = null;
        }
    }

    BundleContext getBundleContext() {
        return this.context;
    }

    PackageAdmin getPackageAdmin() {
        if (this.pkgAdminTracker == null) {
            this.pkgAdminTracker = new ServiceTracker(this.context, PackageAdmin.class.getName(), null);
            this.pkgAdminTracker.open();
        }
        return (PackageAdmin)this.pkgAdminTracker.getService();
    }

    private void initProxySettings() {
        String httpProxyPort;
        String httpProxyHost;
        String string = httpProxyHost = System.getProperty(P_HTTP_HOST) != null ? System.getProperty(P_HTTP_HOST) : this.getPluginPreferences().getString(HTTP_PROXY_HOST);
        if ("".equals(httpProxyHost)) {
            httpProxyHost = null;
        }
        String string2 = httpProxyPort = System.getProperty(P_HTTP_PORT) != null ? System.getProperty(P_HTTP_PORT) : this.getPluginPreferences().getString(HTTP_PROXY_PORT);
        if ("".equals(httpProxyPort)) {
            httpProxyPort = null;
        }
        boolean httpProxyEnable = System.getProperty(P_HTTP_HOST) != null && System.getProperty(P_HTTP_PORT) != null ? true : this.getPluginPreferences().getBoolean(HTTP_PROXY_ENABLE);
        SiteManager.setHttpProxyInfo(httpProxyEnable, httpProxyHost, httpProxyPort);
    }

    public CertificateVerifierFactory getVerifierFactory() {
        if (this.verifierFactoryTracker == null) {
            this.verifierFactoryTracker = new ServiceTracker(this.context, CertificateVerifierFactory.class.getName(), null);
            this.verifierFactoryTracker.open();
        }
        return (CertificateVerifierFactory)this.verifierFactoryTracker.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSession getUpdateSession() {
        Class<UpdateSession> clazz = UpdateSession.class;
        synchronized (UpdateSession.class) {
            if (this.updateSession == null) {
                this.updateSession = new UpdateSession();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.updateSession;
        }
    }
}

