/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;

public class DN
implements Name {
    private Vector RDNs;
    boolean binary = false;
    String errorString = "";
    NamingException rootException = null;
    public static String BLANKBASEDN = "World";

    public DN() {
        this.RDNs = new Vector();
    }

    public DN(DN copyMe) {
        try {
            this.RDNs = new Vector();
            if (copyMe != null) {
                for (int i = 0; i < copyMe.size(); ++i) {
                    this.add(new String(copyMe.get(i)));
                }
            }
        }
        catch (InvalidNameException e) {
            this.setError("error cloningDN " + copyMe.toString(), e);
            this.clear();
        }
    }

    public DN(String ldapDN) {
        try {
            this.RDNs = new Vector();
            if ("".equals(ldapDN) || BLANKBASEDN.equals(ldapDN)) {
                return;
            }
            int start = 0;
            int end = NameUtility.next(ldapDN, 0, ',');
            while (end != -1) {
                String rdn = ldapDN.substring(start, end);
                this.add(0, rdn);
                start = end + 1;
                end = NameUtility.next(ldapDN, start, ',');
            }
            this.add(0, ldapDN.substring(start).trim());
        }
        catch (InvalidNameException e) {
            this.setError("unable to make DN from " + ldapDN, e);
            this.clear();
        }
    }

    public DN(Name name) {
        try {
            this.RDNs = new Vector();
            if (name.isEmpty()) {
                return;
            }
            for (int i = 0; i < name.size(); ++i) {
                this.add(i, name.get(i));
            }
        }
        catch (InvalidNameException e) {
            this.setError("unable to create DN from name: " + name.toString(), e);
            this.clear();
        }
    }

    public String toString() {
        String ldapDN = "";
        for (int i = 0; i < this.RDNs.size(); ++i) {
            ldapDN = this.get(i) + (i != 0 ? "," : "") + ldapDN;
        }
        if (ldapDN.endsWith(",") && ldapDN.charAt(ldapDN.length() - 2) != '\\') {
            ldapDN = ldapDN.substring(0, ldapDN.length() - 1);
        }
        return ldapDN;
    }

    public String toFormattedString() {
        String ldapDN = "";
        for (int i = 0; i < this.RDNs.size(); ++i) {
            ldapDN = ldapDN + this.get(i) + "\n";
        }
        return ldapDN;
    }

    public String getDN() {
        return this.toString();
    }

    public String getRDNAttribute(int i) {
        if (this.isEmpty()) {
            return "";
        }
        if (i >= this.size()) {
            return "";
        }
        if (i < 0) {
            return "";
        }
        return this.getRDN(i).getAtt();
    }

    public String getRDNValue(int i) {
        if (this.isEmpty()) {
            return "";
        }
        if (i >= this.size()) {
            return "";
        }
        if (i < 0) {
            return "";
        }
        return this.getRDN(i).getRawVal();
    }

    public void debugPrint() {
        System.out.print("\n");
        for (int i = 0; i < this.size(); ++i) {
            System.out.print("element [" + i + "]  = " + this.get(i).toString() + "\n");
            this.getRDN(i).dump();
        }
    }

    public void setRDN(RDN rdn, int i) {
        if (i < this.size() && i >= 0) {
            this.RDNs.setElementAt(rdn, i);
        }
    }

    public RDN getRDN(int i) {
        if (i == 0 && this.isEmpty()) {
            return new RDN();
        }
        if (i < 0) {
            return new RDN();
        }
        if (i >= this.size()) {
            new RDN();
        }
        return (RDN)this.RDNs.elementAt(i);
    }

    public RDN getRootRDN() {
        if (this.isEmpty()) {
            return new RDN("");
        }
        return this.getRDN(0);
    }

    public RDN getLowestRDN() {
        return this.getRDN(this.size() - 1);
    }

    public void addParentRDN(String rdn) {
        try {
            this.add(0, rdn);
        }
        catch (InvalidNameException e) {
            this.setError("Error adding RDN in DN.addParentRDN()", e);
        }
    }

    public void addChildRDN(String rdn) throws InvalidNameException {
        this.add(rdn);
    }

    public void addChildRDN(RDN rdn) throws InvalidNameException {
        this.add(rdn);
    }

    public void setLowestRDNRawValue(String value) {
        try {
            RDN rdn = this.getRDN(this.size() - 1);
            rdn.setRawVal(value);
        }
        catch (InvalidNameException e) {
            this.setError("Error setting DN.setLowestRDNRawValue: to " + value, e);
        }
    }

    protected String exchangeRDNelementValue(String rdn, String value) {
        return rdn.substring(0, NameUtility.next(rdn, 0, '=')) + "=" + value;
    }

    public boolean equals(DN testDN) {
        if (testDN == null) {
            return false;
        }
        if (testDN.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getRDN(i).equals(testDN.getRDN(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DN) {
            return this.equals((DN)o);
        }
        if (o instanceof Name) {
            return this.compareTo((Name)o) == 0;
        }
        return false;
    }

    public boolean startsWith(DN testDN) {
        return this.startsWith((Name)testDN);
    }

    public boolean sharesParent(DN testDN) {
        if (testDN.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            if (testDN.getRDN(i).equals(this.getRDN(i))) continue;
            return false;
        }
        return true;
    }

    public DN parentDN() {
        if (this.size() <= 1) {
            return new DN();
        }
        DN newDN = new DN(this);
        newDN.RDNs.removeElementAt(this.size() - 1);
        return newDN;
    }

    public void reverse() {
        Vector rev = new Vector();
        for (int i = this.RDNs.size() - 1; i >= 0; --i) {
            rev.add(this.RDNs.elementAt(i));
        }
        this.RDNs = rev;
    }

    public void clear() {
        this.RDNs.clear();
        this.errorString = null;
    }

    public void setError(String msg, NamingException e) {
        this.errorString = msg;
        this.rootException = e;
        System.out.println(e);
    }

    public boolean error() {
        return this.errorString == null;
    }

    public String getError() {
        return this.errorString;
    }

    public NamingException getNamingException() {
        return this.rootException;
    }

    public Name add(RDN rdn) {
        this.add(this.size(), rdn);
        return this;
    }

    public Name add(int posn, RDN rdn) {
        this.RDNs.insertElementAt(rdn, posn);
        return this;
    }

    public Name add(int posn, String rdn) throws InvalidNameException {
        RDN r = new RDN(rdn);
        this.add(posn, r);
        return this;
    }

    public Name add(String rdn) throws InvalidNameException {
        RDN r = new RDN(rdn);
        this.add(this.size(), r);
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        Enumeration<String> e = n.getAll();
        while (e.hasMoreElements()) {
            this.add(posn++, e.nextElement().toString());
        }
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        Enumeration<String> e = suffix.getAll();
        while (e.hasMoreElements()) {
            this.add(e.nextElement().toString());
        }
        return this;
    }

    public Object clone() {
        return new DN(this);
    }

    public int compareTo(Object obj) {
        boolean val = false;
        int pos = 1;
        if (obj instanceof Name) {
            Name compareMe = (Name)obj;
            int size = this.size();
            int compSize = compareMe.size();
            while (!val) {
                String compRDN;
                String RDN2 = this.get(size - pos);
                int rdnOrder = RDN2.compareTo(compRDN = compareMe.get(compSize - pos));
                if (rdnOrder != 0) {
                    return rdnOrder;
                }
                if (++pos <= size && pos <= compSize) continue;
                if (size == compSize) {
                    return 0;
                }
                if (pos > size) {
                    return -1;
                }
                return 1;
            }
        } else {
            throw new ClassCastException("non Name object in DN.compareTo - object was " + obj.getClass());
        }
        return 0;
    }

    public boolean endsWith(Name n) {
        return false;
    }

    public String get(int posn) {
        if (posn == 0 && this.isEmpty()) {
            return "";
        }
        return this.RDNs.elementAt(posn).toString();
    }

    public Enumeration getAll() {
        DXNamingEnumeration ret = new DXNamingEnumeration();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(this.get(i));
        }
        return ret;
    }

    public Name getPrefix(int posn) {
        DN returnMe = new DN();
        try {
            for (int i = 0; i < posn; ++i) {
                returnMe.add(this.get(i));
            }
            return returnMe;
        }
        catch (InvalidNameException e) {
            System.err.println("unexpected error in DN:\n  " + e);
            return new DN();
        }
    }

    public Name getSuffix(int posn) {
        DN returnMe = new DN();
        for (int i = posn; i < this.size(); ++i) {
            returnMe.add(new RDN(this.getRDN(i)));
        }
        return returnMe;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(int posn) {
        return this.RDNs.remove(posn);
    }

    public int size() {
        return this.RDNs.size();
    }

    public boolean startsWith(Name n) {
        int pos = 0;
        Enumeration<String> e = n.getAll();
        while (e.hasMoreElements()) {
            if (e.nextElement().toString().equalsIgnoreCase(this.get(pos++).toString())) continue;
            return false;
        }
        return true;
    }
}

