/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ThreadGroupReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeName(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeParent(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeChildren(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ThreadGroupReference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeName(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup = (ThreadGroup)objectId.getObject();
        JdwpString.writeString(dataOutputStream, threadGroup.getName());
    }

    private final void executeParent(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup = (ThreadGroup)objectId.getObject();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        ObjectId objectId2 = this.idMan.getObjectId(threadGroup2);
        objectId2.write(dataOutputStream);
    }

    private final void executeChildren(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadGroup threadGroup;
        Object object;
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup2 = (ThreadGroup)objectId.getObject();
        ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
        int n = threadGroup2.activeCount();
        Thread[] threadArray = new Thread[n];
        threadGroup2.enumerate(threadArray, false);
        n = 0;
        int n2 = 0;
        while (n2 < threadArray.length) {
            object = threadArray[n2];
            if (object == null) break;
            if (!object.getThreadGroup().equals(threadGroup3)) {
                ++n;
            }
            ++n2;
        }
        dataOutputStream.writeInt(n);
        n2 = 0;
        while (n2 < threadArray.length) {
            object = threadArray[n2];
            if (object == null) break;
            if (!object.getThreadGroup().equals(threadGroup3)) {
                this.idMan.getObjectId(object).write(dataOutputStream);
            }
            ++n2;
        }
        n2 = threadGroup2.activeCount();
        object = new ThreadGroup[n2];
        threadGroup2.enumerate((ThreadGroup[])object, false);
        n2 = 0;
        int n3 = 0;
        while (n3 < ((ThreadGroup[])object).length) {
            threadGroup = object[n3];
            if (threadGroup == null) break;
            if (!threadGroup.equals(threadGroup3)) {
                ++n2;
            }
            ++n3;
        }
        dataOutputStream.writeInt(n2);
        n3 = 0;
        while (n3 < ((ThreadGroup[])object).length) {
            threadGroup = object[n3];
            if (threadGroup == null) break;
            if (!threadGroup.equals(threadGroup3)) {
                this.idMan.getObjectId(threadGroup).write(dataOutputStream);
            }
            ++n3;
        }
    }
}

