/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.util.FormatUtil;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.dh.GnuDHKey;
import gnu.javax.crypto.key.srp6.SRPKey;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class OutgoingMessage {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public byte[] toByteArray() throws KeyAgreementException {
        byte[] byArray = this.wrap();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 4];
        byArray2[0] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16);
        byArray2[2] = (byte)(n >>> 8);
        byArray2[3] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 4, n);
        return byArray2;
    }

    public byte[] wrap() throws KeyAgreementException {
        int n = this.out.size();
        if (n > 0x7FFFFFFB || n < 0) {
            throw new KeyAgreementException("message content is too long");
        }
        return this.out.toByteArray();
    }

    public void writePublicKey(PublicKey publicKey) throws KeyAgreementException {
        this.writeKey(publicKey);
    }

    public void writePrivateKey(PrivateKey privateKey) throws KeyAgreementException {
        this.writeKey(privateKey);
    }

    public void writeMPI(BigInteger bigInteger) throws KeyAgreementException {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        if (n > (char)-1) {
            throw new KeyAgreementException("MPI is too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)n};
        this.out.write(byArray2, 0, 2);
        this.out.write(byArray, 0, byArray.length);
    }

    public void writeString(String string) throws KeyAgreementException {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeyAgreementException("unxupported UTF8 encoding", unsupportedEncodingException);
        }
        int n = byArray.length;
        if (n > (char)-1) {
            throw new KeyAgreementException("text too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)n};
        this.out.write(byArray2, 0, 2);
        this.out.write(byArray, 0, byArray.length);
    }

    private final void writeKey(Key key) throws KeyAgreementException {
        byte[] byArray = key.getEncoded();
        int n = this.getKeyType(key);
        int n2 = FormatUtil.getFormatID(key.getFormat());
        int n3 = byArray.length + 1;
        if (n3 > 0x7FFFFEF7) {
            throw new KeyAgreementException("Encoded key is too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n3 >>> 24), (byte)(n3 >>> 16), (byte)(n3 >>> 8), (byte)n3};
        this.out.write(byArray2, 0, 4);
        this.out.write((n & 0xF) << 4 | n2 & 0xF);
        this.out.write(byArray, 0, byArray.length);
    }

    private final int getKeyType(Key key) throws KeyAgreementException {
        if (key instanceof DSSKey) {
            return 0;
        }
        if (key instanceof GnuRSAKey) {
            return 1;
        }
        if (key instanceof GnuDHKey) {
            return 2;
        }
        if (key instanceof SRPKey) {
            return 3;
        }
        throw new KeyAgreementException("Unknown or unsupported key type: " + key.getClass().getName());
    }
}

