/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.transform.SAXSerializer;
import gnu.xml.transform.StreamSerializer;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerOutputProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class TransformerImpl
extends Transformer {
    static final String INDENT_WHITESPACE = "  ";
    final TransformerFactoryImpl factory;
    final Stylesheet stylesheet;
    URIResolver uriResolver;
    ErrorListener errorListener;
    Properties outputProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source var1_1, Result var2_2) throws TransformerException {
        var4_3 = this.factory.resolver;
        synchronized (var4_3) {
            this.factory.resolver.setUserResolver(this.uriResolver);
            this.factory.resolver.setUserListener(this.errorListener);
            var3_4 = this.factory.resolver.resolveDOM(var1_1, null, null);
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
            var6_5 = var3_4.getNode();
        }
        v1 = var7_6 = var6_5 instanceof Document != false ? (Document)var6_5 : var6_5.getOwnerDocument();
        if (var7_6 instanceof DomDocument) {
            ((DomDocument)var7_6).setBuilding(true);
        }
        var8_7 = null;
        var9_8 = null;
        if (var2_2 instanceof DOMResult) {
            var10_9 = (DOMResult)var2_2;
            var8_7 = var10_9.getNode();
            var9_8 = var10_9.getNextSibling();
            v2 = var11_11 = var8_7 instanceof Document != false ? (Document)var8_7 : var8_7.getOwnerDocument();
            if (var11_11 instanceof DomDocument) {
                var12_13 = (DomDocument)var11_11;
                var12_13.setBuilding(true);
                var12_13.setCheckWellformedness(false);
            }
        }
        var10_10 = false;
        if (this.stylesheet != null) {
            if (var8_7 == null) {
                var11_11 = new DomDocument();
                var11_11.setBuilding(true);
                var11_11.setCheckWellformedness(false);
                var8_7 = var11_11;
                var10_10 = true;
            }
            var6_5 = var6_5.cloneNode(true);
            TransformerImpl.strip(this.stylesheet, var6_5);
            try {
                ((TransformerOutputProperties)this.outputProperties).apply();
                this.stylesheet.initTopLevelVariables(var6_5);
                var11_11 = this.stylesheet.getTemplate(null, var6_5, false);
                if (var11_11 == null) ** GOTO lbl72
                this.stylesheet.current = var6_5;
                var11_11.apply(this.stylesheet, null, var6_5, 1, 1, var8_7, var9_8);
            }
            catch (TransformerException var11_12) {
                if (var7_6 instanceof DomDocument == false) throw var11_12;
                ((DomDocument)var7_6).setBuilding(false);
                throw var11_12;
            }
        } else {
            var11_11 = var6_5.cloneNode(true);
            if (var6_5.getNodeType() != 9) {
                if (var8_7 == null) {
                    var13_15 = new DomDocument();
                    var13_15.setBuilding(true);
                    var13_15.setCheckWellformedness(false);
                    var12_13 = var13_15;
                    var8_7 = var12_13;
                    var10_10 = true;
                } else {
                    var12_13 = var8_7 instanceof Document != false ? (Document)var8_7 : var8_7.getOwnerDocument();
                }
                var13_15 = var6_5.getOwnerDocument();
                if (var13_15 != var12_13) {
                    var11_11 = var12_13.adoptNode((Node)var11_11);
                }
                if (var9_8 != null) {
                    var8_7.insertBefore((Node)var11_11, var9_8);
                } else {
                    var8_7.appendChild((Node)var11_11);
                }
            } else {
                var8_7 = var11_11;
                var10_10 = true;
            }
        }
        var11_11 = this.outputProperties.getProperty("method");
        v3 = 1;
        if (!"html".equals(var11_11)) {
            v3 = "text".equals(var11_11) != false ? 2 : 0;
        }
        var12_14 = v3;
        var13_15 = this.outputProperties.getProperty("encoding");
        var14_16 = this.outputProperties.getProperty("doctype-public");
        var15_17 = this.outputProperties.getProperty("doctype-system");
        var16_18 = this.outputProperties.getProperty("version");
        var17_19 = "yes".equals(this.outputProperties.getProperty("omit-xml-declaration"));
        var18_20 = "yes".equals(this.outputProperties.getProperty("standalone"));
        var19_21 = this.outputProperties.getProperty("media-type");
        var20_22 = this.outputProperties.getProperty("cdata-section-elements");
        var21_23 = "yes".equals(this.outputProperties.getProperty("indent"));
        if (var10_10) {
            var22_24 = (DomDocument)var8_7;
            var23_25 = var22_24.getDocumentElement();
            if ((var14_16 != null || var15_17 != null) && var23_25 != null) {
                var24_27 = new DomDoctype((DomDocument)var22_24, var23_25.getNodeName(), var14_16, var15_17);
                var22_24.insertBefore((Node)var24_27, (Node)var23_25);
            }
            var22_24.setBuilding(false);
            var22_24.setCheckWellformedness(true);
        } else if (var14_16 != null || var15_17 != null) {
            switch (var8_7.getNodeType()) {
                case 9: 
                case 11: {
                    var22_24 = var8_7 instanceof Document != false ? (Document)var8_7 : var8_7.getOwnerDocument();
                    var23_25 = var22_24.getImplementation();
                    var24_27 = var22_24.getDocumentElement();
                    if (var24_27 == null) break;
                    var25_30 = var23_25.createDocumentType(var24_27.getNodeName(), var14_16, var15_17);
                    var22_24.insertBefore((Node)var25_30, (Node)var24_27);
                    break;
                }
            }
        }
        if (var16_18 != null) {
            var8_7.setUserData("version", var16_18, this.stylesheet);
        }
        if (var17_19) {
            var8_7.setUserData("omit-xml-declaration", "yes", this.stylesheet);
        }
        if (var18_20) {
            var8_7.setUserData("standalone", "yes", this.stylesheet);
        }
        if (var19_21 != null) {
            var8_7.setUserData("media-type", var19_21, this.stylesheet);
        }
        if (var20_22 != null) {
            var22_24 = new LinkedList();
            var23_25 = new StringTokenizer(var20_22);
            while (var23_25.hasMoreTokens()) {
                var25_30 = var24_27 = var23_25.nextToken();
                var26_32 = null;
                var27_33 = null;
                var28_34 = var24_27.indexOf(58);
                if (var28_34 != -1) {
                    var27_33 = var24_27.substring(0, var28_34);
                    var25_30 = var24_27.substring(var28_34 + 1);
                    var26_32 = this.stylesheet.output.lookupNamespaceURI(var27_33);
                }
                var22_24.add(new QName(var26_32, (String)var25_30, var27_33));
            }
            if (!var22_24.isEmpty()) {
                var24_27 = var8_7 instanceof Document != false ? (Document)var8_7 : var8_7.getOwnerDocument();
                this.convertCdataSectionElements((Document)var24_27, var8_7, (List)var22_24);
            }
        }
        if (var21_23) {
            if (var10_10) {
                var22_24 = (DomDocument)var8_7;
                var22_24.setBuilding(true);
                var22_24.setCheckWellformedness(false);
            }
            var8_7.normalize();
            TransformerImpl.strip(this.stylesheet, var8_7);
            var22_24 = var8_7 instanceof Document != false ? (Document)var8_7 : var8_7.getOwnerDocument();
            this.reindent((Document)var22_24, var8_7, 0);
            if (var10_10) {
                var23_25 = (DomDocument)var8_7;
                var23_25.setBuilding(false);
                var23_25.setCheckWellformedness(true);
            }
        }
        if (var2_2 instanceof DOMResult) {
            if (var10_10 == false) return;
            var22_24 = (DOMResult)var2_2;
            var22_24.setNode(var8_7);
            var22_24.setNextSibling(null);
            return;
        }
        if (var2_2 instanceof StreamResult) {
            var22_24 = (StreamResult)var2_2;
            var23_25 = null;
            try {
                this.writeStreamResult(var8_7, (StreamResult)var22_24, var12_14, (String)var13_15);
            }
            catch (UnsupportedEncodingException var24_28) {
                try {
                    this.writeStreamResult(var8_7, (StreamResult)var22_24, var12_14, "UTF-8");
                }
                catch (IOException var25_31) {
                    var23_25 = var25_31;
                }
            }
            catch (IOException var24_29) {
                var23_25 = var24_29;
            }
            if (var23_25 == null) return;
            if (this.errorListener != null) {
                this.errorListener.error(new TransformerException((Throwable)var23_25));
                return;
            }
            var23_25.printStackTrace(System.err);
            return;
        }
        if (var2_2 instanceof SAXResult == false) return;
        var22_24 = (SAXResult)var2_2;
        try {
            var23_25 = var22_24.getHandler();
            var24_27 = var22_24.getLexicalHandler();
            if (var24_27 == null && var23_25 instanceof LexicalHandler) {
                var24_27 = (LexicalHandler)var23_25;
            }
            var25_30 = new SAXSerializer();
            var25_30.serialize(var8_7, (ContentHandler)var23_25, (LexicalHandler)var24_27);
            return;
        }
        catch (SAXException var23_26) {
            if (this.errorListener != null) {
                this.errorListener.error(new TransformerException(var23_26));
                return;
            }
            var23_26.printStackTrace(System.err);
        }
    }

    static boolean strip(Stylesheet stylesheet, Node node2) throws TransformerConfigurationException {
        short s = node2.getNodeType();
        if (s == 5) {
            Node node3 = node2.getParentNode();
            Node node4 = node2.getNextSibling();
            Node node5 = node2.getFirstChild();
            while (node5 != null) {
                Node node6 = node5.getNextSibling();
                node2.removeChild(node5);
                if (node4 != null) {
                    node3.insertBefore(node5, node4);
                } else {
                    node3.appendChild(node5);
                }
                node5 = node6;
            }
            return true;
        }
        if (s == 3 || s == 4) {
            String string = node2.getNodeValue();
            String[] stringArray = TransformerImpl.tokenizeWhitespace(string);
            if (stringArray.length > 1) {
                node2.setNodeValue(stringArray[0]);
                Node node7 = node2.getParentNode();
                Node node8 = node2.getNextSibling();
                Document document = node2.getOwnerDocument();
                int n = 1;
                while (n < stringArray.length) {
                    Text text;
                    Text text2 = text = s == 4 ? document.createCDATASection(stringArray[n]) : document.createTextNode(stringArray[n]);
                    if (node8 != null) {
                        node7.insertBefore(text, node8);
                    } else {
                        node7.appendChild(text);
                    }
                    ++n;
                }
            }
            return stylesheet.isPreserved((Text)node2, true) ^ true;
        }
        Node node9 = node2.getFirstChild();
        while (node9 != null) {
            boolean bl = TransformerImpl.strip(stylesheet, node9);
            Node node10 = node9.getNextSibling();
            if (bl) {
                node2.removeChild(node9);
            }
            node9 = node10;
        }
        return false;
    }

    private static final String[] tokenizeWhitespace(String string) {
        boolean bl;
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n5 < n2) {
            n = string.charAt(n5);
            boolean bl2 = false;
            if (n == 32 || n == 10 || n == 9 || n == 13) {
                bl2 = true;
            }
            if (!(bl = bl2)) break;
            ++n3;
            ++n5;
        }
        if (n3 == n4) {
            return new String[]{string};
        }
        n5 = n4;
        while (n5 > n3) {
            n = string.charAt(n5);
            boolean bl3 = false;
            if (n == 32 || n == 10 || n == 9 || n == 13) {
                bl3 = true;
            }
            if (!(bl = bl3)) break;
            --n4;
            --n5;
        }
        if (n3 == 0 && n4 == n2 - 1) {
            return new String[]{string};
        }
        String[] stringArray = n3 > 0 && n4 < n2 - 1 ? new String[3] : new String[2];
        n = 0;
        if (n3 > 0) {
            stringArray[n++] = string.substring(0, n3);
        }
        stringArray[n++] = string.substring(n3, n4 + 1);
        if (n4 < n2 - 1) {
            stringArray[n++] = string.substring(n4 + 1);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeStreamResult(Node node2, StreamResult streamResult, int n, String string) throws IOException {
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            Object object;
            Object object2;
            outputStream = streamResult.getOutputStream();
            if (outputStream == null && (object2 = streamResult.getWriter()) != null) {
                outputStream = new WriterOutputStream((Writer)object2);
            }
            if (outputStream == null) {
                object2 = streamResult.getSystemId();
                try {
                    object = new URL((String)object2);
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    uRLConnection.setDoInput(false);
                    uRLConnection.setDoOutput(true);
                    outputStream = uRLConnection.getOutputStream();
                }
                catch (MalformedURLException malformedURLException) {
                    outputStream = new FileOutputStream((String)object2);
                }
                catch (UnknownServiceException unknownServiceException) {
                    URL uRL = new URL((String)object2);
                    outputStream = new FileOutputStream(uRL.getPath());
                }
                bl = true;
            }
            outputStream = new BufferedOutputStream(outputStream);
            object2 = new StreamSerializer(n, string, null);
            if (this.stylesheet != null) {
                object = this.stylesheet.outputCdataSectionElements;
                ((StreamSerializer)object2).setCdataSectionElements((Collection)object);
            }
            ((StreamSerializer)object2).serialize(node2, outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            try {
                if (outputStream == null) throw throwable;
                if (!bl) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_15 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (outputStream == null) return;
        if (!bl) return;
        outputStream.close();
    }

    void copyChildren(Document document, Node node2, Node node3) {
        Node node4 = node2.getFirstChild();
        while (node4 != null) {
            Node node5 = document.adoptNode(node4);
            node3.appendChild(node5);
            node4 = node4.getNextSibling();
        }
    }

    public void setParameter(String string, Object object) {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.set(new QName(null, string), object, 1);
        }
    }

    public Object getParameter(String string) {
        if (this.stylesheet != null) {
            return this.stylesheet.bindings.get(new QName(null, string), null, 1, 1);
        }
        return null;
    }

    public void clearParameters() {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.pop(1);
            this.stylesheet.bindings.push(1);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this.outputProperties.clear();
        } else {
            this.outputProperties.putAll(properties);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.outputProperties.clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        return this.outputProperties.getProperty(string);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    void reindent(Document document, Node node2, int n) {
        if (node2.hasChildNodes()) {
            boolean bl = false;
            boolean bl2 = false;
            LinkedList linkedList = new LinkedList();
            Node node3 = node2.getFirstChild();
            while (node3 != null) {
                switch (node3.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 10: {
                        bl = true;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        bl2 = true;
                        break;
                    }
                }
                linkedList.add(node3);
                node3 = node3.getNextSibling();
            }
            if (bl) {
                short s = node2.getNodeType();
                if (s == 9) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        node3 = (Node)iterator.next();
                        this.reindent(document, node3, n);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('\n');
                    int n2 = 0;
                    while (n2 < n + 1) {
                        stringBuffer.append(INDENT_WHITESPACE);
                        ++n2;
                    }
                    String string = stringBuffer.toString();
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        node3 = (Node)iterator.next();
                        node2.insertBefore(document.createTextNode(string), node3);
                        this.reindent(document, node3, n + 1);
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('\n');
                    int n3 = 0;
                    while (n3 < n) {
                        stringBuffer.append(INDENT_WHITESPACE);
                        ++n3;
                    }
                    string = stringBuffer.toString();
                    node2.appendChild(document.createTextNode(string));
                }
            }
        }
    }

    void convertCdataSectionElements(Document document, Node node2, List list2) {
        if (node2.getNodeType() == 1) {
            Object object;
            boolean bl = false;
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (QName)object2.next();
                if (!this.match((QName)object, node2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                object2 = node2.getFirstChild();
                while (object2 != null) {
                    if (object2.getNodeType() == 3) {
                        object = document.createCDATASection(object2.getNodeValue());
                        node2.replaceChild((Node)object, (Node)object2);
                        object2 = object;
                    }
                    object2 = object2.getNextSibling();
                }
            }
        }
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            if (node3.hasChildNodes()) {
                this.convertCdataSectionElements(document, node3, list2);
            }
            node3 = node3.getNextSibling();
        }
    }

    boolean match(QName qName, Node node2) {
        String string = qName.getLocalPart();
        String string2 = node2.getLocalName();
        if (string2 == null) {
            return string.equals(node2.getNodeName());
        }
        String string3 = qName.getNamespaceURI();
        String string4 = node2.getNamespaceURI();
        boolean bl = false;
        if (string3.equals(string4) && string.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    TransformerImpl(TransformerFactoryImpl transformerFactoryImpl, Stylesheet stylesheet, Properties properties) throws TransformerConfigurationException {
        this.factory = transformerFactoryImpl;
        this.uriResolver = transformerFactoryImpl.userResolver;
        this.errorListener = transformerFactoryImpl.userListener;
        this.stylesheet = stylesheet;
        this.outputProperties = properties;
        if (stylesheet != null) {
            stylesheet.bindings.push(1);
        }
    }
}

