/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.util;

public class IntegerHashtable {
    private static final int DEFAULTCAPACITY = 101;
    private static final int DEFAULTLOADFACTOR = 75;
    private static final int removed = -2;
    private static final int free = -1;
    private int[] keys;
    private Object[] elements;
    private int iloadFactor;
    private int numberOfKeys;
    private int rehashLimit;

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.numberOfKeys == 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean contains(Object object) {
        int n = this.elements.length - 1;
        while (n >= 0) {
            if (object.equals(this.elements[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        boolean bl = false;
        if (this.get(n) != null) {
            bl = true;
        }
        return bl;
    }

    private final int calculateBucket(int n) {
        return n % this.keys.length;
    }

    public synchronized Object get(int n) {
        int n2;
        int n3 = this.calculateBucket(n);
        int n4 = this.keys.length;
        int n5 = n3;
        while (n5 < n4) {
            n2 = this.keys[n5];
            if (n == n2) {
                return this.elements[n5];
            }
            if (n2 == -1) {
                return null;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = this.keys[n5];
            if (n == n2) {
                return this.elements[n5];
            }
            if (n2 == -1) {
                return null;
            }
            ++n5;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        int[] nArray = this.keys;
        Object[] objectArray = this.elements;
        this.keys = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.keys[n2] = -1;
            ++n2;
        }
        this.elements = new Object[n];
        this.rehashLimit = this.iloadFactor * n / 100;
        this.numberOfKeys = 0;
        n2 = nArray.length - 1;
        while (n2 >= 0) {
            if (nArray[n2] != -1 && nArray[n2] != -2) {
                this.put(nArray[n2], objectArray[n2]);
            }
            --n2;
        }
    }

    public synchronized Object put(int n, Object object) {
        int n2;
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n3 = this.calculateBucket(n);
        int n4 = this.keys.length;
        int n5 = -1;
        int n6 = n3;
        while (n6 < n4) {
            n2 = this.keys[n6];
            if (n2 == -2) {
                if (n5 == -1) {
                    n5 = n6;
                }
            } else {
                if (n2 == -1) {
                    if (n5 == -1) {
                        n5 = n6;
                    }
                    this.keys[n5] = n;
                    this.elements[n5] = object;
                    ++this.numberOfKeys;
                    return null;
                }
                if (n == n2) {
                    Object object2 = this.elements[n6];
                    this.elements[n6] = object;
                    return object2;
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            n2 = this.keys[n6];
            if (n == n2) {
                Object object3 = this.elements[n6];
                this.elements[n6] = object;
                return object3;
            }
            if (n2 == -2) {
                if (n5 == -1) {
                    n5 = n6;
                }
            } else if (n2 == -1) {
                if (n5 == -1) {
                    n5 = n6;
                }
                this.keys[n5] = n;
                this.elements[n5] = object;
                ++this.numberOfKeys;
                return null;
            }
            ++n6;
        }
        if (n5 != -1) {
            this.keys[n5] = n;
            this.elements[n5] = object;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent Hashtable");
    }

    public synchronized Object remove(int n) {
        int n2;
        int n3 = this.calculateBucket(n);
        int n4 = this.keys.length;
        int n5 = n3;
        while (n5 < n4) {
            n2 = this.keys[n5];
            if (n == n2) {
                Object object = this.elements[n5];
                this.elements[n5] = null;
                this.keys[n5] = -2;
                --this.numberOfKeys;
                return object;
            }
            if (n2 == -1) {
                return null;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = this.keys[n5];
            if (n == n2) {
                Object object = this.elements[n5];
                this.elements[n5] = null;
                this.keys[n5] = -2;
                --this.numberOfKeys;
                return object;
            }
            if (n2 == -1) {
                return null;
            }
            ++n5;
        }
        return null;
    }

    public synchronized void clear() {
        int n = this.keys.length - 1;
        while (n >= 0) {
            this.keys[n] = -1;
            this.elements[n] = null;
            --n;
        }
        this.numberOfKeys = 0;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != -1 && this.keys[n] != -2) {
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
                break;
            }
            ++n;
        }
        while (n < this.keys.length) {
            if (this.keys[n] != -1 && this.keys[n] != -2) {
                stringBuffer.append(", ");
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public IntegerHashtable() {
        this(101, 75);
    }

    public IntegerHashtable(int n) {
        this(n, 75);
    }

    public IntegerHashtable(int n, float f) {
        this(n, (int)((double)f * 100.0));
    }

    public IntegerHashtable(int n, int n2) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if (n2 <= 0) {
            throw new Error("Load Factor is <= 0");
        }
        this.iloadFactor = n2;
        this.keys = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.keys[n3] = -1;
            ++n3;
        }
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = n2 * n / 100;
    }
}

