/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;

public final class PropertyHelper {
    private Project project;
    private UpdateHelper updateHelper;

    public PropertyHelper(Project project, UpdateHelper updateHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
    }

    public String getProperty(String path, String key) {
        return this.getProperties(path).getProperty(key);
    }

    public void setProperty(String path, String key, String value) {
        assert (ProjectManager.mutex().isWriteAccess()) : "You must have write access to ProjectManager.mutex(). You can also use @see #saveProperty if you only need to save one property";
        EditableProperties ep = this.getProperties(path);
        ep.setProperty(key, value);
        this.putProperties(path, ep);
    }

    public void saveProperty(final String path, final String key, final String value) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                PropertyHelper.this.setProperty(path, key, value);
                PropertyHelper.this.save();
            }
        });
    }

    public void save() {
        assert (ProjectManager.mutex().isWriteAccess()) : "You must have write access to ProjectManager.mutex().";
        try {
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private EditableProperties getProperties(String path) {
        return this.updateHelper.getProperties(path);
    }

    private void putProperties(String path, EditableProperties ep) {
        this.updateHelper.putProperties(path, ep);
    }
}

