/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClassPathSupport {
    public static final String ELEMENT_INCLUDED_LIBRARIES = "included-library";
    private static String[] ejbjarElemOrder = new String[]{"name", "minimum-ant-version", "explicit-platform", "use-manifest", "included-library", "web-services", "source-roots", "test-roots"};
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;

    public ClassPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] wellKnownPaths, String libraryPrefix, String librarySuffix, String antArtifactPrefix) {
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = wellKnownPaths == null ? null : new HashSet<String>(Arrays.asList(wellKnownPaths));
        this.libraryPrefix = libraryPrefix;
        this.librarySuffix = librarySuffix;
        this.antArtifactPrefix = antArtifactPrefix;
    }

    public Iterator itemsIterator(String propertyValue, String includedLibrariesElement) {
        return this.itemsList(propertyValue, includedLibrariesElement).iterator();
    }

    public List itemsList(String propertyValue, String includedLibrariesElement) {
        List includedItems = includedLibrariesElement != null ? ClassPathSupport.getIncludedLibraries(this.antProjectHelper, includedLibrariesElement) : Collections.EMPTY_LIST;
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            String property = EjbJarProjectProperties.getAntPropertyName(pe[i]);
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i], false);
            } else if (this.isLibrary(pe[i])) {
                String libraryName = pe[i].substring(this.libraryPrefix.length(), pe[i].lastIndexOf(46));
                Library library = LibraryManager.getDefault().getLibrary(libraryName);
                item = library == null ? Item.createBroken(1, pe[i], includedItems.contains(property)) : Item.create(library, pe[i], includedItems.contains(property));
            } else if (this.isAntArtifact(pe[i])) {
                Object[] ret = this.referenceHelper.findArtifactAndLocation(pe[i]);
                if (ret[0] == null || ret[1] == null) {
                    item = Item.createBroken(2, pe[i], includedItems.contains(property));
                } else {
                    File artifactFile;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    File usedFile = this.antProjectHelper.resolveFile(this.evaluator.evaluate(pe[i]));
                    item = usedFile.equals(artifactFile = new File(artifact.getScriptLocation().toURI().resolve(uri).normalize())) ? Item.create(artifact, uri, pe[i], includedItems.contains(property)) : Item.createBroken(2, pe[i], includedItems.contains(property));
                }
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? Item.createBroken(0, pe[i], includedItems.contains(property)) : Item.create(f, pe[i], includedItems.contains(property));
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator classpath, String includedLibrariesElement) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> includedLibraries = new ArrayList<String>();
        LinkedList<Item> cp = new LinkedList<Item>();
        while (classpath.hasNext()) {
            Item item = (Item)classpath.next();
            cp.add(item);
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken() || reference != null) break;
                    File file = item.getFile();
                    reference = this.referenceHelper.createForeignFileReference(file, null);
                    item.setReference(reference);
                    break;
                }
                case 1: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (reference != null || library == null) break;
                    reference = this.getLibraryReference(item);
                    item.setReference(reference);
                    break;
                }
                case 2: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact artifact = item.getArtifact();
                    if (reference != null || artifact == null) break;
                    reference = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    item.setReference(reference);
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            if (reference == null) continue;
            result.add(reference);
            if (includedLibrariesElement == null || !item.isIncludedInDeployment()) continue;
            includedLibraries.add(EjbJarProjectProperties.getAntPropertyName(reference));
        }
        if (includedLibrariesElement != null) {
            ClassPathSupport.putIncludedLibraries(includedLibraries, cp, this.antProjectHelper, includedLibrariesElement);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String property) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(property);
    }

    private boolean isAntArtifact(String property) {
        return this.antArtifactPrefix == null ? false : property.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String property) {
        if (this.libraryPrefix != null && property.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : property.endsWith(this.librarySuffix);
        }
        return false;
    }

    private static List getIncludedLibraries(AntProjectHelper antProjectHelper, String includedLibrariesElement) {
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        ArrayList<String> libraries = new ArrayList<String>(libs.getLength());
        for (int i = 0; i < libs.getLength(); ++i) {
            Element item = (Element)libs.item(i);
            libraries.add(ClassPathSupport.findText(item));
        }
        return libraries;
    }

    private static void putIncludedLibraries(List libraries, List classpath, AntProjectHelper antProjectHelper, String includedLibrariesElement) {
        assert (libraries != null);
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        while (libs.getLength() > 0) {
            Node n = libs.item(0);
            n.getParentNode().removeChild(n);
        }
        Document doc = data.getOwnerDocument();
        for (String libraryName : libraries) {
            for (int idx = 0; idx < classpath.size(); ++idx) {
                Item item = (Item)classpath.get(idx);
                String libraryPropName = "${" + libraryName + "}";
                if (!libraryPropName.equals(item.getReference())) continue;
                ClassPathSupport.appendChildElement(data, ClassPathSupport.createLibraryElement(doc, libraryName, item, includedLibrariesElement), ejbjarElemOrder);
            }
        }
        antProjectHelper.putPrimaryConfigurationData(data, true);
    }

    private static List findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    private static void appendChildElement(Element parent, Element el, String[] order) {
        Element insertBefore = null;
        List<String> l = Arrays.asList(order);
        int index = l.indexOf(el.getLocalName());
        assert (index != -1) : el.getLocalName() + " was not found in " + l;
        for (Element e : ClassPathSupport.findSubElements(parent)) {
            int index2 = l.indexOf(e.getLocalName());
            assert (index2 != -1) : e.getLocalName() + " was not found in " + l;
            if (index2 <= index) continue;
            insertBefore = e;
            break;
        }
        parent.insertBefore(el, insertBefore);
    }

    private static Element createLibraryElement(Document doc, String pathItem, Item item, String includedLibrariesElement) {
        Element libraryElement = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        ArrayList files = new ArrayList();
        ArrayList dirs = new ArrayList();
        EjbJarProjectProperties.getFilesForItem(item, files, dirs);
        if (files.size() > 0) {
            libraryElement.setAttribute(ATTR_FILES, "" + files.size());
        }
        if (dirs.size() > 0) {
            libraryElement.setAttribute(ATTR_DIRS, "" + dirs.size());
        }
        libraryElement.appendChild(doc.createTextNode(pathItem));
        return libraryElement;
    }

    private static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private boolean includedInDeployment;
        private String raw;

        private Item(int type, Object object, String property, boolean included, String raw) {
            this.type = type;
            this.object = object;
            this.property = property;
            this.includedInDeployment = included;
            this.raw = raw;
        }

        private Item(int type, Object object, URI artifactURI, String property, boolean included) {
            this(type, object, property, included, null);
            this.artifactURI = artifactURI;
        }

        public static Item create(Library library, String property, boolean included) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            String libraryName = library.getName();
            return new Item(1, (Object)library, property, included, "${libs." + libraryName + ".classpath}");
        }

        public static Item create(AntArtifact artifact, URI artifactURI, String property, boolean included) {
            if (artifactURI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, (Object)artifact, artifactURI, property, included);
        }

        public static Item create(File file, String property, boolean included) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, (Object)file, property, included, null);
        }

        public static Item create(String property, boolean included) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, property, included, null);
        }

        public static Item createBroken(int type, String property, boolean included) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, (Object)BROKEN, property, included, null);
        }

        public String getRaw() {
            return this.raw;
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (this.isBroken()) {
                return null;
            }
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            if (this.isBroken()) {
                return null;
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            if (this.isBroken()) {
                return null;
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public void setReference(String property) {
            this.property = property;
        }

        public boolean isIncludedInDeployment() {
            return this.includedInDeployment;
        }

        public void setIncludedInDeployment(boolean includedInDeployment) {
            this.includedInDeployment = includedInDeployment;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public String toString() {
            return "artifactURI=" + this.artifactURI + ", type=" + this.type + ", property=" + this.property + ", includedInDeployment=" + this.includedInDeployment + ", raw=" + this.raw + ", object=" + this.object;
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 2: {
                    hash += this.getArtifact().getType().hashCode();
                    hash += this.getArtifact().getScriptLocation().hashCode();
                    hash += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

