/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.project.libraries.LibraryImplementation;

public final class DefaultLibraryImplementation
implements LibraryImplementation {
    private String description;
    private Map contents;
    private String name;
    private String libraryType;
    private String localizingBundle;
    private ArrayList listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultLibraryImplementation(String libraryType, String[] volumeTypes) {
        if (!($assertionsDisabled || libraryType != null && volumeTypes != null)) {
            throw new AssertionError();
        }
        this.libraryType = libraryType;
        this.contents = new HashMap();
        for (int i = 0; i < volumeTypes.length; ++i) {
            this.contents.put(volumeTypes[i], Collections.EMPTY_LIST);
        }
    }

    public String getType() {
        return this.libraryType;
    }

    public void setName(String name) throws UnsupportedOperationException {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, this.name);
    }

    public String getName() {
        return this.name;
    }

    public List getContent(String contentType) throws IllegalArgumentException {
        List content = (List)this.contents.get(contentType);
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return Collections.unmodifiableList(content);
    }

    public void setContent(String contentType, List path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (!this.contents.keySet().contains(contentType)) {
            throw new IllegalArgumentException("Volume '" + contentType + "' is not support by this library. The only acceptable values are: " + this.contents.keySet());
        }
        this.contents.put(contentType, new ArrayList(path));
        this.firePropertyChange("content", null, null);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String text) {
        String oldDesc = this.description;
        this.description = text;
        this.firePropertyChange("description", oldDesc, this.description);
    }

    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    public void setLocalizingBundle(String resourceName) {
        this.localizingBundle = resourceName;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String toString() {
        return "LibraryImplementation[Name=" + this.name + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultLibraryImplementation) {
            DefaultLibraryImplementation other = (DefaultLibraryImplementation)o;
            return this.name == null ? other.name == null : this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        Iterator it;
        DefaultLibraryImplementation defaultLibraryImplementation = this;
        synchronized (defaultLibraryImplementation) {
            if (this.listeners == null) {
                return;
            }
            it = ((List)this.listeners.clone()).iterator();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    static {
        $assertionsDisabled = !DefaultLibraryImplementation.class.desiredAssertionStatus();
    }
}

