/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.xjc.api.Reference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorContext {
    private Map<String, SEIContext> seiContextMap = new HashMap<String, SEIContext>();
    private int round = 1;
    private boolean modelCompleted = false;

    public void addSEIContext(String seiName, SEIContext seiContext) {
        this.seiContextMap.put(seiName, seiContext);
    }

    public SEIContext getSEIContext(String seiName) {
        SEIContext context = this.seiContextMap.get(seiName);
        if (context == null) {
            context = new SEIContext(seiName);
            this.addSEIContext(seiName, context);
        }
        return context;
    }

    public SEIContext getSEIContext(TypeDeclaration d) {
        SEIContext context = this.getSEIContext(d.getQualifiedName());
        return context;
    }

    public Collection<SEIContext> getSEIContexts() {
        return this.seiContextMap.values();
    }

    public boolean allEncoded() {
        for (SEIContext seiContext : this.seiContextMap.values()) {
            if (AnnotationProcessorContext.isEncoded(seiContext.getModel())) continue;
            return false;
        }
        return true;
    }

    public int getRound() {
        return this.round;
    }

    public void incrementRound() {
        ++this.round;
    }

    public static boolean isEncoded(Model model) {
        if (model == null) {
            return false;
        }
        for (Service service : model.getServices()) {
            for (Port port : service.getPorts()) {
                for (Operation operation : port.getOperations()) {
                    if (operation.getUse() == null || !operation.getUse().equals(SOAPUse.LITERAL)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setModelCompleted(boolean modelCompleted) {
        this.modelCompleted = modelCompleted;
    }

    public boolean isModelCompleted() {
        return this.modelCompleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SEIContext {
        private Map<String, WrapperInfo> reqOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, WrapperInfo> resOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, FaultInfo> exceptionBeanMap = new HashMap<String, FaultInfo>();
        private Model model;
        private Map<Object, Reference> schemaReferences = new HashMap<Object, Reference>();
        private Map<QName, Reference> schemaElements = new HashMap<QName, Reference>();
        private boolean modelCompiled = false;
        private String seiName;
        private String seiImplName;
        private boolean implementsSEI = false;
        private JAXBModel jaxBModel;
        private String namespaceURI = null;

        public SEIContext(String seiName) {
            this.seiName = seiName;
        }

        public void setImplementsSEI(boolean implementsSEI) {
            this.implementsSEI = implementsSEI;
        }

        public boolean getImplementsSEI() {
            return this.implementsSEI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public void setJAXBModel(JAXBModel model) {
            this.jaxBModel = model;
            if (this.model != null) {
                this.model.setJAXBModel(model);
            }
        }

        public JAXBModel getJAXBModel() {
            return this.jaxBModel;
        }

        public String getSEIName() {
            return this.seiName;
        }

        public String getSEIImplName() {
            return this.seiImplName;
        }

        public void setSEIImplName(String implName) {
            this.seiImplName = implName;
        }

        public void setReqWrapperOperation(MethodDeclaration method, WrapperInfo wrapperInfo) {
            this.reqOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getReqOperationWrapper(MethodDeclaration method) {
            return this.reqOperationWrapperMap.get(this.methodToString(method));
        }

        public void setResWrapperOperation(MethodDeclaration method, WrapperInfo wrapperInfo) {
            this.resOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getResOperationWrapper(MethodDeclaration method) {
            return this.resOperationWrapperMap.get(this.methodToString(method));
        }

        public String methodToString(MethodDeclaration method) {
            StringBuffer buf = new StringBuffer(method.getSimpleName());
            for (ParameterDeclaration param : method.getParameters()) {
                buf.append(";" + param.getType().toString());
            }
            return buf.toString();
        }

        public void setModel(Model model) {
            this.model = model;
            model.setJAXBModel(this.jaxBModel);
        }

        public Model getModel() {
            return this.model;
        }

        public boolean getModelCompiled() {
            return this.modelCompiled;
        }

        public void setModelCompiled(boolean compiled) {
            this.modelCompiled = compiled;
        }

        public Collection<Reference> getSchemaReferences(ModelBuilder builder) {
            return this.schemaReferences.values();
        }

        public Map<QName, Reference> getSchemaElementMap(ModelBuilder builder) {
            return this.schemaElements;
        }

        public Collection<Reference> getSchemaReferences() {
            return this.schemaReferences.values();
        }

        public void clearExceptionMap() {
            this.exceptionBeanMap.clear();
        }

        public void addExceptionBeanEntry(String exception, FaultInfo faultInfo, ModelBuilder builder) {
            this.exceptionBeanMap.put(exception, faultInfo);
        }

        public FaultInfo getExceptionBeanName(String exception) {
            return this.exceptionBeanMap.get(exception);
        }

        public Reference addReference(MethodDeclaration method) {
            Reference ref = this.schemaReferences.get(method);
            if (ref == null) {
                ref = new Reference(method);
            }
            this.addReference(method, ref);
            return ref;
        }

        public Reference addReference(ParameterDeclaration param) {
            Reference ref = this.schemaReferences.get(param);
            if (ref == null) {
                ref = new Reference(param);
            }
            this.addReference(param, ref);
            return ref;
        }

        public Reference addReference(TypeMirror type, ParameterDeclaration param) {
            Reference ref = this.schemaReferences.get(param);
            if (ref == null) {
                ref = new Reference(type, (Declaration)param);
            }
            this.addReference(param, ref);
            return ref;
        }

        public Reference addReference(TypeDeclaration type, AnnotationProcessorEnvironment apEnv) {
            Reference ref = this.schemaReferences.get(type);
            if (ref == null) {
                ref = new Reference(type, apEnv);
            }
            this.addReference((Object)type, ref);
            return ref;
        }

        private void addReference(Object key, Reference reference) {
            this.schemaReferences.put(key, reference);
        }

        public Reference getReference(Object key) {
            return this.schemaReferences.get(key);
        }

        public void addSchemaElement(QName elemName, Reference reference) {
            if (elemName == null) {
                throw new RuntimeException();
            }
            this.schemaElements.put(elemName, reference);
        }
    }
}

