/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.registry.WebServicePersistenceManager;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModelEvent;
import org.netbeans.modules.websvc.registry.model.WebServiceListModelListener;

public class WebServiceListModel {
    private static Random serviceRandom = new Random(System.currentTimeMillis());
    private static Random serviceGroupRandom = new Random(System.currentTimeMillis());
    Set listeners = new HashSet();
    private Map webservices = Collections.synchronizedMap(new HashMap());
    private Map webserviceGroups = Collections.synchronizedMap(new HashMap());
    private static int websvcCounter = 0;
    private static int groupCounter = 0;
    public static String MODEL_SERVICE_ADDED = "ServiceAdded";
    public static String MODEL_SERVICE_REMOVED = "ServiceRemoved";
    private static String EVENT_TYPE_ADD = "ADD";
    private static String EVENT_TYPE_REMOVE = "REMOVE";
    private static WebServiceListModel websvcNodeModel = new WebServiceListModel();
    private static boolean initialized = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private WebServiceListModel() {
    }

    public static WebServiceListModel getInstance() {
        if (!initialized) {
            initialized = true;
            WebServicePersistenceManager pm = new WebServicePersistenceManager();
            pm.load(pm.getClass().getClassLoader());
        }
        return websvcNodeModel;
    }

    public void addWebServiceListModelListener(WebServiceListModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeWebServiceListModelListener(WebServiceListModelListener listener) {
        this.listeners.remove(listener);
    }

    public String getUniqueWebServiceId() {
        String uniqueId = "webservice" + serviceRandom.nextLong();
        while (this.webservices.containsKey(uniqueId)) {
            uniqueId = "webservice" + serviceRandom.nextLong();
        }
        return uniqueId;
    }

    public String getUniqueWebServiceGroupId() {
        String uniqueId = "webserviceGroup" + serviceGroupRandom.nextLong();
        while (this.webserviceGroups.containsKey(uniqueId)) {
            uniqueId = "webserviceGroup" + serviceGroupRandom.nextLong();
        }
        return uniqueId;
    }

    public void addWebService(WebServiceData webService) {
        if (!this.webservices.containsKey(webService.getId())) {
            this.webservices.put(webService.getId(), webService);
            this.fireServiceAdded(webService);
        }
    }

    public WebServiceData getWebService(String webServiceId) {
        return (WebServiceData)this.webservices.get(webServiceId);
    }

    public void removeWebService(String webServiceId) {
        WebServiceData wsData = (WebServiceData)this.webservices.get(webServiceId);
        if (wsData != null) {
            WebServiceGroup group = this.getWebServiceGroup(this.getWebService(webServiceId).getGroupId());
            if (group != null) {
                group.remove(webServiceId);
            }
            this.webservices.remove(webServiceId);
            this.fireServiceRemoved(wsData);
        }
    }

    public void removeWebService(WebServiceData ws) {
        Iterator iter = this.webservices.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            WebServiceData wsData = (WebServiceData)this.webservices.get(key);
            if (!wsData.equals(ws)) continue;
            WebServiceGroup group = this.getWebServiceGroup(wsData.getGroupId());
            if (group != null) {
                group.remove(key);
            }
            this.webservices.remove(key);
            this.fireServiceRemoved(wsData);
            break;
        }
    }

    public boolean webServiceExists(WebServiceData webService) {
        Iterator iter = this.webservices.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = (WebServiceData)this.webservices.get(iter.next());
            if (!wsData.equals(webService)) continue;
            return true;
        }
        return false;
    }

    public WebServiceData findService(WebServiceData webService) {
        Iterator iter = this.webservices.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = (WebServiceData)this.webservices.get(iter.next());
            if (!wsData.equals(webService)) continue;
            return wsData;
        }
        return null;
    }

    public boolean webServiceExists(String serviceName) {
        WebServiceData wsKey = new WebServiceData();
        wsKey.setDisplayName(serviceName);
        Iterator iter = this.webservices.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = (WebServiceData)this.webservices.get(iter.next());
            if (!wsData.equals(wsKey)) continue;
            return true;
        }
        return false;
    }

    public Set getWebServiceSet() {
        HashSet<WebServiceData> websvcs = new HashSet<WebServiceData>();
        Iterator iter = this.webservices.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = (WebServiceData)this.webservices.get(iter.next());
            websvcs.add(wsData);
        }
        return websvcs;
    }

    public void addWebServiceGroup(WebServiceGroup group) {
        if (!this.webserviceGroups.containsKey(group.getId())) {
            this.webserviceGroups.put(group.getId(), group);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceListModelEvent evt = new WebServiceListModelEvent(group.getId());
                ((WebServiceListModelListener)iter.next()).webServiceGroupAdded(evt);
            }
        }
    }

    public void removeWebServiceGroup(String groupId) {
        if (this.webserviceGroups.containsKey(groupId)) {
            String[] webserviceIds = this.getWebServiceGroup(groupId).getWebServiceIds().toArray(new String[0]);
            for (int ii = 0; null != webserviceIds && ii < webserviceIds.length; ++ii) {
                this.removeWebService(webserviceIds[ii]);
            }
            this.webserviceGroups.remove(groupId);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceListModelEvent evt = new WebServiceListModelEvent(groupId);
                ((WebServiceListModelListener)iter.next()).webServiceGroupRemoved(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceGroup getWebServiceGroup(String groupId) {
        WebServiceGroup group = (WebServiceGroup)this.webserviceGroups.get(groupId);
        if (group == null && "default".equals(groupId)) {
            WebServiceListModel webServiceListModel = this;
            synchronized (webServiceListModel) {
                group = (WebServiceGroup)this.webserviceGroups.get(groupId);
                if (group == null) {
                    group = new WebServiceGroup("default");
                    this.addWebServiceGroup(group);
                }
            }
        }
        return group;
    }

    public Set getWebServiceGroupSet() {
        HashSet<WebServiceGroup> wsGroups = new HashSet<WebServiceGroup>();
        Iterator iter = this.webserviceGroups.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceGroup group = (WebServiceGroup)this.webserviceGroups.get(iter.next());
            wsGroups.add(group);
        }
        return wsGroups;
    }

    public WebServiceGroup findWebServiceGroup(String groupName) {
        Iterator iter = this.webserviceGroups.keySet().iterator();
        while (iter.hasNext()) {
            WebServiceGroup group = (WebServiceGroup)this.webserviceGroups.get(iter.next());
            if (!groupName.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireServiceAdded(final WebServiceData wsData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WebServiceListModel.this.propertyChangeSupport.firePropertyChange(MODEL_SERVICE_ADDED, null, wsData);
            }
        });
    }

    private void fireServiceRemoved(final WebServiceData wsData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WebServiceListModel.this.propertyChangeSupport.firePropertyChange(MODEL_SERVICE_REMOVED, wsData, null);
            }
        });
    }
}

