/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.util;

import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.util.JavaCompilerHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.registry.WebServiceException;
import org.netbeans.modules.websvc.registry.jaxrpc.WrapperClientBeanInfoWriter;
import org.netbeans.modules.websvc.registry.jaxrpc.Wsdl2Java;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.util.JarUtil;
import org.netbeans.modules.websvc.registry.util.WebProxySetter;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Util {
    public static String changeString(String inString, String oldSubString, String newSubString) {
        if (oldSubString.trim().equals("")) {
            return inString;
        }
        int start = 0;
        int end = 0;
        StringBuffer changedString = new StringBuffer("");
        end = inString.indexOf(oldSubString, start);
        while (end != -1) {
            changedString.append(inString.substring(start, end) + newSubString);
            start = end + oldSubString.length();
            end = inString.indexOf(oldSubString, start);
        }
        changedString.append(inString.substring(start));
        return changedString.toString();
    }

    public static boolean createWSJar(WebServiceData inWSData, OutputStream inOutputStream, String inJarFileName) {
        Object jarFileName = null;
        OutputStream outputStream = null;
        FileOutputStream fileOutputStream = null;
        Date date = new Date();
        File tmpOutputDir = null;
        File errorFile = null;
        try {
            File tempFile = File.createTempFile("wstemp", "ws");
            tmpOutputDir = new File(tempFile.getParentFile(), "wstemp" + date.getTime());
            if (!tmpOutputDir.exists()) {
                tmpOutputDir.mkdirs();
            }
            errorFile = File.createTempFile("wscompile", "error", tempFile.getParentFile());
            if (null == inOutputStream) {
                fileOutputStream = new FileOutputStream(errorFile);
                outputStream = fileOutputStream;
            } else {
                outputStream = inOutputStream;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"PROXY_GEN_ERROR"));
            return false;
        }
        Wsdl2Java wsdl2Java = new Wsdl2Java();
        wsdl2Java.setOutputDirectory(tmpOutputDir.getAbsolutePath());
        wsdl2Java.setPackageName(inWSData.getPackageName());
        try {
            wsdl2Java.setWsdlUrl(new URL(inWSData.getURL()));
        }
        catch (MalformedURLException mfue) {
            ErrorManager.getDefault().notify((Throwable)mfue);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_NOJAR_ERROR"));
            return false;
        }
        System.setProperty("http.proxyHost", WebProxySetter.getInstance().getProxyHost());
        System.setProperty("http.proxyPort", WebProxySetter.getInstance().getProxyPort());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_CREATING_JARFILE"));
        if (!wsdl2Java.execute(inWSData, outputStream)) {
            ErrorManager.getDefault().log("Util.createWSJar:" + NbBundle.getMessage(Util.class, (String)"WS_WSDL2JAVA_ERROR"));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_WSDL2JAVA_ERROR"));
            return false;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_CREATING_JARFILE_FINISHED"));
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-d");
        argList.add(tmpOutputDir.getAbsolutePath());
        argList.add("-classpath");
        String classPath = tmpOutputDir.getAbsolutePath() + File.pathSeparator + Util.getRuntimeClassPath();
        argList.add(classPath);
        argList.add("-g");
        File wrapperFile = wsdl2Java.getWebserviceClient();
        argList.add(wrapperFile.getAbsolutePath());
        File wrapperBeanInfoFile = wsdl2Java.getWebserviceClientBeanInfo();
        argList.add(wrapperBeanInfoFile.getAbsolutePath());
        String[] args = argList.toArray(new String[0]);
        File tempFile = null;
        try {
            tempFile = File.createTempFile("wstemp", "compile_errors");
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"PROXY_GEN_ERROR"));
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException fnfe) {
            ErrorManager.getDefault().notify((Throwable)fnfe);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"PROXY_GEN_ERROR"));
            return false;
        }
        JavaCompilerHelper compilerHelper = new JavaCompilerHelper((OutputStream)out);
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_CLIENTWRAPPER_COMPILING"));
        boolean result = compilerHelper.compile(args);
        if (!result) {
            ErrorManager.getDefault().log("Util.createWSJar: " + NbBundle.getMessage(Util.class, (String)"WS_CLIENTWRAPPER_COMPILE_ERROR") + tempFile == null ? "" : tempFile.getAbsolutePath());
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"PROXY_GEN_ERROR"));
            return false;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"WS_CLIENTWRAPPER_COMPILE_OK"));
        tempFile.delete();
        try {
            URL imageUrl = Util.class.getResource("/org/netbeans/modules/websvc/registry/resources/webservice.png");
            DataInputStream in = new DataInputStream(imageUrl.openStream());
            String iconImagePath = tmpOutputDir.getAbsolutePath() + File.separator + inWSData.getPackageName().replace('.', File.separatorChar);
            File outputFile = new File(iconImagePath, WrapperClientBeanInfoWriter.WEBSERVICE_ICON_FILENAME);
            DataOutputStream outImage = new DataOutputStream(new FileOutputStream(outputFile));
            byte[] bytes = new byte[1024];
            int byteCount = in.read(bytes);
            while (byteCount > -1) {
                outImage.write(bytes);
                byteCount = in.read(bytes);
            }
            outImage.flush();
            outImage.close();
            in.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Util.class, (String)"IMAGE_COPY_ERROR"));
            return false;
        }
        File wsJarFile = new File(inJarFileName);
        JarUtil jarUtil = new JarUtil(wsJarFile);
        jarUtil.addDirectory(new File(wsdl2Java.getOutputDirectory()));
        return true;
    }

    public static String upperCaseFirstChar(String inString) {
        if (null == inString) {
            throw new IllegalArgumentException("Null string passed!");
        }
        String returnString = new String(inString);
        String firstCharacter = returnString.substring(0, 1);
        returnString = firstCharacter.toUpperCase() + returnString.substring(1);
        return returnString;
    }

    public static String getProperPortName(String inPortName) {
        String returnString = "";
        if (inPortName.indexOf(".") == -1) {
            returnString = Util.upperCaseFirstChar(inPortName);
            return returnString;
        }
        StringTokenizer tokenizer = new StringTokenizer(inPortName, ".");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            returnString = returnString + Util.upperCaseFirstChar(currentToken);
        }
        return returnString;
    }

    public static String[] getRunTimeJarFiles() throws WebServiceException {
        ArrayList<String> returnJarFileNames = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pe) {
            ErrorManager.getDefault().notify((Throwable)pe);
            ErrorManager.getDefault().log("Util.getRunTimeJarFiles: ParserConfigurationException=" + pe);
            throw new WebServiceException(NbBundle.getMessage(Util.class, (String)"ERROR_READING_RUNTIMEJARS"), pe);
        }
        Document document = null;
        try {
            File runtimeJarsFile = InstalledFileLocator.getDefault().locate("config" + File.separator + "WebServices" + File.separator + "websvc_runtimejars.xml", null, false);
            document = builder.parse(runtimeJarsFile);
        }
        catch (SAXException se) {
            ErrorManager.getDefault().notify((Throwable)se);
            ErrorManager.getDefault().log("Util.getRunTimeJarFiles: SAXException=" + se);
            throw new WebServiceException(NbBundle.getMessage(Util.class, (String)"ERROR_READING_RUNTIMEJARS"), se);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            ErrorManager.getDefault().log("Util.getRunTimeJarFiles: IOException=" + ioe);
            throw new WebServiceException(NbBundle.getMessage(Util.class, (String)"ERROR_READING_RUNTIMEJARS"), ioe);
        }
        NodeList list = document.getElementsByTagName("Jar");
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        J2eePlatform platform = null;
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform p = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
            if (p == null || !p.isToolSupported("wscompile")) continue;
            platform = p;
            break;
        }
        File appserverRoot = platform == null ? null : platform.getPlatformRoots()[0];
        String asRootPath = appserverRoot != null ? appserverRoot.getAbsolutePath() : "";
        asRootPath = asRootPath.replace('\\', '/');
        Node currentNode = null;
        for (int ii = 0; ii < list.getLength(); ++ii) {
            currentNode = list.item(ii);
            String name = currentNode.getNodeName();
            String localName = currentNode.getLocalName();
            String value = currentNode.getNodeValue();
            NamedNodeMap nodeMap = currentNode.getAttributes();
            Node fileNode = nodeMap.getNamedItem("file");
            String jarString = "";
            try {
                jarString = fileNode.getNodeValue();
            }
            catch (DOMException de) {
                ErrorManager.getDefault().notify((Throwable)de);
                ErrorManager.getDefault().log("Util.getRunTimeJarFiles: DOMException=" + de);
                throw new WebServiceException(NbBundle.getMessage(Util.class, (String)"ERROR_READING_RUNTIMEJARS"), de);
            }
            if (jarString.indexOf("\\{appserv\\.home\\}") > -1) {
                jarString = jarString.replaceAll("\\{appserv\\.home\\}", asRootPath);
            } else {
                File f = InstalledFileLocator.getDefault().locate(jarString, null, false);
                if (f != null) {
                    jarString = f.getPath();
                }
            }
            returnJarFileNames.add(jarString);
        }
        return returnJarFileNames.toArray(new String[0]);
    }

    public static String getRuntimeClassPath() {
        String[] jarFileNames = null;
        String returnClassPath = "";
        try {
            jarFileNames = Util.getRunTimeJarFiles();
        }
        catch (WebServiceException wse) {
            StatusDisplayer.getDefault().setStatusText(wse.getMessage());
            return returnClassPath;
        }
        for (int ii = 0; null != jarFileNames && ii < jarFileNames.length; ++ii) {
            returnClassPath = returnClassPath + jarFileNames[ii];
            if (ii + 1 >= jarFileNames.length) continue;
            returnClassPath = returnClassPath + File.pathSeparator;
        }
        return returnClassPath;
    }

    public static boolean isValidPackageName(String inPackageName) {
        if (null == inPackageName || inPackageName.length() == 0) {
            return false;
        }
        if (inPackageName.indexOf("$") != -1) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(inPackageName, ".");
        if (tokenizer.hasMoreTokens()) {
            String currentLevel = null;
            while (tokenizer.hasMoreTokens()) {
                currentLevel = tokenizer.nextToken();
                if (!Character.isJavaIdentifierStart(currentLevel.charAt(0))) {
                    return false;
                }
                for (int ii = 0; ii < currentLevel.length(); ++ii) {
                    if (Character.isJavaIdentifierPart(currentLevel.charAt(ii))) continue;
                    return false;
                }
            }
        } else {
            if (!Character.isJavaIdentifierStart(inPackageName.charAt(0))) {
                return false;
            }
            for (int ii = 0; ii < inPackageName.length(); ++ii) {
                if (Character.isJavaIdentifierPart(inPackageName.charAt(ii))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIdentifier(String inIdentifier) {
        if (null == inIdentifier || inIdentifier.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(inIdentifier.charAt(0))) {
            return false;
        }
        for (int ii = 0; ii < inIdentifier.length(); ++ii) {
            if (Character.isJavaIdentifierPart(inIdentifier.charAt(ii))) continue;
            return false;
        }
        return true;
    }

    public static String getParameterType(Port inPort, JavaParameter inParameter) {
        String parameterType = "";
        ClientProcessorEnvironment env = new ClientProcessorEnvironment((OutputStream)new ByteArrayOutputStream(), null, null);
        parameterType = inParameter.isHolder() ? (inParameter.getHolderName() == null ? env.getNames().holderClassName(inPort, inParameter.getType()) : inParameter.getHolderName()) : inParameter.getType().getName();
        return parameterType;
    }
}

