/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.AnnotationMark;
import org.netbeans.modules.editor.errorstripe.AnnotationView;
import org.netbeans.modules.editor.errorstripe.AnnotationViewData;
import org.netbeans.modules.editor.errorstripe.apimodule.SPIAccessor;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProviderCreator;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

final class AnnotationViewDataImpl
implements PropertyChangeListener,
AnnotationViewData,
Annotations.AnnotationsListener {
    private static final ErrorManager ERR = AnnotationView.ERR;
    private AnnotationView view;
    private JTextComponent pane;
    private BaseDocument document;
    private List providers = new ArrayList();
    private List upToDateStatusProviders = new ArrayList();
    private List currentMarks = null;
    private SortedMap marksMap = null;

    public AnnotationViewDataImpl(AnnotationView view, JTextComponent pane) {
        this.view = view;
        this.pane = pane;
        this.document = null;
    }

    public void register(BaseDocument document) {
        this.document = document;
        this.gatherProviders(this.pane);
        this.addListenersToProviders();
        if (document != null) {
            document.getAnnotations().addAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.currentMarks = null;
        this.marksMap = null;
    }

    public void unregister() {
        if (this.document != null) {
            this.document.getAnnotations().removeAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.removeListenersFromProviders();
        this.document = null;
    }

    private void gatherProviders(JTextComponent pane) {
        long start = System.currentTimeMillis();
        try {
            Lookup baseLookup;
            DataObject baseDO;
            BaseKit kit = Utilities.getKit((JTextComponent)pane);
            if (kit == null) {
                return;
            }
            String content = kit.getContentType();
            BaseDocument document = (BaseDocument)pane.getDocument();
            FileObject baseFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors/text/base/UpToDateStatusProvider");
            FileObject contentFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + content + "/UpToDateStatusProvider");
            if (ERR.isLoggable(1)) {
                ERR.log(1, "baseFolder = " + baseFolder);
            }
            DataObject dataObject = baseDO = baseFolder != null ? DataObject.find((FileObject)baseFolder) : null;
            if (ERR.isLoggable(1)) {
                ERR.log(1, "baseDO = " + baseDO);
            }
            Lookup lookup = baseLookup = baseFolder != null ? new FolderLookup((DataObject.Container)((DataFolder)baseDO)).getLookup() : Lookup.EMPTY;
            if (ERR.isLoggable(1)) {
                ERR.log(1, "contentFolder = " + contentFolder);
            }
            DataObject contentDO = contentFolder != null ? DataObject.find((FileObject)contentFolder) : null;
            Lookup contentLookup = contentFolder != null ? new FolderLookup((DataObject.Container)((DataFolder)contentDO)).getLookup() : Lookup.EMPTY;
            ProxyLookup lookup2 = new ProxyLookup(new Lookup[]{baseLookup, contentLookup});
            Lookup.Result creators = lookup2.lookup(new Lookup.Template(MarkProviderCreator.class));
            ArrayList<MarkProvider> markProviders = new ArrayList<MarkProvider>();
            Iterator i = creators.allInstances().iterator();
            while (i.hasNext()) {
                MarkProvider provider;
                MarkProviderCreator creator = (MarkProviderCreator)i.next();
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "creator = " + creator);
                }
                if ((provider = creator.createMarkProvider(pane)) == null) continue;
                markProviders.add(provider);
            }
            this.providers = markProviders;
            Lookup.Result updsCreators = lookup2.lookup(new Lookup.Template(UpToDateStatusProviderFactory.class));
            ArrayList<UpToDateStatusProvider> updsProviders = new ArrayList<UpToDateStatusProvider>();
            Iterator i2 = updsCreators.allInstances().iterator();
            while (i2.hasNext()) {
                UpToDateStatusProvider provider;
                UpToDateStatusProviderFactory creator = (UpToDateStatusProviderFactory)i2.next();
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "creator = " + creator);
                }
                if ((provider = creator.createUpToDateStatusProvider(pane.getDocument())) == null) continue;
                updsProviders.add(provider);
            }
            this.upToDateStatusProviders = updsProviders;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (AnnotationView.TIMING_ERR.isLoggable(1)) {
            AnnotationView.TIMING_ERR.log(1, "gather providers took: " + (end - start));
        }
    }

    private void addListenersToProviders() {
        Object provider;
        Iterator p = this.upToDateStatusProviders.iterator();
        while (p.hasNext()) {
            provider = (UpToDateStatusProvider)p.next();
            SPIAccessor.getDefault().addPropertyChangeListener((UpToDateStatusProvider)provider, (PropertyChangeListener)this);
        }
        p = this.providers.iterator();
        while (p.hasNext()) {
            provider = (MarkProvider)p.next();
            ((MarkProvider)provider).addPropertyChangeListener(this);
        }
    }

    private void removeListenersFromProviders() {
        Object provider;
        Iterator p = this.upToDateStatusProviders.iterator();
        while (p.hasNext()) {
            provider = (UpToDateStatusProvider)p.next();
            SPIAccessor.getDefault().removePropertyChangeListener((UpToDateStatusProvider)provider, (PropertyChangeListener)this);
        }
        p = this.providers.iterator();
        while (p.hasNext()) {
            provider = (MarkProvider)p.next();
            ((MarkProvider)provider).removePropertyChangeListener(this);
        }
    }

    static List createMergedMarks(List providers) {
        ArrayList result = new ArrayList();
        Iterator p = providers.iterator();
        while (p.hasNext()) {
            MarkProvider provider = (MarkProvider)p.next();
            result.addAll(provider.getMarks());
        }
        return result;
    }

    synchronized List getMergedMarks() {
        if (this.currentMarks == null) {
            this.currentMarks = AnnotationViewDataImpl.createMergedMarks(this.providers);
        }
        return this.currentMarks;
    }

    static List getStatusesForLineImpl(int line, SortedMap marks) {
        List inside = (List)marks.get(new Integer(line));
        if (inside == null) {
            return Collections.EMPTY_LIST;
        }
        return inside;
    }

    public Mark getMainMarkForBlock(int startLine, int endLine) {
        Mark m1 = AnnotationViewDataImpl.getMainMarkForBlockImpl(startLine, endLine, this.getMarkMap());
        Mark m2 = this.getMainMarkForBlockAnnotations(startLine, endLine);
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        if (AnnotationViewDataImpl.isMoreImportant(m1, m2)) {
            return m1;
        }
        return m2;
    }

    static Mark getMainMarkForBlockImpl(int startLine, int endLine, SortedMap marks) {
        int current = startLine - 1;
        Mark found = null;
        while ((current = AnnotationViewDataImpl.findNextUsedLine(current, marks)) != Integer.MAX_VALUE && current <= endLine) {
            Iterator i = AnnotationViewDataImpl.getStatusesForLineImpl(current, marks).iterator();
            while (i.hasNext()) {
                Mark newMark = (Mark)i.next();
                if (found != null && !AnnotationViewDataImpl.isMoreImportant(newMark, found)) continue;
                found = newMark;
            }
        }
        return found;
    }

    private static boolean isMoreImportant(Mark m1, Mark m2) {
        int compared = m1.getStatus().compareTo(m2.getStatus());
        if (compared == 0) {
            return m1.getPriority() < m2.getPriority();
        }
        return compared > 0;
    }

    private boolean isMoreImportant(AnnotationDesc a1, AnnotationDesc a2) {
        AnnotationType t1 = a1.getAnnotationTypeInstance();
        AnnotationType t2 = a2.getAnnotationTypeInstance();
        int compared = t1.getSeverity().compareTo((Object)t2.getSeverity());
        if (compared == 0) {
            return t1.getPriority() < t2.getPriority();
        }
        return compared > 0;
    }

    private boolean isValidForErrorStripe(AnnotationDesc a) {
        return a.getAnnotationTypeInstance().getSeverity() != AnnotationType.Severity.STATUS_NONE;
    }

    private Mark getMainMarkForBlockAnnotations(int startLine, int endLine) {
        int line = startLine;
        AnnotationDesc foundDesc = null;
        Annotations annotations = this.document.getAnnotations();
        while ((line = annotations.getNextLineWithAnnotation(line)) <= endLine && line != -1) {
            AnnotationDesc desc = annotations.getActiveAnnotation(line);
            if (desc != null && (foundDesc == null || this.isMoreImportant(desc, foundDesc)) && this.isValidForErrorStripe(desc)) {
                foundDesc = desc;
            }
            if (annotations.getNumberOfAnnotations(line) > 1) {
                AnnotationDesc[] descriptions = annotations.getPasiveAnnotations(line);
                for (int cntr = 0; cntr < descriptions.length; ++cntr) {
                    if (foundDesc != null && !this.isMoreImportant(descriptions[cntr], foundDesc) || !this.isValidForErrorStripe(descriptions[cntr])) continue;
                    foundDesc = descriptions[cntr];
                }
            }
            ++line;
        }
        if (foundDesc != null) {
            return new AnnotationMark(foundDesc);
        }
        return null;
    }

    public int findNextUsedLine(int from) {
        int line1 = AnnotationViewDataImpl.findNextUsedLine(from, this.getMarkMap());
        int line2 = this.document.getAnnotations().getNextLineWithAnnotation(from + 1);
        if (line2 == -1) {
            line2 = Integer.MAX_VALUE;
        }
        return line1 < line2 ? line1 : line2;
    }

    static int findNextUsedLine(int from, SortedMap marks) {
        SortedMap next = marks.tailMap(new Integer(from + 1));
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.findNextUsedLine from: " + from);
            ERR.log("AnnotationView.findNextUsedLine marks: " + marks);
            ERR.log("AnnotationView.findNextUsedLine next: " + next);
        }
        if (next.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        Integer nextLine = next.firstKey();
        return nextLine;
    }

    private void registerMark(Mark mark) {
        int[] span = mark.getAssignedLines();
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.registerMark mark: " + mark);
            ERR.log("AnnotationView.registerMark lines from-to: " + span[0] + "-" + span[1]);
        }
        for (int line = span[0]; line <= span[1]; ++line) {
            Integer lineInt = new Integer(line);
            ArrayList<Mark> inside = (ArrayList<Mark>)this.marksMap.get(lineInt);
            if (inside == null) {
                inside = new ArrayList<Mark>();
                this.marksMap.put(lineInt, inside);
            }
            inside.add(mark);
        }
    }

    private void unregisterMark(Mark mark) {
        int[] span = mark.getAssignedLines();
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.unregisterMark mark: " + mark);
            ERR.log("AnnotationView.unregisterMark lines from-to: " + span[0] + "-" + span[1]);
        }
        for (int line = span[0]; line <= span[1]; ++line) {
            Integer lineInt = new Integer(line);
            List inside = (List)this.marksMap.get(lineInt);
            if (inside == null) continue;
            inside.remove(mark);
            if (inside.size() != 0) continue;
            this.marksMap.remove(lineInt);
        }
    }

    synchronized SortedMap getMarkMap() {
        if (this.marksMap == null) {
            List marks = this.getMergedMarks();
            this.marksMap = new TreeMap();
            Iterator i = marks.iterator();
            while (i.hasNext()) {
                Mark mark = (Mark)i.next();
                this.registerMark(mark);
            }
        }
        return this.marksMap;
    }

    public Status computeTotalStatus() {
        Status targetStatus = Status.STATUS_OK;
        List marks = this.getMergedMarks();
        Iterator m = marks.iterator();
        while (m.hasNext()) {
            Mark mark = (Mark)m.next();
            Status s = mark.getStatus();
            targetStatus = Status.getCompoundStatus(s, targetStatus);
        }
        Annotations annotations = this.document.getAnnotations();
        int line = -1;
        while ((line = annotations.getNextLineWithAnnotation(line)) != -1) {
            Status s;
            AnnotationDesc desc = annotations.getActiveAnnotation(line);
            if (desc != null && (s = AnnotationViewDataImpl.get(desc.getAnnotationTypeInstance())) != null) {
                targetStatus = Status.getCompoundStatus(s, targetStatus);
            }
            if (annotations.getNumberOfAnnotations(line) > 1) {
                AnnotationDesc[] descriptions = annotations.getPasiveAnnotations(line);
                for (int cntr = 0; cntr < descriptions.length; ++cntr) {
                    Status s2 = AnnotationViewDataImpl.get(descriptions[cntr].getAnnotationTypeInstance());
                    if (s2 == null) continue;
                    targetStatus = Status.getCompoundStatus(s2, targetStatus);
                }
            }
            ++line;
        }
        return targetStatus;
    }

    public UpToDateStatus computeTotalStatusType() {
        if (this.upToDateStatusProviders.isEmpty()) {
            return UpToDateStatus.UP_TO_DATE_DIRTY;
        }
        UpToDateStatus statusType = UpToDateStatus.UP_TO_DATE_OK;
        Iterator p = this.upToDateStatusProviders.iterator();
        while (p.hasNext()) {
            UpToDateStatusProvider provider = (UpToDateStatusProvider)p.next();
            UpToDateStatus newType = provider.getUpToDate();
            if (newType.compareTo((Object)statusType) <= 0) continue;
            statusType = newType;
        }
        return statusType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if ("marks".equals(evt.getPropertyName())) {
            AnnotationViewDataImpl annotationViewDataImpl = this;
            synchronized (annotationViewDataImpl) {
                Collection nue = (Collection)evt.getNewValue();
                Collection old = (Collection)evt.getOldValue();
                if (nue == null && evt.getSource() instanceof MarkProvider) {
                    nue = ((MarkProvider)evt.getSource()).getMarks();
                }
                if (old != null && nue != null) {
                    ArrayList added = new ArrayList(nue);
                    ArrayList removed = new ArrayList(old);
                    added.removeAll(old);
                    removed.removeAll(nue);
                    if (this.marksMap != null) {
                        Iterator i = removed.iterator();
                        while (i.hasNext()) {
                            this.unregisterMark((Mark)i.next());
                        }
                        i = added.iterator();
                        while (i.hasNext()) {
                            this.registerMark((Mark)i.next());
                        }
                    }
                    if (this.currentMarks != null) {
                        this.currentMarks.removeAll(removed);
                        this.currentMarks.addAll(added);
                    }
                    this.view.fullRepaint();
                } else {
                    ErrorManager.getDefault().log(16, "For performance reasons, the providers should fill both old and new value in property changes. Problematic event: " + evt);
                    this.clear();
                    this.view.fullRepaint();
                }
                return;
            }
        }
        if ("upToDate".equals(evt.getPropertyName())) {
            this.view.fullRepaint(false);
            return;
        }
    }

    public void clear() {
        this.currentMarks = null;
        this.marksMap = null;
    }

    public int[] computeErrorsAndWarnings() {
        int errors = 0;
        int warnings = 0;
        List marks = this.getMergedMarks();
        Iterator m = marks.iterator();
        while (m.hasNext()) {
            Mark mark = (Mark)m.next();
            Status s = mark.getStatus();
            errors += s == Status.STATUS_ERROR ? 1 : 0;
            warnings += s == Status.STATUS_WARNING ? 1 : 0;
        }
        Annotations annotations = this.document.getAnnotations();
        int line = -1;
        while ((line = annotations.getNextLineWithAnnotation(line)) != -1) {
            Status s;
            AnnotationDesc desc = annotations.getActiveAnnotation(line);
            if (desc != null && (s = AnnotationViewDataImpl.get(desc.getAnnotationTypeInstance())) != null) {
                errors += s == Status.STATUS_ERROR ? 1 : 0;
                warnings += s == Status.STATUS_WARNING ? 1 : 0;
            }
            if (annotations.getNumberOfAnnotations(line) > 1) {
                AnnotationDesc[] descriptions = annotations.getPasiveAnnotations(line);
                for (int cntr = 0; cntr < descriptions.length; ++cntr) {
                    Status s2 = AnnotationViewDataImpl.get(descriptions[cntr].getAnnotationTypeInstance());
                    if (s2 == null) continue;
                    errors += s2 == Status.STATUS_ERROR ? 1 : 0;
                    warnings += s2 == Status.STATUS_WARNING ? 1 : 0;
                }
            }
            ++line;
        }
        return new int[]{errors, warnings};
    }

    public void changedLine(int Line) {
        this.changedAll();
    }

    public void changedAll() {
        this.view.fullRepaint(false);
    }

    static Status get(AnnotationType.Severity severity) {
        if (severity == AnnotationType.Severity.STATUS_ERROR) {
            return Status.STATUS_ERROR;
        }
        if (severity == AnnotationType.Severity.STATUS_WARNING) {
            return Status.STATUS_WARNING;
        }
        if (severity == AnnotationType.Severity.STATUS_OK) {
            return Status.STATUS_OK;
        }
        return null;
    }

    static Status get(AnnotationType ann) {
        return AnnotationViewDataImpl.get(ann.getSeverity());
    }
}

