/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ide;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.ErrorManager;
import org.xml.sax.SAXException;

public class DebugSupport {
    private static final String JSP_SERVLET_NAME = "jsp";
    private static final String JSP_SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    private static final String MAPPED_PARAM_NAME = "mappedfile";
    private static final String MAPPED_PARAM_VALUE = "true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowDebugging(TomcatManager tm) throws IOException, SAXException {
        String url = tm.getUri();
        File webXML = DebugSupport.getDefaultWebXML(tm);
        if (webXML == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(url));
            return;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(webXML);
        if (webApp == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(url));
            return;
        }
        boolean needsSave = DebugSupport.setMappedProperty(webApp);
        if (needsSave) {
            FileOutputStream os = new FileOutputStream(webXML);
            try {
                webApp.write((OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    private static File getDefaultWebXML(TomcatManager tm) {
        File cb = tm.getTomcatProperties().getCatalinaDir();
        File webXML = new File(cb, "conf" + File.separator + "web.xml");
        if (webXML.exists()) {
            return webXML;
        }
        return null;
    }

    private static boolean setMappedProperty(WebApp webApp) {
        int i;
        boolean changed = false;
        boolean isServlet = false;
        Servlet[] servlets = webApp.getServlet();
        for (i = 0; i < servlets.length; ++i) {
            if (!servlets[i].getServletName().equals(JSP_SERVLET_NAME) || !servlets[i].getServletClass().equals(JSP_SERVLET_CLASS)) continue;
            isServlet = true;
            break;
        }
        if (!isServlet) {
            try {
                Servlet servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName(JSP_SERVLET_NAME);
                servlet.setServletClass(JSP_SERVLET_CLASS);
                InitParam initParam = (InitParam)servlet.createBean("InitParam");
                initParam.setParamName(MAPPED_PARAM_NAME);
                initParam.setParamValue(MAPPED_PARAM_VALUE);
                servlet.addInitParam(initParam);
                webApp.addServlet(servlet);
                changed = true;
            }
            catch (ClassNotFoundException ex) {
                TomcatManager.ERR.notify((Throwable)ex);
            }
        } else {
            try {
                int j;
                boolean isInitparam = false;
                InitParam[] initparams = servlets[i].getInitParam();
                for (j = 0; j < initparams.length; ++j) {
                    if (!initparams[j].getParamName().equals(MAPPED_PARAM_NAME)) continue;
                    isInitparam = true;
                    break;
                }
                if (isInitparam) {
                    if (!initparams[j].getParamValue().equals(MAPPED_PARAM_VALUE)) {
                        initparams[j].setParamValue(MAPPED_PARAM_VALUE);
                        changed = true;
                    }
                } else {
                    InitParam initParam = (InitParam)servlets[i].createBean("InitParam");
                    initParam.setParamName(MAPPED_PARAM_NAME);
                    initParam.setParamValue(MAPPED_PARAM_VALUE);
                    servlets[i].addInitParam(initParam);
                    changed = true;
                }
            }
            catch (ClassNotFoundException ex) {
                TomcatManager.ERR.notify((Throwable)ex);
            }
        }
        return changed;
    }
}

