/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaProjectGenerator {
    private static final String[] rootElementsOrder;
    private static final String[] viewElementsOrder;
    private static final String[] folderElementsOrder;
    private static final String[] viewItemElementsOrder;
    private static final String NS_GENERAL = "http://www.netbeans.org/ns/freeform-project/1";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static List getSourceFolders(AntProjectHelper helper, String type) {
        ArrayList<SourceFolder> list = new ArrayList<SourceFolder>();
        Element data = helper.getPrimaryConfigurationData(true);
        Element foldersEl = Util.findElement((Element)data, (String)"folders", (String)NS_GENERAL);
        if (foldersEl == null) {
            return list;
        }
        List sourceFolders = Util.findSubElements((Element)foldersEl);
        Iterator it = sourceFolders.iterator();
        while (it.hasNext()) {
            Element sourceFolderEl = (Element)it.next();
            if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
            SourceFolder sf = new SourceFolder();
            Element el = Util.findElement((Element)sourceFolderEl, (String)"label", (String)NS_GENERAL);
            if (el != null) {
                sf.label = Util.findText((Element)el);
            }
            if ((el = Util.findElement((Element)sourceFolderEl, (String)"type", (String)NS_GENERAL)) != null) {
                sf.type = Util.findText((Element)el);
            }
            if ((el = Util.findElement((Element)sourceFolderEl, (String)"location", (String)NS_GENERAL)) != null) {
                sf.location = Util.findText((Element)el);
            }
            if (type != null && !type.equals(sf.type)) continue;
            if (sf.label == null || sf.label.length() == 0) {
                throw new IllegalArgumentException("label element is empty or not specified. " + helper.getProjectDirectory());
            }
            if (sf.location == null || sf.location.length() == 0) {
                throw new IllegalArgumentException("location element is empty or not specified. " + helper.getProjectDirectory());
            }
            list.add(sf);
        }
        return list;
    }

    public static void putSourceFolders(AntProjectHelper helper, List sources, String type) {
        Element sourceFolderEl;
        ArrayList list = new ArrayList();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element foldersEl = Util.findElement((Element)data, (String)"folders", (String)NS_GENERAL);
        if (foldersEl == null) {
            foldersEl = doc.createElementNS(NS_GENERAL, "folders");
            Util.appendChildElement((Element)data, (Element)foldersEl, (String[])rootElementsOrder);
        } else {
            List sourceFolders = Util.findSubElements((Element)foldersEl);
            Iterator it = sourceFolders.iterator();
            while (it.hasNext()) {
                String typeElValue;
                sourceFolderEl = (Element)it.next();
                if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
                if (type == null) {
                    foldersEl.removeChild(sourceFolderEl);
                    continue;
                }
                Element typeEl = Util.findElement((Element)sourceFolderEl, (String)"type", (String)NS_GENERAL);
                if (typeEl == null || !type.equals(typeElValue = Util.findText((Element)typeEl))) continue;
                foldersEl.removeChild(sourceFolderEl);
            }
        }
        Iterator it2 = sources.iterator();
        while (it2.hasNext()) {
            SourceFolder sf = (SourceFolder)it2.next();
            sourceFolderEl = doc.createElementNS(NS_GENERAL, "source-folder");
            if (sf.label == null || sf.label.length() <= 0) {
                throw new IllegalArgumentException("label cannot be empty. " + helper.getProjectDirectory());
            }
            Element el = doc.createElementNS(NS_GENERAL, "label");
            el.appendChild(doc.createTextNode(sf.label));
            sourceFolderEl.appendChild(el);
            if (sf.type != null) {
                el = doc.createElementNS(NS_GENERAL, "type");
                el.appendChild(doc.createTextNode(sf.type));
                sourceFolderEl.appendChild(el);
            }
            if (sf.location == null || sf.location.length() <= 0) {
                throw new IllegalArgumentException("location cannot be empty. " + helper.getProjectDirectory());
            }
            el = doc.createElementNS(NS_GENERAL, "location");
            el.appendChild(doc.createTextNode(sf.location));
            sourceFolderEl.appendChild(el);
            Util.appendChildElement((Element)foldersEl, (Element)sourceFolderEl, (String[])folderElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List getSourceViews(AntProjectHelper helper, String style) {
        ArrayList<SourceFolder> list = new ArrayList<SourceFolder>();
        Element data = helper.getPrimaryConfigurationData(true);
        Element viewEl = Util.findElement((Element)data, (String)"view", (String)NS_GENERAL);
        if (viewEl == null) {
            return list;
        }
        Element itemsEl = Util.findElement((Element)viewEl, (String)"items", (String)NS_GENERAL);
        if (itemsEl == null) {
            return list;
        }
        Iterator it = Util.findSubElements((Element)itemsEl).iterator();
        while (it.hasNext()) {
            Element sourceFolderEl = (Element)it.next();
            if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
            SourceFolder sf = new SourceFolder();
            sf.style = sourceFolderEl.getAttribute("style");
            if (!($assertionsDisabled || sf.style != null && sf.style.length() > 0)) {
                throw new AssertionError((Object)("Bad style attr on <source-folder> in " + helper));
            }
            Element el = Util.findElement((Element)sourceFolderEl, (String)"label", (String)NS_GENERAL);
            if (el != null) {
                sf.label = Util.findText((Element)el);
            }
            if ((el = Util.findElement((Element)sourceFolderEl, (String)"location", (String)NS_GENERAL)) != null) {
                sf.location = Util.findText((Element)el);
            }
            if (style != null && !style.equals(sf.style)) continue;
            list.add(sf);
        }
        return list;
    }

    public static void putSourceViews(AntProjectHelper helper, List sources, String style) {
        Element itemsEl;
        ArrayList list = new ArrayList();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element viewEl = Util.findElement((Element)data, (String)"view", (String)NS_GENERAL);
        if (viewEl == null) {
            viewEl = doc.createElementNS(NS_GENERAL, "view");
            Util.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((itemsEl = Util.findElement((Element)viewEl, (String)"items", (String)NS_GENERAL)) == null) {
            itemsEl = doc.createElementNS(NS_GENERAL, "items");
            Util.appendChildElement((Element)viewEl, (Element)itemsEl, (String[])viewElementsOrder);
        }
        List sourceViews = Util.findSubElements((Element)itemsEl);
        Iterator it = sourceViews.iterator();
        while (it.hasNext()) {
            Element sourceViewEl = (Element)it.next();
            if (!sourceViewEl.getLocalName().equals("source-folder")) continue;
            String sourceStyle = sourceViewEl.getAttribute("style");
            if (style != null && !style.equals(sourceStyle)) continue;
            itemsEl.removeChild(sourceViewEl);
        }
        Iterator it2 = sources.iterator();
        while (it2.hasNext()) {
            Element el;
            SourceFolder sf = (SourceFolder)it2.next();
            if (sf.style == null || sf.style.length() == 0) continue;
            Element sourceFolderEl = doc.createElementNS(NS_GENERAL, "source-folder");
            sourceFolderEl.setAttribute("style", sf.style);
            if (sf.label != null) {
                el = doc.createElementNS(NS_GENERAL, "label");
                el.appendChild(doc.createTextNode(sf.label));
                sourceFolderEl.appendChild(el);
            }
            if (sf.location != null) {
                el = doc.createElementNS(NS_GENERAL, "location");
                el.appendChild(doc.createTextNode(sf.location));
                sourceFolderEl.appendChild(el);
            }
            Util.appendChildElement((Element)itemsEl, (Element)sourceFolderEl, (String[])viewItemElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List getJavaCompilationUnits(AntProjectHelper helper, AuxiliaryConfiguration aux) {
        ArrayList<JavaCompilationUnit> list = new ArrayList<JavaCompilationUnit>();
        Element data = aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (data == null) {
            data = aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
        }
        if (data == null) {
            return list;
        }
        List cus = Util.findSubElements((Element)data);
        Iterator it = cus.iterator();
        while (it.hasNext()) {
            Element cuEl = (Element)it.next();
            JavaCompilationUnit cu = new JavaCompilationUnit();
            ArrayList<String> outputs = new ArrayList<String>();
            ArrayList<String> javadoc = new ArrayList<String>();
            ArrayList<JavaCompilationUnit.CP> cps = new ArrayList<JavaCompilationUnit.CP>();
            ArrayList<String> packageRoots = new ArrayList<String>();
            Iterator it2 = Util.findSubElements((Element)cuEl).iterator();
            while (it2.hasNext()) {
                Element el = (Element)it2.next();
                if (el.getLocalName().equals("package-root")) {
                    packageRoots.add(Util.findText((Element)el));
                    continue;
                }
                if (el.getLocalName().equals("classpath")) {
                    JavaCompilationUnit.CP cp = new JavaCompilationUnit.CP();
                    cp.classpath = Util.findText((Element)el);
                    cp.mode = el.getAttribute("mode");
                    if (cp.mode == null || cp.classpath == null) continue;
                    cps.add(cp);
                    continue;
                }
                if (el.getLocalName().equals("built-to")) {
                    outputs.add(Util.findText((Element)el));
                    continue;
                }
                if (el.getLocalName().equals("javadoc-built-to")) {
                    javadoc.add(Util.findText((Element)el));
                    continue;
                }
                if (el.getLocalName().equals("source-level")) {
                    cu.sourceLevel = Util.findText((Element)el);
                }
                if (!el.getLocalName().equals("unit-tests")) continue;
                cu.isTests = true;
            }
            cu.output = outputs.size() > 0 ? outputs : null;
            cu.javadoc = javadoc.size() > 0 ? javadoc : null;
            cu.classpath = cps.size() > 0 ? cps : null;
            cu.packageRoots = packageRoots.size() > 0 ? packageRoots : null;
            list.add(cu);
        }
        return list;
    }

    public static void putJavaCompilationUnits(AntProjectHelper helper, AuxiliaryConfiguration aux, List compUnits) {
        String namespace;
        Element data;
        boolean need2 = false;
        Iterator cuIt = compUnits.iterator();
        while (cuIt.hasNext()) {
            JavaCompilationUnit unit = (JavaCompilationUnit)cuIt.next();
            if (!unit.isTests && (unit.javadoc == null || unit.javadoc.isEmpty())) continue;
            need2 = true;
            break;
        }
        if ((data = aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true)) != null) {
            namespace = "http://www.netbeans.org/ns/freeform-project-java/2";
        } else {
            namespace = need2 ? "http://www.netbeans.org/ns/freeform-project-java/2" : "http://www.netbeans.org/ns/freeform-project-java/1";
            data = aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
            if (data != null) {
                if (need2) {
                    aux.removeConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
                    data = helper.getPrimaryConfigurationData(true).getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project-java/2", "java-data");
                }
            } else {
                data = helper.getPrimaryConfigurationData(true).getOwnerDocument().createElementNS(namespace, "java-data");
            }
        }
        Document doc = data.getOwnerDocument();
        List cus = Util.findSubElements((Element)data);
        Iterator it = cus.iterator();
        while (it.hasNext()) {
            Element cuEl = (Element)it.next();
            data.removeChild(cuEl);
        }
        Iterator it2 = compUnits.iterator();
        while (it2.hasNext()) {
            Element el;
            Iterator it3;
            Element cuEl = doc.createElementNS(namespace, "compilation-unit");
            data.appendChild(cuEl);
            JavaCompilationUnit cu = (JavaCompilationUnit)it2.next();
            if (cu.packageRoots != null) {
                it3 = cu.packageRoots.iterator();
                while (it3.hasNext()) {
                    String packageRoot = (String)it3.next();
                    el = doc.createElementNS(namespace, "package-root");
                    el.appendChild(doc.createTextNode(packageRoot));
                    cuEl.appendChild(el);
                }
            }
            if (cu.isTests) {
                if (!$assertionsDisabled && !namespace.equals("http://www.netbeans.org/ns/freeform-project-java/2")) {
                    throw new AssertionError();
                }
                cuEl.appendChild(doc.createElementNS(namespace, "unit-tests"));
            }
            if (cu.classpath != null) {
                it3 = cu.classpath.iterator();
                while (it3.hasNext()) {
                    JavaCompilationUnit.CP cp = (JavaCompilationUnit.CP)it3.next();
                    el = doc.createElementNS(namespace, "classpath");
                    el.appendChild(doc.createTextNode(cp.classpath));
                    el.setAttribute("mode", cp.mode);
                    cuEl.appendChild(el);
                }
            }
            if (cu.output != null) {
                it3 = cu.output.iterator();
                while (it3.hasNext()) {
                    String output = (String)it3.next();
                    el = doc.createElementNS(namespace, "built-to");
                    el.appendChild(doc.createTextNode(output));
                    cuEl.appendChild(el);
                }
            }
            if (cu.javadoc != null) {
                it3 = cu.javadoc.iterator();
                while (it3.hasNext()) {
                    String javadoc = (String)it3.next();
                    if (!$assertionsDisabled && !namespace.equals("http://www.netbeans.org/ns/freeform-project-java/2")) {
                        throw new AssertionError();
                    }
                    el = doc.createElementNS(namespace, "javadoc-built-to");
                    el.appendChild(doc.createTextNode(javadoc));
                    cuEl.appendChild(el);
                }
            }
            if (cu.sourceLevel == null) continue;
            el = doc.createElementNS(namespace, "source-level");
            el.appendChild(doc.createTextNode(cu.sourceLevel));
            cuEl.appendChild(el);
        }
        aux.putConfigurationFragment(data, true);
    }

    public static List guessExports(PropertyEvaluator evaluator, File baseFolder, List targetMappings, List javaCompilationUnits) {
        ArrayList<Export> exports = new ArrayList<Export>();
        String targetName = null;
        String scriptName = null;
        Iterator it = targetMappings.iterator();
        while (it.hasNext()) {
            TargetMapping tm = (TargetMapping)it.next();
            if (!tm.name.equals("build")) continue;
            if (tm.targets.size() == 1) {
                targetName = (String)tm.targets.get(0);
                scriptName = tm.script;
                continue;
            }
            return new ArrayList();
        }
        if (targetName == null) {
            return new ArrayList();
        }
        it = javaCompilationUnits.iterator();
        while (it.hasNext()) {
            JavaCompilationUnit cu = (JavaCompilationUnit)it.next();
            if (cu.output == null) continue;
            Iterator it2 = cu.output.iterator();
            while (it2.hasNext()) {
                Export e;
                String output = (String)it2.next();
                String output2 = evaluator.evaluate(output);
                if (output2.endsWith(".jar")) {
                    e = new Export();
                    e.type = "jar";
                    e.location = output;
                    e.script = scriptName;
                    e.buildTarget = targetName;
                    exports.add(e);
                    continue;
                }
                if (!JavaProjectGenerator.isFolder(evaluator, baseFolder, output2)) continue;
                e = new Export();
                e.type = "folder";
                e.location = output;
                e.script = scriptName;
                e.buildTarget = targetName;
                exports.add(e);
            }
        }
        return exports;
    }

    public static void putExports(AntProjectHelper helper, List exports) {
        ArrayList list = new ArrayList();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Iterator it = Util.findSubElements((Element)data).iterator();
        while (it.hasNext()) {
            Element exportEl = (Element)it.next();
            if (!exportEl.getLocalName().equals("export")) continue;
            data.removeChild(exportEl);
        }
        Iterator it2 = exports.iterator();
        while (it2.hasNext()) {
            Export export = (Export)it2.next();
            Element exportEl = doc.createElementNS(NS_GENERAL, "export");
            Element el = doc.createElementNS(NS_GENERAL, "type");
            el.appendChild(doc.createTextNode(export.type));
            exportEl.appendChild(el);
            el = doc.createElementNS(NS_GENERAL, "location");
            el.appendChild(doc.createTextNode(export.location));
            exportEl.appendChild(el);
            if (export.script != null) {
                el = doc.createElementNS(NS_GENERAL, "script");
                el.appendChild(doc.createTextNode(export.script));
                exportEl.appendChild(el);
            }
            el = doc.createElementNS(NS_GENERAL, "build-target");
            el.appendChild(doc.createTextNode(export.buildTarget));
            exportEl.appendChild(el);
            if (export.cleanTarget != null) {
                el = doc.createElementNS(NS_GENERAL, "clean-target");
                el.appendChild(doc.createTextNode(export.cleanTarget));
                exportEl.appendChild(el);
            }
            Util.appendChildElement((Element)data, (Element)exportEl, (String[])rootElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List guessSubprojects(PropertyEvaluator evaluator, List javaCompilationUnits, File projectBase, File freeformBase) {
        HashSet<String> subprojs = new HashSet<String>();
        Iterator it = javaCompilationUnits.iterator();
        while (it.hasNext()) {
            JavaCompilationUnit cu = (JavaCompilationUnit)it.next();
            if (cu.classpath == null) continue;
            Iterator it2 = cu.classpath.iterator();
            while (it2.hasNext()) {
                String classpath;
                JavaCompilationUnit.CP cp = (JavaCompilationUnit.CP)it2.next();
                if (!"compile".equals(cp.mode) || (classpath = evaluator.evaluate(cp.classpath)) == null) continue;
                String[] path = PropertyUtils.tokenizePath((String)classpath);
                for (int i = 0; i < path.length; ++i) {
                    File file = FileUtil.normalizeFile((File)new File(path[i]));
                    AntArtifact aa = AntArtifactQuery.findArtifactFromFile((File)file);
                    if (aa == null) continue;
                    File proj = FileUtil.toFile((FileObject)aa.getProject().getProjectDirectory());
                    String p = Util.relativizeLocation((File)projectBase, (File)freeformBase, (File)proj);
                    subprojs.add(p);
                }
            }
        }
        return new ArrayList(subprojs);
    }

    public static void putSubprojects(AntProjectHelper helper, List subprojects) {
        ArrayList list = new ArrayList();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element subproject = Util.findElement((Element)data, (String)"subprojects", (String)NS_GENERAL);
        if (subproject != null) {
            data.removeChild(subproject);
        }
        subproject = doc.createElementNS(NS_GENERAL, "subprojects");
        Util.appendChildElement((Element)data, (Element)subproject, (String[])rootElementsOrder);
        Iterator it = subprojects.iterator();
        while (it.hasNext()) {
            String proj = (String)it.next();
            Element projEl = doc.createElementNS(NS_GENERAL, "project");
            projEl.appendChild(doc.createTextNode(proj));
            subproject.appendChild(projEl);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List guessBuildFolders(PropertyEvaluator evaluator, List javaCompilationUnits, File projectBase, File freeformBase) {
        ArrayList<String> buildFolders = new ArrayList<String>();
        Iterator it = javaCompilationUnits.iterator();
        while (it.hasNext()) {
            JavaCompilationUnit cu = (JavaCompilationUnit)it.next();
            if (cu.output == null) continue;
            Iterator it2 = cu.output.iterator();
            while (it2.hasNext()) {
                String output = (String)it2.next();
                File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)freeformBase, (String)output);
                if (f.exists()) {
                    if (f.isFile()) {
                        f = f.getParentFile();
                    }
                } else if (f.getName().indexOf(46) != -1) {
                    f = f.getParentFile();
                }
                if (!(output = f.getAbsolutePath()).endsWith(File.separator)) {
                    output = output + File.separatorChar;
                }
                if (output.startsWith(projectBase.getAbsolutePath() + File.separatorChar) || output.startsWith(freeformBase.getAbsolutePath() + File.separatorChar)) continue;
                boolean add = true;
                Iterator it3 = buildFolders.iterator();
                while (it3.hasNext()) {
                    String path = (String)it3.next();
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separatorChar;
                    }
                    if (path.equals(output)) {
                        add = false;
                        break;
                    }
                    if (output.startsWith(path)) {
                        add = false;
                        break;
                    }
                    if (!path.startsWith(output)) continue;
                    it3.remove();
                }
                if (!add) continue;
                buildFolders.add(f.getAbsolutePath());
            }
        }
        return buildFolders;
    }

    public static void putBuildFolders(AntProjectHelper helper, List buildFolders) {
        Element buildFolderEl;
        ArrayList list = new ArrayList();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element foldersEl = Util.findElement((Element)data, (String)"folders", (String)NS_GENERAL);
        if (foldersEl == null) {
            foldersEl = doc.createElementNS(NS_GENERAL, "folders");
            Util.appendChildElement((Element)data, (Element)foldersEl, (String[])rootElementsOrder);
        } else {
            List folders = Util.findSubElements((Element)foldersEl);
            Iterator it = folders.iterator();
            while (it.hasNext()) {
                buildFolderEl = (Element)it.next();
                if (!buildFolderEl.getLocalName().equals("build-folder")) continue;
                foldersEl.removeChild(buildFolderEl);
            }
        }
        Iterator it = buildFolders.iterator();
        while (it.hasNext()) {
            String location = (String)it.next();
            buildFolderEl = doc.createElementNS(NS_GENERAL, "build-folder");
            Element locationEl = doc.createElementNS(NS_GENERAL, "location");
            locationEl.appendChild(doc.createTextNode(location));
            buildFolderEl.appendChild(locationEl);
            Util.appendChildElement((Element)foldersEl, (Element)buildFolderEl, (String[])folderElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List getTargetMappings(AntProjectHelper helper) {
        ArrayList<TargetMapping> list = new ArrayList<TargetMapping>();
        Element genldata = helper.getPrimaryConfigurationData(true);
        Element actionsEl = Util.findElement((Element)genldata, (String)"ide-actions", (String)NS_GENERAL);
        if (actionsEl == null) {
            return list;
        }
        List actions = Util.findSubElements((Element)actionsEl);
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            TargetMapping tm = new TargetMapping();
            tm.name = actionEl.getAttribute("name");
            List subElems = Util.findSubElements((Element)actionEl);
            ArrayList<String> targetNames = new ArrayList<String>(subElems.size());
            EditableProperties props = new EditableProperties(false);
            Iterator it2 = subElems.iterator();
            while (it2.hasNext()) {
                Element subEl = (Element)it2.next();
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(Util.findText((Element)subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    tm.script = Util.findText((Element)subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("context")) {
                    TargetMapping.Context ctx = new TargetMapping.Context();
                    Iterator it3 = Util.findSubElements((Element)subEl).iterator();
                    while (it3.hasNext()) {
                        Element sepFilesEl;
                        Element contextSubEl = (Element)it3.next();
                        if (contextSubEl.getLocalName().equals("property")) {
                            ctx.property = Util.findText((Element)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("format")) {
                            ctx.format = Util.findText((Element)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("folder")) {
                            ctx.folder = Util.findText((Element)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("pattern")) {
                            ctx.pattern = Util.findText((Element)contextSubEl);
                            continue;
                        }
                        if (!contextSubEl.getLocalName().equals("arity") || (sepFilesEl = Util.findElement((Element)contextSubEl, (String)"separated-files", (String)NS_GENERAL)) == null) continue;
                        ctx.separator = Util.findText((Element)sepFilesEl);
                    }
                    tm.context = ctx;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                JavaProjectGenerator.readProperty(subEl, props);
            }
            tm.targets = targetNames;
            if (props.keySet().size() > 0) {
                tm.properties = props;
            }
            list.add(tm);
        }
        return list;
    }

    static boolean isFolder(PropertyEvaluator eval, File baseFolder, String folder) {
        File f = Util.resolveFile((PropertyEvaluator)eval, (File)baseFolder, (String)folder);
        if (f != null && f.isDirectory()) {
            return true;
        }
        int dotIndex = folder.lastIndexOf(46);
        int slashIndex = folder.lastIndexOf(47);
        return dotIndex == -1 || dotIndex < slashIndex;
    }

    private static void readProperty(Element propertyElement, EditableProperties props) {
        String key = propertyElement.getAttribute("name");
        String value = Util.findText((Element)propertyElement);
        props.setProperty(key, value);
    }

    static {
        $assertionsDisabled = !JavaProjectGenerator.class.desiredAssertionStatus();
        rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
        viewElementsOrder = new String[]{"items", "context-menu"};
        folderElementsOrder = new String[]{"source-folder", "build-folder"};
        viewItemElementsOrder = new String[]{"source-folder", "source-file"};
    }

    public static final class TargetMapping {
        public String script;
        public List targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }

    public static final class Export {
        public String type;
        public String location;
        public String script;
        public String buildTarget;
        public String cleanTarget;
    }

    public static final class JavaCompilationUnit {
        public List packageRoots;
        public List classpath;
        public List output;
        public List javadoc;
        public String sourceLevel;
        public boolean isTests;

        public String toString() {
            return "FPG.JCU[packageRoots=" + this.packageRoots + ", classpath=" + this.classpath + ", output=" + this.output + ", javadoc=" + this.javadoc + ", sourceLevel=" + this.sourceLevel + ",isTests=" + this.isTests + "]";
        }

        public static final class CP {
            public String classpath;
            public String mode;

            public String toString() {
                return "FPG.JCU.CP:[classpath=" + this.classpath + ", mode=" + this.mode + ", this=" + super.toString() + "]";
            }
        }
    }

    public static final class SourceFolder {
        public String label;
        public String type;
        public String location;
        public String style;

        public String toString() {
            return "FPG.SF[label=" + this.label + ",type=" + this.type + ",location=" + this.location + ",style=" + this.style + "]";
        }
    }
}

