/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RfcDateParser {
    private static final String debugProp = "hotjava.debug.RfcDateParser";
    private boolean isGMT = false;
    static final String[] standardFormats = new String[]{"EEEE', 'dd-MMM-yy HH:mm:ss z", "EEEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy HH:mm:ss z", "EEEE', 'dd MMM yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy hh:mm:ss z", "EEEE', 'dd MMM yyyy hh:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss"};
    static final String[] gmtStandardFormats = new String[]{"EEEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEE MMM dd HH:mm:ss 'GMT' yyyy"};
    String dateString;

    public RfcDateParser(String dateString) {
        this.dateString = dateString.trim();
        if (this.dateString.indexOf("GMT") != -1) {
            this.isGMT = true;
        }
    }

    public Date getDate() {
        int arrayLen = this.isGMT ? gmtStandardFormats.length : standardFormats.length;
        int i = 0;
        while (i < arrayLen) {
            Date d = this.isGMT ? this.tryParsing(gmtStandardFormats[i]) : this.tryParsing(standardFormats[i]);
            if (d != null) {
                return d;
            }
            ++i;
        }
        return null;
    }

    private Date tryParsing(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        if (this.isGMT) {
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return df.parse(this.dateString);
        }
        catch (Exception e) {
            return null;
        }
    }
}

