/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.java;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaStructureType
extends JavaType {
    private List members = new ArrayList();
    private Map membersByName = new HashMap();
    private Set subclasses = new HashSet();
    private JavaStructureType superclass;
    private Object owner;
    private boolean isAbstract = false;

    public int getMembersCount() {
        return this.members.size();
    }

    public JavaStructureType() {
    }

    private void initializeMembersByName() {
        this.membersByName = new HashMap();
        if (this.members != null) {
            Iterator iter = this.members.iterator();
            while (iter.hasNext()) {
                JavaStructureMember m = (JavaStructureMember)iter.next();
                if (m.getName() != null && this.membersByName.containsKey(m.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.membersByName.put(m.getName(), m);
            }
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void add(JavaStructureMember m) {
        if (this.membersByName.containsKey(m.getName())) {
            throw new ModelException("model.uniqueness.javastructuretype", new Object[]{m.getName(), this.getRealName()});
        }
        this.members.add(m);
        this.membersByName.put(m.getName(), m);
    }

    public JavaStructureType getSuperclass() {
        return this.superclass;
    }

    public void addSubclass(JavaStructureType subclassType) {
        this.subclasses.add(subclassType);
        subclassType.setSuperclass(this);
    }

    public void setSuperclass(JavaStructureType superclassType) {
        this.superclass = superclassType;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Iterator getAllSubclasses() {
        Set subs = this.getAllSubclassesSet();
        if (subs.size() == 0) {
            return null;
        }
        return subs.iterator();
    }

    public Iterator getMembers() {
        return this.members.iterator();
    }

    public Iterator getSubclasses() {
        if (this.subclasses == null || this.subclasses.size() == 0) {
            return null;
        }
        return this.subclasses.iterator();
    }

    public List getMembersList() {
        return this.members;
    }

    public void setMembersList(List l) {
        this.members = l;
    }

    public Set getAllSubclassesSet() {
        HashSet transitiveSet = new HashSet();
        Iterator subs = this.subclasses.iterator();
        while (subs.hasNext()) {
            transitiveSet.addAll(((JavaStructureType)subs.next()).getAllSubclassesSet());
        }
        transitiveSet.addAll(this.subclasses);
        return transitiveSet;
    }

    public Set getSubclassesSet() {
        return this.subclasses;
    }

    public void setSubclassesSet(Set s) {
        this.subclasses = s;
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            ((JavaStructureType)iter.next()).setSuperclass(this);
        }
    }

    public JavaStructureMember getMemberByName(String name) {
        if (this.membersByName.size() != this.members.size()) {
            this.initializeMembersByName();
        }
        return (JavaStructureMember)this.membersByName.get(name);
    }

    public JavaStructureType(String name, boolean present, Object owner) {
        super(name, present, "null");
        this.owner = owner;
    }
}

