/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;

abstract class Lookup
implements ContextProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.registration") != null;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$api$debugger$Lookup;

    Lookup() {
    }

    abstract List lookup(String var1, Class var2, Set var3);

    abstract Set getHiddenItems(String var1, Class var2);

    public Object lookupFirst(String folder, Class service) {
        List l = this.lookup(folder, service);
        if (l.isEmpty()) {
            return null;
        }
        return l.get(0);
    }

    public List lookup(String folder, Class service) {
        return this.lookup(folder, service, Collections.EMPTY_SET);
    }

    static class MetaInf
    extends Lookup {
        private static final String HIDDEN = "-hidden";
        private String rootFolder;
        private HashMap registrationCache = new HashMap();
        private HashMap instanceCache = new HashMap();
        private Lookup context;

        MetaInf(String rootFolder) {
            this.rootFolder = rootFolder;
        }

        void setContext(Lookup context) {
            this.context = context;
        }

        List lookup(String folder, Class service, Set hidden) {
            List l = this.list(folder, service);
            HashSet s = new HashSet(l);
            ArrayList<Object> ll = new ArrayList<Object>();
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                String className = (String)l.get(i);
                if (className.endsWith(HIDDEN) || s.contains(className + HIDDEN)) continue;
                Object instance = null;
                instance = this.instanceCache.get(className);
                if (instance == null) {
                    instance = this.createInstance(className);
                    this.instanceCache.put(className, instance);
                }
                if (instance == null) continue;
                ll.add(instance);
            }
            return ll;
        }

        Set getHiddenItems(String folder, Class service) {
            Iterator i = this.list(folder, service).iterator();
            HashSet<String> h = new HashSet<String>();
            while (i.hasNext()) {
                String s = (String)i.next();
                if (!s.endsWith(HIDDEN)) continue;
                h.add(s.substring(0, s.length() - 7));
            }
            return h;
        }

        private List list(String folder, Class service) {
            String name = service.getName();
            String resourceName = "META-INF/debugger/" + (this.rootFolder == null ? "" : this.rootFolder + "/") + (folder == null ? "" : folder + "/") + name;
            if (!this.registrationCache.containsKey(resourceName)) {
                this.registrationCache.put(resourceName, this.loadMetaInf(resourceName));
            }
            return (List)this.registrationCache.get(resourceName);
        }

        private ArrayList loadMetaInf(String resourceName) {
            ArrayList<String> l = new ArrayList<String>();
            try {
                ClassLoader cl = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Lookup.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                String v = "\nR lookup " + resourceName;
                Enumeration<URL> e = cl.getResources(resourceName);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String s = br.readLine();
                    while (s != null) {
                        if (!s.startsWith("#") && s.length() != 0) {
                            if (verbose) {
                                v = v + "\nR  service " + s + " found";
                            }
                            l.add(s);
                        }
                        s = br.readLine();
                    }
                }
                if (verbose) {
                    System.out.println(v);
                }
                return l;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InternalError("Can not read from Meta-inf!");
            }
        }

        private Object createInstance(String service) {
            try {
                ClassLoader cl = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Lookup.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                String method = null;
                if (service.endsWith("()")) {
                    int lastdot = service.lastIndexOf(46);
                    if (lastdot < 0) {
                        ErrorManager.getDefault().log("Bad service - dot before method name is missing: '" + service + "'.");
                        return null;
                    }
                    method = service.substring(lastdot + 1, service.length() - 2).trim();
                    service = service.substring(0, lastdot);
                }
                Class<?> cls = cl.loadClass(service);
                Object o = null;
                if (method != null) {
                    Method m = null;
                    if (this.context != null) {
                        try {
                            m = cls.getDeclaredMethod(method, class$org$netbeans$api$debugger$Lookup == null ? (class$org$netbeans$api$debugger$Lookup = Lookup.class$("org.netbeans.api.debugger.Lookup")) : class$org$netbeans$api$debugger$Lookup);
                        }
                        catch (NoSuchMethodException nsmex) {
                            // empty catch block
                        }
                    }
                    if (m == null) {
                        try {
                            m = cls.getDeclaredMethod(method, new Class[0]);
                        }
                        catch (NoSuchMethodException nsmex) {
                            // empty catch block
                        }
                    }
                    if (m != null) {
                        Object[] objectArray;
                        if (m.getParameterTypes().length == 0) {
                            objectArray = new Object[]{};
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = this.context;
                        }
                        o = m.invoke(null, objectArray);
                    }
                }
                if (o == null && this.context != null) {
                    Constructor<?>[] cs = cls.getConstructors();
                    int k = cs.length;
                    for (int i = 0; i < k; ++i) {
                        Constructor<?> c = cs[i];
                        if (c.getParameterTypes().length != 1) continue;
                        try {
                            o = c.newInstance(this.context);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + service);
                            e.printStackTrace();
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + service);
                            e.printStackTrace();
                        }
                    }
                }
                if (o == null) {
                    o = cls.newInstance();
                }
                if (verbose) {
                    System.out.println("\nR  instance " + o + " created");
                }
                return o;
            }
            catch (ClassNotFoundException e) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, "The service " + service + " is not found."));
            }
            catch (InstantiationException e) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, "The service " + service + " can not be instantiated."));
            }
            catch (IllegalAccessException e) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, "The service " + service + " can not be accessed."));
            }
            catch (InvocationTargetException ex) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ex, "The service " + service + " can not be created."));
            }
            catch (ExceptionInInitializerError ex) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ex, "The service " + service + " can not be initialized."));
            }
            return null;
        }
    }

    static class Compound
    extends Lookup {
        private Lookup l1;
        private Lookup l2;

        Compound(Lookup l1, Lookup l2) {
            this.l1 = l1;
            this.l2 = l2;
            this.setContext(this);
        }

        List lookup(String folder, Class service, Set hidden) {
            ArrayList l = new ArrayList();
            l.addAll(this.l1.lookup(folder, service, hidden));
            l.addAll(this.l2.lookup(folder, service, hidden));
            return l;
        }

        Set getHiddenItems(String folder, Class service) {
            HashSet s = new HashSet();
            Iterator i = this.l1.getHiddenItems(folder, service).iterator();
            while (i.hasNext()) {
                s.add(i.next());
            }
            i = this.l2.getHiddenItems(folder, service).iterator();
            while (i.hasNext()) {
                s.add(i.next());
            }
            return s;
        }

        void setContext(Lookup context) {
            if (this.l1 instanceof Compound) {
                ((Compound)this.l1).setContext(context);
            }
            if (this.l1 instanceof MetaInf) {
                ((MetaInf)this.l1).setContext(context);
            }
            if (this.l2 instanceof Compound) {
                ((Compound)this.l2).setContext(context);
            }
            if (this.l2 instanceof MetaInf) {
                ((MetaInf)this.l2).setContext(context);
            }
        }
    }

    static class Instance
    extends Lookup {
        private Object[] services;

        Instance(Object[] services) {
            this.services = services;
        }

        List lookup(String folder, Class service, Set hidden) {
            ArrayList<Object> l = new ArrayList<Object>();
            int k = this.services.length;
            for (int i = 0; i < k; ++i) {
                if (!service.isAssignableFrom(this.services[i].getClass()) || hidden.contains(this.services[i].getClass().getName())) continue;
                l.add(this.services[i]);
                if (!verbose) continue;
                System.out.println("\nR  instance " + this.services[i] + " found");
            }
            return l;
        }

        Set getHiddenItems(String folder, Class service) {
            return Collections.EMPTY_SET;
        }
    }
}

