/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.ui.CategoryButton;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.CategoryList;
import org.netbeans.modules.palette.ui.DropGlassPane;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.openide.ErrorManager;

public class DnDSupport
implements DragGestureListener,
DropTargetListener {
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private List recognizers = new ArrayList(5);
    private List dropTargets = new ArrayList(5);
    private Category draggingCategory;
    private Item draggingItem;
    private Category dragSourceCategory;
    private CategoryList dragSourceCategoryList;
    private Item targetItem;
    private boolean dropBefore;
    private DragSourceListener dragSourceListener;
    private DropGlassPane dropPane;
    private PalettePanel palette;
    private Timer timer;

    public DnDSupport(PalettePanel palette) {
        this.palette = palette;
    }

    void add(CategoryDescriptor descriptor) {
        CategoryList list = descriptor.getList();
        this.recognizers.add(DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(list, 2, this));
        this.dropTargets.add(new DropTarget(list, this));
        CategoryButton button = descriptor.getButton();
        this.recognizers.add(DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(button, 2, this));
        this.dropTargets.add(new DropTarget(button, this));
    }

    void remove(CategoryDescriptor descriptor) {
        ArrayList<Serializable> toRemove = new ArrayList<Serializable>(2);
        Iterator i = this.recognizers.iterator();
        while (i.hasNext()) {
            DragGestureRecognizer dgr = (DragGestureRecognizer)i.next();
            if (dgr.getComponent() != descriptor.getButton() && dgr.getComponent() != descriptor.getList()) continue;
            toRemove.add(dgr);
            dgr.removeDragGestureListener(this);
        }
        this.recognizers.removeAll(toRemove);
        toRemove.clear();
        i = this.dropTargets.iterator();
        while (i.hasNext()) {
            DropTarget dt = (DropTarget)i.next();
            if (dt.getComponent() != descriptor.getButton() && dt.getComponent() != descriptor.getList()) continue;
            toRemove.add(dt);
            dt.removeDropTargetListener(this);
        }
        this.dropTargets.removeAll(toRemove);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Transferable t = null;
        if (dge.getComponent() instanceof CategoryButton) {
            CategoryButton button = (CategoryButton)dge.getComponent();
            this.draggingCategory = button.getCategory();
            t = this.draggingCategory.getTransferable();
        } else if (dge.getComponent() instanceof CategoryList) {
            CategoryList list = (CategoryList)dge.getComponent();
            int selIndex = list.locationToIndex(dge.getDragOrigin());
            this.draggingItem = list.getItemAt(selIndex);
            if (null == this.draggingItem) {
                return;
            }
            t = this.draggingItem.drag();
            this.dragSourceCategoryList = list;
            this.dragSourceCategory = list.getCategory();
        }
        if (null != t) {
            dge.getDragSource().addDragSourceListener(this.getDragSourceListener());
            try {
                dge.startDrag(null, t);
            }
            catch (InvalidDnDOperationException idndE) {
                ErrorManager.getDefault().notify(1, (Throwable)idndE);
            }
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        Component target = dtde.getDropTargetContext().getComponent();
        Category targetCategory = null;
        if (target instanceof CategoryList) {
            targetCategory = ((CategoryList)target).getCategory();
        } else if (target instanceof CategoryButton) {
            targetCategory = ((CategoryButton)target).getCategory();
        }
        if (null != this.draggingCategory) {
            boolean res = false;
            if (null != targetCategory && target instanceof CategoryButton) {
                res = this.palette.getModel().moveCategory(this.draggingCategory, targetCategory, this.dropBefore);
            }
            dtde.dropComplete(res);
        } else {
            dtde.acceptDrop(dtde.getDropAction());
            boolean res = false;
            if (null != targetCategory) {
                Transferable t = null != this.draggingItem ? this.draggingItem.cut() : dtde.getTransferable();
                res = targetCategory.dropItem(t, dtde.getDropAction(), this.targetItem, this.dropBefore);
            }
            dtde.dropComplete(res);
        }
        this.draggingItem = null;
        this.draggingCategory = null;
    }

    public void dragExit(DropTargetEvent dte) {
        this.removeDropLine();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
        this.removeTimer();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.checkStoredGlassPane();
        this.doDragOver(dtde);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        CategoryButton button;
        this.checkStoredGlassPane();
        Component target = dtde.getDropTargetContext().getComponent();
        if (!(!(target instanceof CategoryButton) || null != this.draggingCategory || (button = (CategoryButton)target).isSelected() || null != this.timer && this.timer.isRunning())) {
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    button.setExpanded(true);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        this.doDragOver(dtde);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] l = (ActionListener[])this.timer.getListeners(ActionListener.class);
            for (int i = 0; i < l.length; ++i) {
                this.timer.removeActionListener(l[i]);
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    private void doDragOver(DropTargetDragEvent dtde) {
        Component target = dtde.getDropTargetContext().getComponent();
        if (null != this.draggingCategory) {
            Category targetCategory = null;
            if (target instanceof CategoryButton) {
                CategoryButton button = (CategoryButton)target;
                targetCategory = button.getCategory();
            }
            if (null == targetCategory || !this.palette.getModel().canReorderCategories()) {
                dtde.rejectDrag();
                this.removeDropLine();
                return;
            }
            this.dropBefore = dtde.getLocation().y < target.getHeight() / 2;
            Point p1 = target.getLocation();
            Point p2 = target.getLocation();
            p2.x += target.getWidth();
            if (!this.dropBefore) {
                p1.y += target.getHeight();
                p2.y += target.getHeight();
            }
            p1 = SwingUtilities.convertPoint(target, p1, this.palette.getRootPane());
            p2 = SwingUtilities.convertPoint(target, p2, this.palette.getRootPane());
            Line2D.Double line = new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
            this.dropPane.setDropLine(line);
        } else {
            CategoryList list;
            Category targetCategory = null;
            if (target instanceof CategoryList) {
                list = (CategoryList)target;
                targetCategory = list.getCategory();
            } else if (target instanceof CategoryButton) {
                CategoryButton button = (CategoryButton)target;
                targetCategory = button.getCategory();
            }
            if (null == targetCategory || !targetCategory.dragOver(dtde)) {
                dtde.rejectDrag();
                this.removeDropLine();
                this.targetItem = null;
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
            if (target instanceof CategoryList) {
                list = (CategoryList)target;
                int dropIndex = list.locationToIndex(dtde.getLocation());
                if (dropIndex < 0) {
                    this.dropPane.setDropLine(null);
                    this.targetItem = null;
                } else {
                    boolean verticalDropBar = list.getColumnCount() > 1;
                    Rectangle rect = list.getCellBounds(dropIndex, dropIndex);
                    this.dropBefore = verticalDropBar ? dtde.getLocation().x < rect.x + rect.width / 2 : dtde.getLocation().y < rect.y + rect.height / 2;
                    Point p1 = rect.getLocation();
                    Point p2 = rect.getLocation();
                    if (verticalDropBar) {
                        p2.y += rect.height;
                        if (!this.dropBefore) {
                            p1.x += rect.width;
                            p2.x += rect.width;
                        }
                    } else {
                        p2.x += rect.width;
                        if (!this.dropBefore) {
                            p1.y += rect.height;
                            p2.y += rect.height;
                        }
                    }
                    p1 = SwingUtilities.convertPoint(list, p1, this.palette.getRootPane());
                    p2 = SwingUtilities.convertPoint(list, p2, this.palette.getRootPane());
                    Line2D.Double line = new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
                    this.dropPane.setDropLine(line);
                    this.targetItem = (Item)list.getModel().getElementAt(dropIndex);
                }
            } else {
                this.targetItem = null;
                this.dropBefore = false;
            }
        }
    }

    private DragSourceListener getDragSourceListener() {
        if (null == this.dragSourceListener) {
            this.dragSourceListener = new DragSourceAdapter(){

                public void dragDropEnd(DragSourceDropEvent dsde) {
                    DnDSupport.this.draggingItem = null;
                    DnDSupport.this.draggingCategory = null;
                    DnDSupport.this.targetItem = null;
                    if (null != DnDSupport.this.dragSourceCategoryList) {
                        DnDSupport.this.dragSourceCategoryList.resetRollover();
                    }
                    DnDSupport.this.dragSourceCategory = null;
                    DnDSupport.this.dragSourceCategoryList = null;
                    DnDSupport.this.removeDropLine();
                    if (DropGlassPane.isOriginalPaneStored()) {
                        DropGlassPane.putBackOriginal();
                    }
                    dsde.getDragSourceContext().getDragSource().removeDragSourceListener(this);
                    DnDSupport.this.removeTimer();
                }
            };
        }
        return this.dragSourceListener;
    }

    private void checkStoredGlassPane() {
        if (!DropGlassPane.isOriginalPaneStored()) {
            Component comp = this.palette.getRootPane().getGlassPane();
            DropGlassPane.setOriginalPane(this.palette, comp, comp.isVisible());
            this.dropPane = DropGlassPane.getDefault(this.palette);
            this.palette.getRootPane().setGlassPane(this.dropPane);
            this.dropPane.revalidate();
            this.dropPane.validate();
            this.dropPane.setVisible(true);
        }
    }

    private void removeDropLine() {
        if (null != this.dropPane) {
            this.dropPane.setDropLine(null);
        }
    }
}

