/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.j2ee.persistence.editor.completion.Utils;
import org.openide.ErrorManager;

public class NNParser {
    private static final int INIT = 0;
    private static final int NN = 1;
    private static final int ERROR = 2;
    private static final int NNNAME = 3;
    private static final int INNN = 4;
    private static final int ATTRNAME = 5;
    private static final int EQ = 6;
    private static final int ATTRVALUE = 7;
    private JavaSyntaxSupport sup;

    public NNParser(BaseDocument bdoc) {
        SyntaxSupport ssup = bdoc.getSyntaxSupport();
        if (!(ssup instanceof JavaSyntaxSupport)) {
            throw new IllegalArgumentException("Only java files are supported!");
        }
        this.sup = (JavaSyntaxSupport)ssup;
    }

    public NN parseAnnotation(int offset) {
        int nnStart = this.findAnnotationStart(offset);
        if (nnStart == -1) {
            return null;
        }
        return this.parseAnnotationOnOffset(nnStart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NN parseAnnotationOnOffset(int offset) {
        try {
            int parentCount = -1;
            int state = 0;
            TokenItem ti = this.sup.getTokenChain(offset, offset + 1);
            assert (ti.getTokenID() == JavaTokenContext.ANNOTATION);
            int nnstart = offset;
            int nnend = -1;
            String nnName = null;
            String currAttrName = null;
            String currAttrValue = null;
            ArrayList<NNAttr> attrs = new ArrayList<NNAttr>(5);
            int eqOffset = -1;
            block32: do {
                int tid;
                if ((tid = ti.getTokenID().getNumericID()) == 5) {
                    ti = ti.getNext();
                    continue;
                }
                block1 : switch (state) {
                    case 0: {
                        switch (tid) {
                            case 123: {
                                state = 1;
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        switch (tid) {
                            case 6: {
                                state = 3;
                                nnName = ti.getImage();
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 3: {
                        switch (tid) {
                            case 53: {
                                state = 4;
                                break block1;
                            }
                            case 6: 
                            case 48: {
                                nnName = nnName + ti.getImage();
                                break block1;
                            }
                        }
                        nnend = nnstart + "@".length() + nnName.length();
                        return new NN(nnName, attrs, nnstart, nnend);
                    }
                    case 4: {
                        switch (tid) {
                            case 6: {
                                currAttrName = ti.getImage();
                                state = 5;
                                break block1;
                            }
                            case 49: {
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 5: {
                        switch (tid) {
                            case 17: {
                                state = 6;
                                eqOffset = ti.getOffset();
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 6: {
                        switch (tid) {
                            case 10: {
                                state = 4;
                                currAttrValue = Utils.unquote(ti.getImage());
                                attrs.add(new NNAttr(currAttrName, currAttrValue, ti.getOffset(), true));
                                break block1;
                            }
                            case 6: {
                                state = 4;
                                currAttrValue = ti.getImage();
                                attrs.add(new NNAttr(currAttrName, currAttrValue, ti.getOffset(), false));
                                break block1;
                            }
                            case 123: {
                                NN nestedNN = this.parseAnnotationOnOffset(ti.getOffset());
                                attrs.add(new NNAttr(currAttrName, nestedNN, ti.getOffset(), false));
                                state = 4;
                                ti = this.sup.getTokenChain(nestedNN.getEndOffset(), nestedNN.getEndOffset() + 1);
                                continue block32;
                            }
                            default: {
                                attrs.add(new NNAttr(currAttrName, "", eqOffset + 1, false));
                                state = 4;
                            }
                        }
                    }
                }
                if (state == 2) {
                    nnend = ti.getOffset() + ti.getImage().length();
                    return new NN(nnName, attrs, nnstart, nnend);
                }
                ti = ti.getNext();
            } while (ti != null);
            return null;
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return null;
    }

    private int findAnnotationStart(int offset) {
        int parentCount = -100;
        try {
            for (TokenItem ti = this.sup.getTokenChain(offset - 1, offset); ti != null; ti = ti.getPrevious()) {
                if (ti.getTokenID() == JavaTokenContext.RPAREN) {
                    if (parentCount == -100) {
                        parentCount = 0;
                    }
                    ++parentCount;
                    continue;
                }
                if (ti.getTokenID() == JavaTokenContext.LPAREN) {
                    if (parentCount == -100) {
                        parentCount = 0;
                    }
                    --parentCount;
                    continue;
                }
                if (ti.getTokenID() != JavaTokenContext.ANNOTATION || parentCount != -1 && parentCount != -100) continue;
                return ti.getOffset();
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NN {
        private String name;
        private List<NNAttr> attributes;
        private int startOffset;
        private int endOffset;

        public NN(String name, List<NNAttr> attributes, int startOffset, int endOffset) {
            this.name = name;
            this.attributes = attributes;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String getName() {
            return this.name;
        }

        public List<NNAttr> getAttributesList() {
            return this.attributes;
        }

        public Map<String, Object> getAttributes() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (NNAttr nnattr : this.getAttributesList()) {
                map.put(nnattr.getName(), nnattr.getValue());
            }
            return map;
        }

        public NNAttr getAttributeForOffset(int offset) {
            NNAttr prevnn = null;
            for (NNAttr nnattr : this.getAttributesList()) {
                if (nnattr.getValueOffset() >= offset) {
                    prevnn = nnattr;
                    break;
                }
                prevnn = nnattr;
            }
            if (prevnn == null) {
                return null;
            }
            int nnEndOffset = prevnn.getValueOffset() + prevnn.getValue().toString().length() + (prevnn.isValueQuoted() ? 2 : 0);
            if (nnEndOffset >= offset && prevnn.getValueOffset() <= offset) {
                return prevnn;
            }
            return null;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            String text = "@" + this.getName() + " [" + this.getStartOffset() + " - " + this.getEndOffset() + "](";
            for (NNAttr nnattr : this.getAttributesList()) {
                String key = nnattr.getName();
                String value = nnattr.getValue().toString();
                text = text + key + "=" + value + " (" + nnattr.getValueOffset() + ") ,";
            }
            text = text.substring(0, text.length() - 1);
            text = text + ")";
            return text;
        }
    }

    public class NNAttr {
        private String name;
        private Object value;
        private int valueOffset;
        private boolean quoted;

        NNAttr(String name, Object value, int valueOffset, boolean quoted) {
            this.name = name;
            this.value = value;
            this.valueOffset = valueOffset;
            this.quoted = quoted;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        public boolean isValueQuoted() {
            return this.quoted;
        }
    }
}

