/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.ui.EntityNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class PersistenceChildren
extends Children.Keys
implements PropertyChangeListener {
    private final EntityMappings model;
    private final ClassPath srcPath;

    public PersistenceChildren(EntityMappings model, ClassPath srcPath) {
        this.model = model;
        this.srcPath = srcPath;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener(this);
    }

    private void updateKeys() {
        ArrayList keys = Collections.EMPTY_LIST;
        Entity[] entityBeans = this.model.getEntity();
        Comparator ejbComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.getEjbDisplayName((Entity)((Object)o1)).compareTo(this.getEjbDisplayName((Entity)((Object)o2)));
            }

            private String getEjbDisplayName(Entity entity) {
                String name = entity.getName();
                if (name == null) {
                    name = "";
                }
                return name;
            }
        };
        Arrays.sort(entityBeans, ejbComparator);
        keys = new ArrayList(entityBeans.length);
        this.addKeyValues(keys, Arrays.asList(entityBeans));
        this.setKeys(keys);
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener(this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        Node[] node = null;
        if (key instanceof Entity) {
            node = new Node[]{new EntityNode((Entity)((Object)key), this.model, this.srcPath)};
        }
        return node == null ? new Node[]{} : node;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PersistenceChildren.this.updateKeys();
            }
        });
    }

    private void addKeyValues(List keyContainer, List beans) {
        keyContainer.addAll(beans);
    }
}

