/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.library.VolumeContentModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class J2SEVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private VolumeContentModel model;
    private static File lastFolder = null;
    private JButton addButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;
    private JButton addURLButton;

    J2SEVolumeCustomizer(String volumeType) {
        this.volumeType = volumeType;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)("TXT_" + volumeType)));
    }

    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        if (this.addURLButton != null) {
            this.addURLButton.setEnabled(enabled);
        }
        int[] indices = this.content.getSelectedIndices();
        this.removeButton.setEnabled(enabled && indices.length > 0);
        this.downButton.setEnabled(enabled && indices.length > 0 && indices[indices.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(enabled && indices.length > 0 && indices[0] > 0);
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.volumeType.equals("classpath")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] indices = J2SEVolumeCustomizer.this.content.getSelectedIndices();
                J2SEVolumeCustomizer.this.removeButton.setEnabled(indices.length > 0);
                J2SEVolumeCustomizer.this.downButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < J2SEVolumeCustomizer.this.model.getSize() - 1);
                J2SEVolumeCustomizer.this.upButton.setEnabled(indices.length > 0 && indices[0] > 0);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(null);
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_ContentMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.addResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.removeResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.upResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.downResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(null);
    }

    private void downResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] < 0 || indices[indices.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] + 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void upResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] <= 0) {
            return;
        }
        this.model.moveUp(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] - 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void removeResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        this.model.removeResources(indices);
        if (indices[indices.length - 1] - indices.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
        } else if (indices[0] >= 1) {
            this.content.setSelectedIndex(indices[0] - 1);
        }
    }

    private void addResource(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.volumeType.equals("classpath")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenClasses"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectCP"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectCP").charAt(0));
        } else if (this.volumeType.equals("javadoc")) {
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenJavadoc"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectJD"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectJD").charAt(0));
        } else if (this.volumeType.equals("src")) {
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenSources"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        }
        if (lastFolder != null) {
            chooser.setCurrentDirectory(lastFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            try {
                lastFolder = chooser.getCurrentDirectory();
                if (chooser.isMultiSelectionEnabled()) {
                    this.addFiles(chooser.getSelectedFiles());
                } else {
                    File selectedFile = chooser.getSelectedFile();
                    this.addFiles(new File[]{selectedFile});
                }
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
        }
    }

    private void addFiles(File[] files) throws MalformedURLException {
        int firstIndex = this.model.getSize();
        for (int i = 0; i < files.length; ++i) {
            URL url;
            File parent;
            File f = files[i];
            if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                f = parent;
            }
            if (FileUtil.isArchiveFile((URL)(url = f.toURI().toURL()))) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!url.toExternalForm().endsWith("/")) {
                try {
                    url = new URL(url.toExternalForm() + "/");
                }
                catch (MalformedURLException mue) {
                    ErrorManager.getDefault().notify((Throwable)mue);
                }
            }
            if (this.volumeType.equals("javadoc") && !PersistenceLibrarySupport.isValidLibraryJavadocRoot(url)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot", (Object)f.getPath()), 0));
                continue;
            }
            this.model.addResource(url);
        }
        int lastIndex = this.model.getSize() - 1;
        if (firstIndex <= lastIndex) {
            int[] toSelect = new int[lastIndex - firstIndex + 1];
            for (int i = 0; i < toSelect.length; ++i) {
                toSelect[i] = firstIndex + i;
            }
            this.content.setSelectedIndices(toSelect);
        }
    }

    public void setObject(Object bean) {
        if (bean instanceof LibraryImplementation) {
            LibrariesSupport.createLibraryImplementation((String)"j2se", (String[])PersistenceLibrarySupport.VOLUME_TYPES);
            this.impl = (LibraryImplementation)bean;
            this.model = new VolumeContentModel(this.impl, this.volumeType);
            this.content.setModel(this.model);
            if (this.model.getSize() > 0) {
                this.content.setSelectedIndex(0);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c;
            String displayName = null;
            Color color = null;
            String toolTip = null;
            if (value instanceof URL) {
                FileObject fo;
                URL url = (URL)value;
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                if ((fo = URLMapper.findFileObject((URL)url)) == null) {
                    displayName = url.toExternalForm();
                    color = new Color(164, 0, 0);
                    toolTip = NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_BrokenFile");
                } else {
                    displayName = FileUtil.getFileDisplayName((FileObject)fo);
                }
            }
            if ((c = super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus)) instanceof JComponent) {
                if (color != null) {
                    ((JComponent)c).setForeground(color);
                }
                if (toolTip != null) {
                    ((JComponent)c).setToolTipText(toolTip);
                }
            }
            return c;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

