/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.DocumentsDlg;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class DocumentsAction
extends AbstractAction
implements Runnable {
    private final PropertyChangeListener propListener;

    public DocumentsAction() {
        this.putValue("Name", NbBundle.getMessage((Class)DocumentsAction.class, (String)"CTL_DocumentsAction"));
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("opened".equals(evt.getPropertyName())) {
                    DocumentsAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DocumentsAction.this.updateState();
                }
            });
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        DocumentsDlg.showDocumentsDialog();
    }

    private void updateState() {
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
        this.setEnabled(mode == null ? false : !mode.getOpenedTopComponents().isEmpty());
    }
}

