/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class SingleModuleProperties
extends ModuleProperties {
    private static final String[] IDE_TOKENS;
    public static final String BUILD_COMPILER_DEBUG = "build.compiler.debug";
    public static final String BUILD_COMPILER_DEPRECATION = "build.compiler.deprecation";
    public static final String CLUSTER_DIR = "cluster.dir";
    public static final String IS_AUTOLOAD = "is.autoload";
    public static final String IS_EAGER = "is.eager";
    public static final String JAVAC_SOURCES = "javac.source";
    public static final String JAVADOC_TITLE = "javadoc.title";
    public static final String LICENSE_FILE = "license.file";
    public static final String NBM_HOMEPAGE = "nbm.homepage";
    public static final String NBM_IS_GLOBAL = "nbm.is.global";
    public static final String NBM_MODULE_AUTHOR = "nbm.module.author";
    public static final String NBM_NEEDS_RESTART = "nbm.needs.restart";
    public static final String SPEC_VERSION_BASE = "spec.version.base";
    public static final String JAVAC_COMPILERARGS = "javac.compilerargs";
    static final String[] SOURCE_LEVELS;
    private static final Map DEFAULTS;
    private boolean majorReleaseVersionChanged;
    private boolean specificationVersionChanged;
    private boolean implementationVersionChange;
    private boolean providedTokensChanged;
    private NbModuleTypeProvider.NbModuleType moduleType;
    private SuiteProvider suiteProvider;
    private ProjectXMLManager projectXMLManager;
    private final LocalizedBundleInfo.Provider bundleInfoProvider;
    private LocalizedBundleInfo bundleInfo;
    private String majorReleaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String provTokensString;
    private SortedSet requiredTokens;
    private NbPlatform activePlatform;
    private NbPlatform originalPlatform;
    private JavaPlatform activeJavaPlatform;
    private SortedSet availablePublicPackages;
    private String[] allTokens;
    private SortedSet modCategories;
    private Set universeDependencies;
    private CustomizerComponentFactory.PublicPackagesTableModel publicPackagesModel;
    private CustomizerComponentFactory.DependencyListModel dependencyListModel;
    private CustomizerComponentFactory.FriendListModel friendListModel;
    private CustomizerComponentFactory.RequiredTokenListModel requiredTokensListModel;
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    public static final String DEPENDENCIES_PROPERTY = "moduleDependencies";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SingleModuleProperties getInstance(NbModuleProject project) {
        SuiteProvider sp = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        return new SingleModuleProperties(project.getHelper(), project.evaluator(), sp, Util.getModuleType(project), (LocalizedBundleInfo.Provider)project.getLookup().lookup(LocalizedBundleInfo.Provider.class));
    }

    SingleModuleProperties(AntProjectHelper helper, PropertyEvaluator evaluator, SuiteProvider sp, NbModuleTypeProvider.NbModuleType moduleType, LocalizedBundleInfo.Provider bundleInfoProvider) {
        super(helper, evaluator);
        this.bundleInfoProvider = bundleInfoProvider;
        this.refresh(moduleType, sp);
    }

    protected void refresh(NbModuleTypeProvider.NbModuleType moduleType, SuiteProvider suiteProvider) {
        this.reloadProperties();
        this.suiteProvider = suiteProvider;
        this.moduleType = moduleType;
        this.universeDependencies = null;
        this.modCategories = null;
        this.availablePublicPackages = null;
        this.dependencyListModel = null;
        this.friendListModel = null;
        this.requiredTokensListModel = null;
        this.projectXMLManager = null;
        if (this.isSuiteComponent()) {
            if (!$assertionsDisabled && this.getSuiteDirectory() == null) {
                throw new AssertionError();
            }
            ModuleList.refreshSuiteModuleList(this.getSuiteDirectory());
        }
        ManifestManager manifestManager = ManifestManager.getInstance(this.getManifestFile(), false);
        this.majorReleaseVersion = manifestManager.getReleaseVersion();
        this.specificationVersion = manifestManager.getSpecificationVersion();
        this.implementationVersion = manifestManager.getImplementationVersion();
        this.provTokensString = manifestManager.getProvidedTokensString();
        this.originalPlatform = this.activePlatform = NbPlatform.getPlatformByID(this.getEvaluator().getProperty("nbplatform.active"));
        String activeJdk = this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY);
        if (activeJdk != null) {
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID(activeJdk);
        } else {
            String activeJdkHome = this.getEvaluator().getProperty("nbjdk.home");
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByLocation(activeJdkHome);
        }
        this.getPublicPackagesModel().reloadData(this.loadPublicPackages());
        this.requiredTokens = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList(manifestManager.getRequiredTokens())));
        this.bundleInfo = this.bundleInfoProvider.getLocalizedBundleInfo();
        if (this.bundleInfo != null) {
            try {
                this.bundleInfo.reload();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        this.firePropertiesRefreshed();
    }

    void libraryWrapperAdded() {
        this.universeDependencies = null;
    }

    Map getDefaultValues() {
        return DEFAULTS;
    }

    LocalizedBundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    String getCodeNameBase() {
        return this.getProjectXMLManager().getCodeNameBase();
    }

    String getJarFile() {
        return this.getHelper().resolveFile(this.getEvaluator().evaluate("${cluster}/${module.jar}")).getAbsolutePath();
    }

    String getSuiteDirectoryPath() {
        return this.getSuiteDirectory() != null ? this.getSuiteDirectory().getPath() : null;
    }

    File getSuiteDirectory() {
        return this.suiteProvider != null ? this.suiteProvider.getSuiteDirectory() : null;
    }

    SuiteProject getSuite() {
        if (!$assertionsDisabled && !this.isSuiteComponent()) {
            throw new AssertionError();
        }
        SuiteProject suite = null;
        try {
            suite = (SuiteProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)this.getSuiteDirectory()));
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return suite;
    }

    boolean isActivePlatformValid() {
        NbPlatform plaf = this.getActivePlatform();
        return plaf == null || plaf.isValid();
    }

    NbPlatform getActivePlatform() {
        if (!(this.moduleType == NbModuleTypeProvider.NETBEANS_ORG || this.activePlatform != null && NbPlatform.getPlatforms().contains(this.activePlatform))) {
            ModuleProperties.reportLostPlatform(this.activePlatform);
            this.activePlatform = NbPlatform.getDefaultPlatform();
        }
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform newPlaf) {
        if (this.activePlatform != newPlaf) {
            NbPlatform oldPlaf = this.activePlatform;
            this.activePlatform = newPlaf;
            this.dependencyListModel = null;
            this.universeDependencies = null;
            this.modCategories = null;
            this.firePropertyChange(NB_PLATFORM_PROPERTY, oldPlaf, newPlaf);
        }
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform nue) {
        JavaPlatform old = this.activeJavaPlatform;
        if (nue != old) {
            this.activeJavaPlatform = nue;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, old, nue);
        }
    }

    String getMajorReleaseVersion() {
        return this.majorReleaseVersion;
    }

    void setMajorReleaseVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.majorReleaseVersion, (Object)ver)) {
            this.majorReleaseVersion = ver;
            this.majorReleaseVersionChanged = true;
        }
    }

    String getSpecificationVersion() {
        return this.specificationVersion;
    }

    void setSpecificationVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.specificationVersion, (Object)ver)) {
            this.specificationVersion = ver;
            this.specificationVersionChanged = true;
        }
    }

    String getImplementationVersion() {
        return this.implementationVersion;
    }

    void setImplementationVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.implementationVersion, (Object)ver)) {
            this.implementationVersion = ver;
            this.implementationVersionChange = true;
        }
    }

    String getProvidedTokens() {
        return this.provTokensString;
    }

    void setProvidedTokens(String tokens) {
        if (!Utilities.compareObjects((Object)this.provTokensString, (Object)tokens)) {
            this.provTokensString = tokens;
            this.providedTokensChanged = true;
        }
    }

    boolean isStandalone() {
        return this.moduleType == NbModuleTypeProvider.STANDALONE;
    }

    boolean isNetBeansOrg() {
        return this.moduleType == NbModuleTypeProvider.NETBEANS_ORG;
    }

    boolean isSuiteComponent() {
        return this.moduleType == NbModuleTypeProvider.SUITE_COMPONENT;
    }

    boolean dependingOnImplDependency() {
        CustomizerComponentFactory.DependencyListModel depsModel = this.getDependenciesListModel();
        if (depsModel == CustomizerComponentFactory.INVALID_DEP_LIST_MODEL) {
            return false;
        }
        Set deps = depsModel.getDependencies();
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            ModuleDependency dep = (ModuleDependency)it.next();
            if (!dep.hasImplementationDepedendency()) continue;
            return true;
        }
        return false;
    }

    private ProjectXMLManager getProjectXMLManager() {
        block3: {
            if (this.projectXMLManager == null) {
                try {
                    this.projectXMLManager = ProjectXMLManager.getInstance(this.getProjectDirectoryFile());
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return this.projectXMLManager;
    }

    CustomizerComponentFactory.DependencyListModel getDependenciesListModel() {
        if (this.dependencyListModel == null) {
            if (this.isActivePlatformValid()) {
                try {
                    this.dependencyListModel = new CustomizerComponentFactory.DependencyListModel(this.getProjectXMLManager().getDirectDependencies(this.getActivePlatform()), true);
                    this.dependencyListModel.addListDataListener(new ListDataListener(){

                        public void contentsChanged(ListDataEvent e) {
                            SingleModuleProperties.this.firePropertyChange(SingleModuleProperties.DEPENDENCIES_PROPERTY, null, SingleModuleProperties.this.getDependenciesListModel());
                        }

                        public void intervalAdded(ListDataEvent e) {
                            this.contentsChanged(null);
                        }

                        public void intervalRemoved(ListDataEvent e) {
                            this.contentsChanged(null);
                        }
                    });
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
                }
            } else {
                this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
            }
        }
        return this.dependencyListModel;
    }

    Set getUniverseDependencies(boolean filterExcludedModules, boolean apiProvidersOnly) {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.getUniverseDependencies() cannot be called from EDT");
        }
        if (this.universeDependencies == null) {
            this.reloadModuleListInfo();
        }
        HashSet result = new HashSet(this.universeDependencies);
        if (filterExcludedModules && this.isSuiteComponent()) {
            SuiteProject suite = this.getSuite();
            String[] disableModules = SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.modules");
            String[] enableClusters = SuiteProperties.getArrayProperty(suite.getEvaluator(), "enabled.clusters");
            String[] disableClusters = SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.clusters");
            String suiteClusterProp = this.getEvaluator().getProperty("cluster");
            File suiteClusterDir = suiteClusterProp != null ? this.getHelper().resolveFile(suiteClusterProp) : null;
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ModuleDependency dep = (ModuleDependency)it.next();
                ModuleEntry me = dep.getModuleEntry();
                if (me.getClusterDirectory().equals(suiteClusterDir) || !SingleModuleProperties.isExcluded(me, disableModules, enableClusters, disableClusters)) continue;
                it.remove();
            }
        }
        if (apiProvidersOnly) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ModuleDependency dep = (ModuleDependency)it.next();
                ModuleEntry me = dep.getModuleEntry();
                if (me.getPublicPackages().length != 0 && me.isDeclaredAsFriend(this.getCodeNameBase())) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableSet(result);
    }

    Set getUniverseDependencies(boolean filterExcludedModules) {
        return this.getUniverseDependencies(filterExcludedModules, false);
    }

    private static boolean isExcluded(ModuleEntry me, String[] disableModules, String[] enableClusters, String[] disableClusters) {
        if (Arrays.binarySearch(disableModules, me.getCodeNameBase()) >= 0) {
            return true;
        }
        if (enableClusters.length != 0 && Arrays.binarySearch(enableClusters, me.getClusterDirectory().getName()) < 0) {
            return true;
        }
        return enableClusters.length == 0 && Arrays.binarySearch(disableClusters, me.getClusterDirectory().getName()) >= 0;
    }

    String[] getAvailableFriends() {
        TreeSet<String> set;
        block3: {
            block2: {
                set = new TreeSet<String>();
                if (!this.isSuiteComponent()) break block2;
                Iterator it = SuiteUtils.getSubProjects(this.getSuite()).iterator();
                while (it.hasNext()) {
                    Project prj = (Project)it.next();
                    String cnb = ProjectUtils.getInformation((Project)prj).getName();
                    if (this.getCodeNameBase().equals(cnb)) continue;
                    set.add(cnb);
                }
                break block3;
            }
            if (!this.isNetBeansOrg()) break block3;
            Set deps = this.getUniverseDependencies(false);
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                ModuleDependency dep = (ModuleDependency)it.next();
                set.add(dep.getModuleEntry().getCodeNameBase());
            }
        }
        return set.toArray(new String[set.size()]);
    }

    CustomizerComponentFactory.FriendListModel getFriendListModel() {
        if (this.friendListModel == null) {
            this.friendListModel = new CustomizerComponentFactory.FriendListModel(this.getProjectXMLManager().getFriends());
        }
        return this.friendListModel;
    }

    CustomizerComponentFactory.RequiredTokenListModel getRequiredTokenListModel() {
        if (this.requiredTokensListModel == null) {
            this.requiredTokensListModel = new CustomizerComponentFactory.RequiredTokenListModel(this.requiredTokens);
        }
        return this.requiredTokensListModel;
    }

    String[] getAllTokens() {
        if (this.allTokens == null) {
            try {
                TreeSet<String> provTokens = new TreeSet<String>();
                provTokens.addAll(Arrays.asList(IDE_TOKENS));
                Iterator it = this.getModuleList().getAllEntriesSoft().iterator();
                while (it.hasNext()) {
                    ModuleEntry me = (ModuleEntry)it.next();
                    provTokens.addAll(Arrays.asList(me.getProvidedTokens()));
                }
                String[] result = new String[provTokens.size()];
                return provTokens.toArray(result);
            }
            catch (IOException e) {
                this.allTokens = new String[0];
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return this.allTokens;
    }

    CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        if (this.publicPackagesModel == null) {
            this.publicPackagesModel = new CustomizerComponentFactory.PublicPackagesTableModel(this.loadPublicPackages());
        }
        return this.publicPackagesModel;
    }

    private Map loadPublicPackages() {
        Collection selectedPackages = this.getSelectedPackages();
        TreeMap<String, Boolean> publicPackages = new TreeMap<String, Boolean>();
        Iterator it = this.getAvailablePublicPackages().iterator();
        while (it.hasNext()) {
            String pkg = (String)it.next();
            publicPackages.put(pkg, selectedPackages.contains(pkg));
        }
        return publicPackages;
    }

    private Collection getSelectedPackages() {
        HashSet<String> sPackages = new HashSet<String>();
        ManifestManager.PackageExport[] pexports = this.getProjectXMLManager().getPublicPackages();
        for (int i = 0; i < pexports.length; ++i) {
            ManifestManager.PackageExport pexport = pexports[i];
            if (pexport.isRecursive()) {
                Iterator it = this.getAvailablePublicPackages().iterator();
                while (it.hasNext()) {
                    String p = (String)it.next();
                    if (!p.startsWith(pexport.getPackage())) continue;
                    sPackages.add(p);
                }
                continue;
            }
            sPackages.add(pexport.getPackage());
        }
        return sPackages;
    }

    Set getAvailablePublicPackages() {
        if (this.availablePublicPackages == null) {
            this.availablePublicPackages = new TreeSet();
            File srcDir = this.getHelper().resolveFile(this.getEvaluator().getProperty("src.dir"));
            HashSet pkgs = new HashSet();
            FileObject srcDirFO = FileUtil.toFileObject((File)srcDir);
            SingleModuleProperties.addNonEmptyPackages(pkgs, srcDirFO, "java");
            Iterator it = pkgs.iterator();
            while (it.hasNext()) {
                FileObject pkg = (FileObject)it.next();
                if (srcDirFO.equals(pkg)) continue;
                String pkgS = PropertyUtils.relativizeFile((File)srcDir, (File)FileUtil.toFile((FileObject)pkg));
                this.availablePublicPackages.add(pkgS.replace('/', '.'));
            }
            String[] libsPaths = this.getProjectXMLManager().getBinaryOrigins();
            for (int i = 0; i < libsPaths.length; ++i) {
                SingleModuleProperties.addNonEmptyPackagesFromJar(this.availablePublicPackages, this.getHelper().resolveFile(libsPaths[i]));
            }
            Iterator it2 = this.availablePublicPackages.iterator();
            while (it2.hasNext()) {
                String pkg = (String)it2.next();
                if (Util.isValidJavaFQN(pkg)) continue;
                it2.remove();
            }
        }
        return this.availablePublicPackages;
    }

    void storeProperties() throws IOException {
        CustomizerComponentFactory.DependencyListModel dependencyListModel;
        super.storeProperties();
        this.storeManifestChanges();
        if (this.bundleInfo != null && this.bundleInfo.isModified()) {
            this.bundleInfo.store();
        }
        if ((dependencyListModel = this.getDependenciesListModel()).isChanged()) {
            TreeSet depsToSave = new TreeSet(dependencyListModel.getDependencies());
            depsToSave.removeAll(dependencyListModel.getRemovedDependencies());
            depsToSave.addAll(dependencyListModel.getAddedDependencies());
            Map toEdit = dependencyListModel.getEditedDependencies();
            Iterator it = toEdit.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                depsToSave.remove(entry.getKey());
                depsToSave.add(entry.getValue());
            }
            this.getProjectXMLManager().replaceDependencies(depsToSave);
        }
        String[] friends = this.getFriendListModel().getFriends();
        String[] publicPkgs = this.getPublicPackagesModel().getSelectedPackages();
        if (this.getPublicPackagesModel().isChanged() || this.getFriendListModel().isChanged()) {
            if (friends.length > 0) {
                this.getProjectXMLManager().replaceFriends(friends, publicPkgs);
            } else {
                this.getProjectXMLManager().replacePublicPackages(publicPkgs);
            }
        }
        if (this.isStandalone()) {
            ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
            ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
        } else if (this.isNetBeansOrg()) {
            ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), true);
        }
    }

    private void storeManifestChanges() throws IOException {
        EditableManifest em;
        FileObject manifestFO = FileUtil.toFileObject((File)this.getManifestFile());
        if (manifestFO != null) {
            em = Util.loadManifest(manifestFO);
        } else {
            em = new EditableManifest();
            manifestFO = FileUtil.createData((FileObject)this.getHelper().getProjectDirectory(), (String)"manifest.mf");
        }
        boolean changed = false;
        if (this.majorReleaseVersionChanged) {
            String module = "".equals(this.getMajorReleaseVersion()) ? this.getCodeNameBase() : this.getCodeNameBase() + '/' + this.getMajorReleaseVersion();
            this.setManifestAttribute(em, "OpenIDE-Module", module);
            changed = true;
        }
        if (this.specificationVersionChanged) {
            this.setManifestAttribute(em, "OpenIDE-Module-Specification-Version", this.getSpecificationVersion());
            changed = true;
        }
        if (this.implementationVersionChange) {
            this.setManifestAttribute(em, "OpenIDE-Module-Implementation-Version", this.getImplementationVersion());
            changed = true;
        }
        if (this.providedTokensChanged) {
            this.setManifestAttribute(em, "OpenIDE-Module-Provides", this.getProvidedTokens());
            changed = true;
        }
        if (this.getRequiredTokenListModel().isChanged()) {
            String[] reqTokens = this.getRequiredTokenListModel().getTokens();
            StringBuffer result = new StringBuffer(reqTokens.length > 1 ? "\n  " : "");
            for (int i = 0; i < reqTokens.length; ++i) {
                if (i != 0) {
                    result.append(",\n  ");
                }
                result.append(reqTokens[i]);
            }
            this.setManifestAttribute(em, "OpenIDE-Module-Requires", result.toString());
            changed = true;
        }
        if (changed) {
            Util.storeManifest(manifestFO, em);
        }
    }

    private void setManifestAttribute(EditableManifest em, String key, String value) {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        if ("".equals(value)) {
            if (em.getAttribute(key, null) != null) {
                em.removeAttribute(key, null);
            }
        } else {
            em.setAttribute(key, value, null);
        }
    }

    File getManifestFile() {
        return this.getHelper().resolveFile(this.getEvaluator().getProperty("manifest.mf"));
    }

    SortedSet getModuleCategories() {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.getModuleCategories() cannot be called from EDT");
        }
        if (this.modCategories == null && !this.reloadModuleListInfo()) {
            return new TreeSet();
        }
        return this.modCategories;
    }

    boolean reloadModuleListInfo() {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.reloadModuleListInfo() cannot be called from EDT");
        }
        if (this.isActivePlatformValid()) {
            try {
                TreeSet<Object> allCategories = new TreeSet<Object>(Collator.getInstance());
                HashSet<ModuleDependency> allDependencies = new HashSet<ModuleDependency>();
                Iterator it = this.getModuleList().getAllEntriesSoft().iterator();
                while (it.hasNext()) {
                    String cat;
                    ModuleEntry me = (ModuleEntry)it.next();
                    if (!me.getCodeNameBase().equals(this.getCodeNameBase())) {
                        allDependencies.add(new ModuleDependency(me));
                    }
                    if ((cat = me.getCategory()) == null) continue;
                    allCategories.add(cat);
                }
                this.modCategories = Collections.unmodifiableSortedSet(allCategories);
                this.universeDependencies = Collections.unmodifiableSet(allDependencies);
                return true;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return false;
    }

    private static void addNonEmptyPackagesFromJar(Set packages, File jarFile) {
        FileObject jarFileFO = FileUtil.toFileObject((File)jarFile);
        if (jarFileFO == null) {
            return;
        }
        FileObject root = FileUtil.getArchiveRoot((FileObject)jarFileFO);
        if (root == null) {
            return;
        }
        HashSet pkgs = new HashSet();
        SingleModuleProperties.addNonEmptyPackages(pkgs, root, "class");
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            FileObject pkg = (FileObject)it.next();
            if (root.equals(pkg)) continue;
            String pkgS = pkg.getPath();
            packages.add(pkgS.replace('/', '.'));
        }
    }

    private static void addNonEmptyPackages(Set validPkgs, FileObject dir, String ext) {
        if (dir == null) {
            return;
        }
        Enumeration en1 = dir.getFolders(false);
        while (en1.hasMoreElements()) {
            FileObject subDir = (FileObject)en1.nextElement();
            if (!VisibilityQuery.getDefault().isVisible(subDir)) continue;
            SingleModuleProperties.addNonEmptyPackages(validPkgs, subDir, ext);
        }
        Enumeration en2 = dir.getData(false);
        while (en2.hasMoreElements()) {
            FileObject kid = (FileObject)en2.nextElement();
            if (!kid.hasExt(ext) || !Utilities.isJavaIdentifier((String)kid.getName())) continue;
            validPkgs.add(dir);
            break;
        }
    }

    ModuleList getModuleList() throws IOException {
        if (this.getActivePlatform() != this.originalPlatform) {
            return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory()), this.getActivePlatform().getDestDir());
        }
        return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory()));
    }

    File evaluateFile(String currentLicence) {
        String evaluated = this.getEvaluator().evaluate(currentLicence);
        return evaluated == null ? null : this.getHelper().resolveFile(evaluated);
    }

    Project getProject() {
        Project p;
        block2: {
            p = null;
            try {
                p = ProjectManager.getDefault().findProject(this.getHelper().getProjectDirectory());
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return p;
    }

    static {
        $assertionsDisabled = !SingleModuleProperties.class.desiredAssertionStatus();
        IDE_TOKENS = new String[]{"org.openide.modules.os.Windows", "org.openide.modules.os.Unix", "org.openide.modules.os.MacOSX", "org.openide.modules.os.PlainUnix", "org.openide.modules.os.OS2"};
        SOURCE_LEVELS = new String[]{"1.4", "1.5"};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(BUILD_COMPILER_DEBUG, "true");
        map.put(BUILD_COMPILER_DEPRECATION, "true");
        map.put(IS_AUTOLOAD, "false");
        map.put(IS_EAGER, "false");
        map.put(JAVAC_SOURCES, "1.4");
        map.put(NBM_IS_GLOBAL, "false");
        map.put(NBM_NEEDS_RESTART, "false");
        DEFAULTS = Collections.unmodifiableMap(map);
    }
}

