/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    static final String[] PREDEFINED_COOKIE_CLASSES;
    private static final String[] HARDCODED_IMPORTS;
    private static final Map CLASS_TO_CNB;
    private static final String NEW_LINE;
    private static final String INDENT = "    ";
    private static final String INDENT_2X = "        ";
    private CreatedModifiedFiles cmf;
    private boolean alwaysEnabled;
    private String[] cookieClasses;
    private boolean multiSelection;
    private String category;
    private boolean globalMenuItemEnabled;
    private String gmiParentMenuPath;
    private Position gmiPosition;
    private boolean gmiSeparatorAfter;
    private boolean gmiSeparatorBefore;
    private boolean toolbarEnabled;
    private String toolbar;
    private Position toolbarPosition;
    private boolean kbShortcutEnabled;
    private final Set keyStrokes = new HashSet();
    private boolean ftContextEnabled;
    private String ftContextType;
    private Position ftContextPosition;
    private boolean ftContextSeparatorAfter;
    private boolean ftContextSeparatorBefore;
    private boolean edContextEnabled;
    private String edContextType;
    private Position edContextPosition;
    private boolean edContextSeparatorAfter;
    private boolean edContextSeparatorBefore;
    private String className;
    private String displayName;
    private String origIconPath;
    private String largeIconPath;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    private void regenerate() {
        String dashedPkgName = this.getPackageName().replace('.', '-');
        String dashedFqClassName = dashedPkgName + '-' + this.className;
        String shadow = dashedFqClassName + ".shadow";
        this.cmf = new CreatedModifiedFiles(this.getProject());
        String actionPath = this.getDefaultPackagePath(this.className + ".java");
        URL template = DataModel.class.getResource(this.alwaysEnabled ? "callableSystemAction.javx" : "cookieAction.javx");
        String actionNameKey = "CTL_" + this.className;
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("@@CLASS_NAME@@", this.className);
        replaceTokens.put("@@PACKAGE_NAME@@", this.getPackageName());
        replaceTokens.put("@@DISPLAY_NAME_KEY@@", actionNameKey);
        replaceTokens.put("@@MODE@@", this.getSelectionMode());
        TreeSet<String> imports = new TreeSet<String>(Arrays.asList(HARDCODED_IMPORTS));
        TreeSet<String> addedFQNCs = new TreeSet<String>();
        if (!this.alwaysEnabled) {
            String impl;
            StringBuffer cookieSB = new StringBuffer();
            for (int i = 0; i < this.cookieClasses.length; ++i) {
                if (CLASS_TO_CNB.containsKey(this.cookieClasses[i])) {
                    addedFQNCs.add(this.cookieClasses[i]);
                }
                cookieSB.append("            " + DataModel.parseClassName(this.cookieClasses[i]) + ".class");
                if (i == this.cookieClasses.length - 1) continue;
                cookieSB.append(',' + NEW_LINE);
            }
            replaceTokens.put("@@COOKIE_CLASSES_BLOCK@@", cookieSB.toString());
            if (this.cookieClasses.length == 1) {
                String cName = DataModel.parseClassName(this.cookieClasses[0]);
                impl = cName + " c = (" + cName + ") activatedNodes[0].getCookie(" + cName + ".class);\n" + INDENT_2X + "// TODO use c";
            } else {
                impl = "// TODO implement action body";
            }
            replaceTokens.put("@@PERFORM_ACTION_CODE@@", impl);
        }
        imports.addAll(addedFQNCs);
        StringBuffer importsBuffer = new StringBuffer();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            importsBuffer.append("import " + it.next() + ';' + NEW_LINE);
        }
        replaceTokens.put("@@IMPORTS@@", importsBuffer.toString());
        this.cmf.add(this.cmf.createFileWithSubstitutions(actionPath, template, replaceTokens));
        this.cmf.add(this.cmf.bundleKey(this.getDefaultPackagePath("Bundle.properties"), actionNameKey, this.displayName));
        if (this.origIconPath != null) {
            String relativeIconPath = this.addCreateIconOperation(this.cmf, this.origIconPath);
            replaceTokens.put("@@ICON_RESOURCE_METHOD@@", DataModel.generateIconResourceMethod(relativeIconPath));
            replaceTokens.put("@@INITIALIZE_METHOD@@", "");
        } else {
            replaceTokens.put("@@ICON_RESOURCE_METHOD@@", "");
            replaceTokens.put("@@INITIALIZE_METHOD@@", DataModel.generateNoIconInitializeMethod());
        }
        if (this.isToolbarEnabled() && this.largeIconPath != null) {
            this.addCreateIconOperation(this.cmf, this.largeIconPath);
        }
        String instanceFullPath = this.category + "/" + dashedFqClassName + ".instance";
        this.cmf.add(this.cmf.createLayerEntry(instanceFullPath, null, null, null, null));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        if (!this.alwaysEnabled) {
            this.cmf.add(this.cmf.addModuleDependency("org.openide.nodes"));
            Iterator it2 = addedFQNCs.iterator();
            while (it2.hasNext()) {
                this.cmf.add(this.cmf.addModuleDependency((String)CLASS_TO_CNB.get(it2.next())));
            }
        }
        if (this.globalMenuItemEnabled) {
            this.generateShadowWithOrderAndSeparator(this.gmiParentMenuPath, shadow, dashedPkgName, instanceFullPath, this.gmiSeparatorBefore, this.gmiSeparatorAfter, this.gmiPosition);
        }
        if (this.toolbarEnabled) {
            this.generateOrder(this.toolbar, this.toolbarPosition.getBefore(), shadow);
            this.generateShadow(this.toolbar + "/" + shadow, instanceFullPath);
            this.generateOrder(this.toolbar, shadow, this.toolbarPosition.getAfter());
        }
        if (this.kbShortcutEnabled) {
            String parentPath = "Shortcuts";
            Iterator it3 = this.keyStrokes.iterator();
            while (it3.hasNext()) {
                String keyStroke = (String)it3.next();
                this.generateShadow(parentPath + "/" + keyStroke + ".shadow", instanceFullPath);
            }
        }
        if (this.ftContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.ftContextType, shadow, dashedPkgName, instanceFullPath, this.ftContextSeparatorBefore, this.ftContextSeparatorAfter, this.ftContextPosition);
        }
        if (this.edContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.edContextType, shadow, dashedPkgName, instanceFullPath, this.edContextSeparatorBefore, this.edContextSeparatorAfter, this.edContextPosition);
        }
    }

    private void generateShadowWithOrderAndSeparator(String parentPath, String shadow, String dashedPkgName, String instanceFullPath, boolean separatorBefore, boolean separatorAfter, Position position) {
        String sepName;
        if (separatorBefore) {
            sepName = dashedPkgName + "-separatorBefore.instance";
            this.generateSeparator(parentPath, sepName);
            this.generateOrder(parentPath, position.getBefore(), sepName);
            this.generateOrder(parentPath, sepName, shadow);
        } else {
            this.generateOrder(parentPath, position.getBefore(), shadow);
        }
        this.generateShadow(parentPath + "/" + shadow, instanceFullPath);
        if (separatorAfter) {
            sepName = dashedPkgName + "-separatorAfter.instance";
            this.generateSeparator(parentPath, sepName);
            this.generateOrder(parentPath, shadow, sepName);
            this.generateOrder(parentPath, sepName, position.getAfter());
        } else {
            this.generateOrder(parentPath, shadow, position.getAfter());
        }
    }

    private void generateOrder(String layerPath, String before, String after) {
        if (before != null && after != null) {
            this.cmf.add(this.cmf.orderLayerEntry(layerPath, before, after));
        }
    }

    boolean classExists() {
        FileObject classFO = this.getProject().getProjectDirectory().getFileObject(this.getDefaultPackagePath(this.className + ".java"));
        return classFO != null;
    }

    private void generateShadow(String itemPath, String origInstance) {
        this.cmf.add(this.cmf.createLayerEntry(itemPath, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(itemPath, "originalFile", origInstance));
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            this.regenerate();
        }
        return this.cmf;
    }

    private void reset() {
        this.cmf = null;
    }

    void setAlwaysEnabled(boolean alwaysEnabled) {
        this.alwaysEnabled = alwaysEnabled;
    }

    boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    void setCookieClasses(String[] cookieClasses) {
        this.cookieClasses = cookieClasses;
    }

    void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    private String getSelectionMode() {
        return this.multiSelection ? "MODE_ALL" : "MODE_EXACTLY_ONE";
    }

    void setCategory(String category) {
        this.category = category;
    }

    void setClassName(String className) {
        this.reset();
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    void setDisplayName(String display) {
        this.displayName = display;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setIconPath(String origIconPath) {
        this.reset();
        this.origIconPath = origIconPath;
    }

    public String getIconPath() {
        return this.origIconPath;
    }

    public void setPackageName(String pkg) {
        super.setPackageName(pkg);
        this.reset();
    }

    void setGlobalMenuItemEnabled(boolean globalMenuItemEnabled) {
        this.globalMenuItemEnabled = globalMenuItemEnabled;
    }

    void setGMIParentMenu(String gmiParentMenuPath) {
        this.gmiParentMenuPath = gmiParentMenuPath;
    }

    void setGMISeparatorAfter(boolean gmiSeparatorAfter) {
        this.gmiSeparatorAfter = gmiSeparatorAfter;
    }

    void setGMISeparatorBefore(boolean gmiSeparatorBefore) {
        this.gmiSeparatorBefore = gmiSeparatorBefore;
    }

    void setGMIPosition(Position position) {
        this.gmiPosition = position;
    }

    void setToolbarEnabled(boolean toolbarEnabled) {
        this.toolbarEnabled = toolbarEnabled;
    }

    boolean isToolbarEnabled() {
        return this.toolbarEnabled;
    }

    void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    void setToolbarPosition(Position position) {
        this.toolbarPosition = position;
    }

    void setKeyboardShortcutEnabled(boolean kbShortcutEnabled) {
        this.kbShortcutEnabled = kbShortcutEnabled;
    }

    void setKeyStroke(String keyStroke) {
        this.keyStrokes.add(keyStroke);
    }

    void setFileTypeContextEnabled(boolean contextEnabled) {
        this.ftContextEnabled = contextEnabled;
    }

    void setFTContextType(String contextType) {
        this.ftContextType = contextType;
    }

    void setFTContextPosition(Position position) {
        this.ftContextPosition = position;
    }

    void setFTContextSeparatorAfter(boolean separator) {
        this.ftContextSeparatorAfter = separator;
    }

    void setFTContextSeparatorBefore(boolean separator) {
        this.ftContextSeparatorBefore = separator;
    }

    void setEditorContextEnabled(boolean contextEnabled) {
        this.edContextEnabled = contextEnabled;
    }

    void setEdContextType(String contextType) {
        this.edContextType = contextType;
    }

    void setEdContextPosition(Position position) {
        this.edContextPosition = position;
    }

    void setEdContextSeparatorAfter(boolean separator) {
        this.edContextSeparatorAfter = separator;
    }

    void setEdContextSeparatorBefore(boolean separator) {
        this.edContextSeparatorBefore = separator;
    }

    private void generateSeparator(String parentPath, String sepName) {
        String sepPath = parentPath + "/" + sepName;
        this.cmf.add(this.cmf.createLayerEntry(sepPath, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(sepPath, "instanceClass", "javax.swing.JSeparator"));
    }

    static String parseClassName(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? name : name.substring(lastDot + 1);
    }

    private static String generateIconResourceMethod(String relativeIconPath) {
        return NEW_LINE + INDENT + "protected String iconResource() {" + NEW_LINE + INDENT_2X + "return \"" + relativeIconPath + "\";" + NEW_LINE + INDENT + "}";
    }

    private static String generateNoIconInitializeMethod() {
        return "protected void initialize() {" + NEW_LINE + INDENT_2X + "super.initialize();" + NEW_LINE + INDENT_2X + "// see org.openide.util.actions.SystemAction.iconResource() javadoc for more details" + NEW_LINE + INDENT_2X + "putValue(\"noIconInMenu\", Boolean.TRUE);" + NEW_LINE + INDENT + "}" + NEW_LINE;
    }

    public void setLargeIconPath(String largeIconPath) {
        this.largeIconPath = largeIconPath;
    }

    static {
        HARDCODED_IMPORTS = new String[]{"org.openide.nodes.Node", "org.openide.util.HelpCtx", "org.openide.util.NbBundle", "org.openide.util.actions.CookieAction"};
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("org.openide.loaders.DataObject", "org.openide.loaders");
        map.put("org.openide.cookies.EditCookie", "org.openide.nodes");
        map.put("org.openide.cookies.OpenCookie", "org.openide.nodes");
        map.put("org.netbeans.api.project.Project", "org.netbeans.modules.projectapi");
        map.put("org.openide.cookies.EditorCookie", "org.openide.text");
        CLASS_TO_CNB = Collections.unmodifiableMap(map);
        PREDEFINED_COOKIE_CLASSES = new String[5];
        CLASS_TO_CNB.keySet().toArray(PREDEFINED_COOKIE_CLASSES);
        NEW_LINE = System.getProperty("line.separator");
    }

    static final class Position {
        private String before;
        private String after;
        private String beforeName;
        private String afterName;

        Position(String before, String after) {
            this(before, after, null, null);
        }

        Position(String before, String after, String beforeName, String afterName) {
            this.before = before;
            this.after = after;
            this.beforeName = beforeName;
            this.afterName = afterName;
        }

        String getBefore() {
            return this.before;
        }

        String getAfter() {
            return this.after;
        }

        String getBeforeName() {
            return this.beforeName;
        }

        String getAfterName() {
            return this.afterName;
        }
    }
}

