/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntryWithSources;
import org.netbeans.modules.apisupport.project.universe.BinaryEntry;
import org.netbeans.modules.apisupport.project.universe.ExternalEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgEntry;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleList {
    static long timeSpentInXmlParsing;
    static int xmlFilesParsed;
    static int directoriesChecked;
    static int jarsOpened;
    public static final String DEST_DIR_IN_NETBEANS_ORG;
    public static final int DEPTH_NB_ALL = 3;
    private static final Map sourceLists;
    private static final Map binaryLists;
    private static final Map clusterPropertiesFiles;
    private static final Map clusterLocations;
    private static final Map knownEntries;
    public static final Set EXCLUDED_DIR_NAMES;
    private static final Map DIR_SCAN_CACHE;
    private static final String[] MODULE_DIRS;
    private static final String PROJECT_XML;
    private Map entries;
    private final File home;
    private boolean lazyNetBeansOrgList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ModuleList getModuleList(File basedir) throws IOException {
        return ModuleList.getModuleList(basedir, null);
    }

    public static ModuleList getModuleList(final File basedir, final File customNbDestDir) throws IOException {
        try {
            return (ModuleList)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    Map map = binaryLists;
                    synchronized (map) {
                        boolean standalone;
                        timeSpentInXmlParsing = 0L;
                        xmlFilesParsed = 0;
                        directoriesChecked = 0;
                        jarsOpened = 0;
                        Element data = ModuleList.parseData(basedir);
                        if (data == null) {
                            throw new IOException("Not an NBM project in " + basedir);
                        }
                        boolean suiteComponent = Util.findElement(data, "suite-component", "http://www.netbeans.org/ns/nb-module-project/2") != null;
                        boolean bl = standalone = Util.findElement(data, "standalone", "http://www.netbeans.org/ns/nb-module-project/2") != null;
                        if (!$assertionsDisabled && suiteComponent && standalone) {
                            throw new AssertionError(basedir);
                        }
                        if (suiteComponent) {
                            PropertyEvaluator eval = ModuleList.parseProperties(basedir, null, true, false, "irrelevant");
                            String suiteS = eval.getProperty("suite.dir");
                            if (suiteS == null) {
                                throw new IOException("No suite.dir defined from " + basedir);
                            }
                            File suite = PropertyUtils.resolveFile((File)basedir, (String)suiteS);
                            return ModuleList.findOrCreateModuleListFromSuite(suite, customNbDestDir);
                        }
                        if (standalone) {
                            return ModuleList.findOrCreateModuleListFromStandaloneModule(basedir, customNbDestDir);
                        }
                        File nbroot = ModuleList.findNetBeansOrg(basedir);
                        if (nbroot == null) {
                            throw new IOException("Could not find netbeans.org CVS root from " + basedir + "; note that 3rd-level modules (a/b/c) are permitted at the maximum");
                        }
                        return ModuleList.findOrCreateModuleListFromNetBeansOrgSources(nbroot);
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$universe$ModuleList == null ? (class$org$netbeans$modules$apisupport$project$universe$ModuleList = ModuleList.class$("org.netbeans.modules.apisupport.project.universe.ModuleList")) : class$org$netbeans$modules$apisupport$project$universe$ModuleList).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existKnownEntries() {
        Map map = knownEntries;
        synchronized (map) {
            return !knownEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getKnownEntries(File file) {
        Map map = knownEntries;
        synchronized (map) {
            Set entries = (Set)knownEntries.get(file);
            if (entries != null) {
                return new HashSet(entries);
            }
            return Collections.EMPTY_SET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEntry(ModuleEntry entry, Set files) {
        Map map = knownEntries;
        synchronized (map) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                HashSet<ModuleEntry> entries = (HashSet<ModuleEntry>)knownEntries.get(f);
                if (entries == null) {
                    entries = new HashSet<ModuleEntry>();
                    knownEntries.put(f, entries);
                }
                entries.add(entry);
            }
        }
    }

    static ModuleList findOrCreateModuleListFromNetBeansOrgSources(File root) throws IOException {
        ModuleList list = (ModuleList)sourceLists.get(root);
        if (list == null) {
            list = ModuleList.createModuleListFromNetBeansOrgSources(root);
            sourceLists.put(root, list);
        }
        return list;
    }

    private static ModuleList createModuleListFromNetBeansOrgSources(File root) throws IOException {
        Util.err.log("ModuleList.createModuleListFromSources: " + root);
        File nbdestdir = new File(root, DEST_DIR_IN_NETBEANS_ORG);
        HashMap entries = new HashMap();
        ModuleList.scanNetBeansOrgStableSources(entries, root, nbdestdir);
        return new ModuleList(entries, root, true);
    }

    private static void scanNetBeansOrgStableSources(Map entries, File root, File nbdestdir) throws IOException {
        Map clusterProps = ModuleList.getClusterProperties(root);
        String clusterList = (String)clusterProps.get("clusters.list");
        if (clusterList == null) {
            throw new IOException("No ${nb.clusters.list} found in " + root);
        }
        StringTokenizer tok = new StringTokenizer(clusterList, ", ");
        while (tok.hasMoreTokens()) {
            String clusterName = tok.nextToken();
            String moduleList = (String)clusterProps.get(clusterName);
            if (moduleList == null) {
                throw new IOException("No ${" + clusterName + "} found in " + root);
            }
            StringTokenizer tok2 = new StringTokenizer(moduleList, ", ");
            while (tok2.hasMoreTokens()) {
                String module = tok2.nextToken();
                ModuleList.scanPossibleProject(new File(root, module.replace('/', File.separatorChar)), entries, false, false, root, nbdestdir, module, true);
            }
        }
    }

    private static void doScanNetBeansOrgSources(Map entries, File dir, int depth, File root, File nbdestdir, String pathPrefix, boolean warnReDuplicates) {
        File[] kids = dir.listFiles();
        if (kids == null) {
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            String name;
            if (!kids[i].isDirectory() || EXCLUDED_DIR_NAMES.contains(name = kids[i].getName())) continue;
            String newPathPrefix = pathPrefix != null ? pathPrefix + "/" + name : name;
            try {
                ModuleList.scanPossibleProject(kids[i], entries, false, false, root, nbdestdir, newPathPrefix, warnReDuplicates);
            }
            catch (IOException e) {
                Util.err.annotate((Throwable)e, 0, "Malformed project metadata in " + kids[i] + ", skipping...", null, null, null);
                Util.err.notify(1, (Throwable)e);
            }
            if (depth <= 1) continue;
            ModuleList.doScanNetBeansOrgSources(entries, kids[i], depth - 1, root, nbdestdir, newPathPrefix, warnReDuplicates);
        }
    }

    private static void scanPossibleProject(File basedir, Map entries, boolean suiteComponent, boolean standalone, File root, File nbdestdir, String path, boolean warnReDuplicates) throws IOException {
        ++directoriesChecked;
        Element data = ModuleList.parseData(basedir);
        if (data == null) {
            return;
        }
        if (!$assertionsDisabled && !(root != null ^ (standalone || suiteComponent))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(path != null ^ (standalone || suiteComponent))) {
            throw new AssertionError();
        }
        String cnb = Util.findText(Util.findElement(data, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2"));
        PropertyEvaluator eval = ModuleList.parseProperties(basedir, root, suiteComponent, standalone, cnb);
        String module = eval.getProperty("module.jar");
        StringBuffer cpextra = new StringBuffer();
        Iterator exts = Util.findSubElements(data).iterator();
        while (exts.hasNext()) {
            String text;
            Element ext = (Element)exts.next();
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element binaryOrigin = Util.findElement(ext, "binary-origin", "http://www.netbeans.org/ns/nb-module-project/2");
            if (binaryOrigin != null) {
                text = Util.findText(binaryOrigin);
            } else {
                Element runtimeRelativePath = Util.findElement(ext, "runtime-relative-path", "http://www.netbeans.org/ns/nb-module-project/2");
                if (!$assertionsDisabled && runtimeRelativePath == null) {
                    throw new AssertionError((Object)("Malformed <class-path-extension> in " + basedir));
                }
                String reltext = Util.findText(runtimeRelativePath);
                text = "${cluster}/${module.jar.dir}/" + reltext;
            }
            String evaluated = eval.evaluate(text);
            if (evaluated == null) continue;
            File binary = PropertyUtils.resolveFile((File)basedir, (String)evaluated);
            cpextra.append(':');
            cpextra.append(binary.getAbsolutePath());
        }
        File manifest = new File(basedir, "manifest.mf");
        ManifestManager mm = manifest.isFile() ? ManifestManager.getInstance(manifest, false) : ManifestManager.NULL_INSTANCE;
        File clusterDir = PropertyUtils.resolveFile((File)basedir, (String)eval.evaluate("${cluster}"));
        ManifestManager.PackageExport[] publicPackages = ProjectXMLManager.findPublicPackages(data);
        String[] friends = ProjectXMLManager.findFriends(data);
        AbstractEntryWithSources entry = !suiteComponent && !standalone ? new NetBeansOrgEntry(root, cnb, path, clusterDir, module, cpextra.toString(), mm.getReleaseVersion(), mm.getProvidedTokens(), publicPackages, friends, mm.isDeprecated()) : new ExternalEntry(basedir, cnb, clusterDir, PropertyUtils.resolveFile((File)clusterDir, (String)module), cpextra.toString(), nbdestdir, mm.getReleaseVersion(), mm.getProvidedTokens(), publicPackages, friends, mm.isDeprecated());
        if (entries.containsKey(cnb)) {
            if (warnReDuplicates) {
                Util.err.log(16, "Warning: two modules found with the same code name base (" + cnb + "): " + entries.get(cnb) + " and " + entry);
            }
        } else {
            entries.put(cnb, entry);
        }
        ModuleList.registerEntry(entry, ModuleList.findSourceNBMFiles(entry, eval));
    }

    private static Set findSourceNBMFiles(ModuleEntry entry, PropertyEvaluator eval) throws IOException {
        HashSet<File> files = new HashSet<File>();
        files.add(entry.getJarLocation());
        File cluster = entry.getClusterDirectory();
        String cnbd = entry.getCodeNameBase().replace('.', '-');
        String[] STANDARD_FILES = new String[]{"update_tracking/*.xml", "config/Modules/*.xml", "config/ModuleAutoDeps/*.xml", "ant/nblib/*.jar", "modules/docs/*.jar"};
        for (int i = 0; i < STANDARD_FILES.length; ++i) {
            int x = STANDARD_FILES[i].indexOf(42);
            ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, STANDARD_FILES[i].substring(0, x) + cnbd + STANDARD_FILES[i].substring(x + 1));
        }
        String emf = eval.getProperty("extra.module.files");
        if (emf != null) {
            String[] entries = emf.split(" *, *");
            for (int i = 0; i < entries.length; ++i) {
                String pattern = entries[i];
                if (pattern.endsWith("/")) {
                    pattern = pattern + "**";
                }
                if (pattern.indexOf(42) == -1) {
                    ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, pattern);
                    continue;
                }
                String regex = "\\Q" + pattern.replaceAll("\\*\\*", "__DBLASTERISK__").replaceAll("\\*", "\\\\E[^/]*\\\\Q").replaceAll("__DBLASTERISK__", "\\\\E.*\\\\Q") + "\\E";
                Pattern regexp = Pattern.compile(regex);
                String[] clusterFiles = ModuleList.scanDirForFiles(cluster);
                for (int j = 0; j < clusterFiles.length; ++j) {
                    if (!regexp.matcher(clusterFiles[j]).matches()) continue;
                    ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, clusterFiles[j]);
                }
            }
        }
        File src = entry.getSourceLocation();
        if (!($assertionsDisabled || src != null && src.isDirectory())) {
            throw new AssertionError(entry);
        }
        File releaseDir = new File(src, "release");
        if (releaseDir.isDirectory()) {
            String[] releaseFiles = ModuleList.scanDirForFiles(releaseDir);
            for (int i = 0; i < releaseFiles.length; ++i) {
                ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, releaseFiles[i]);
            }
        }
        return files;
    }

    private static void findSourceNBMFilesMaybeAdd(Set files, File cluster, String path) {
        File f = new File(cluster, path.replace('/', File.separatorChar));
        files.add(f);
    }

    private static String[] scanDirForFiles(File dir) {
        String[] files = (String[])DIR_SCAN_CACHE.get(dir);
        if (files == null) {
            ArrayList l = new ArrayList(250);
            ModuleList.doScanDirForFiles(dir, l, "");
            files = l.toArray(new String[l.size()]);
        }
        return files;
    }

    private static void doScanDirForFiles(File d, List files, String prefix) {
        ++directoriesChecked;
        File[] kids = d.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isFile()) {
                    files.add(prefix + f.getName());
                    continue;
                }
                if (!f.isDirectory()) continue;
                ModuleList.doScanDirForFiles(f, files, prefix + f.getName() + '/');
            }
        }
    }

    public static ModuleList findOrCreateModuleListFromSuite(File root, File customNbDestDir) throws IOException {
        File nbdestdir;
        PropertyEvaluator eval = ModuleList.parseSuiteProperties(root);
        if (customNbDestDir == null) {
            String nbdestdirS = eval.getProperty("netbeans.dest.dir");
            if (nbdestdirS == null) {
                throw new IOException("No netbeans.dest.dir defined in " + root);
            }
            nbdestdir = PropertyUtils.resolveFile((File)root, (String)nbdestdirS);
        } else {
            nbdestdir = customNbDestDir;
        }
        return ModuleList.merge(new ModuleList[]{ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, nbdestdir, eval), ModuleList.findOrCreateModuleListFromBinaries(nbdestdir)}, root);
    }

    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File root, File nbdestdir, PropertyEvaluator eval) throws IOException {
        ModuleList sources = (ModuleList)sourceLists.get(root);
        if (sources == null) {
            HashMap entries = new HashMap();
            File[] modules = ModuleList.findModulesInSuite(root, eval);
            for (int i = 0; i < modules.length; ++i) {
                try {
                    ModuleList.scanPossibleProject(modules[i], entries, true, false, null, nbdestdir, null, true);
                    continue;
                }
                catch (IOException e) {
                    Util.err.annotate((Throwable)e, 0, "Malformed project metadata in " + modules[i] + ", skipping...", null, null, null);
                    Util.err.notify(1, (Throwable)e);
                }
            }
            sources = new ModuleList(entries, root, false);
            sourceLists.put(root, sources);
        }
        return sources;
    }

    static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File root) throws IOException {
        PropertyEvaluator eval = ModuleList.parseSuiteProperties(root);
        String nbdestdirS = eval.getProperty("netbeans.dest.dir");
        if (nbdestdirS == null) {
            throw new IOException("No netbeans.dest.dir defined in " + root);
        }
        File nbdestdir = PropertyUtils.resolveFile((File)root, (String)nbdestdirS);
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, nbdestdir, eval);
    }

    private static PropertyEvaluator parseSuiteProperties(File root) throws IOException {
        HashMap<Object, Object> predefs = new HashMap<Object, Object>(System.getProperties());
        predefs.put("basedir", root.getAbsolutePath());
        PropertyProvider predefsProvider = PropertyUtils.fixedPropertyProvider(predefs);
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "platform.properties")));
        PropertyEvaluator eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        String buildS = eval.getProperty("user.properties.file");
        if (buildS != null) {
            providers.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)root, (String)buildS)));
        } else {
            providers.add(PropertyUtils.globalPropertyProvider());
        }
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "project.properties")));
        eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        String platformS = eval.getProperty("nbplatform.active");
        if (platformS != null) {
            providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + platformS + ".netbeans.dest.dir}")));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    static File[] findModulesInSuite(File root) throws IOException {
        return ModuleList.findModulesInSuite(root, ModuleList.parseSuiteProperties(root));
    }

    private static File[] findModulesInSuite(File root, PropertyEvaluator eval) throws IOException {
        String modulesS = eval.getProperty("modules");
        if (modulesS == null) {
            modulesS = "";
        }
        String[] modulesA = PropertyUtils.tokenizePath((String)modulesS);
        File[] modules = new File[modulesA.length];
        for (int i = 0; i < modulesA.length; ++i) {
            modules[i] = PropertyUtils.resolveFile((File)root, (String)modulesA[i]);
        }
        return modules;
    }

    private static ModuleList findOrCreateModuleListFromStandaloneModule(File basedir, File customNbDestDir) throws IOException {
        File nbdestdir;
        PropertyEvaluator eval = ModuleList.parseProperties(basedir, null, false, true, "irrelevant");
        if (customNbDestDir == null) {
            String nbdestdirS = eval.getProperty("netbeans.dest.dir");
            if (nbdestdirS == null) {
                throw new IOException("No netbeans.dest.dir defined in " + basedir);
            }
            if (nbdestdirS.indexOf("${") != -1) {
                throw new IOException("Unevaluated properties in " + nbdestdirS + " from " + basedir + "; probably means platform definitions not loaded correctly");
            }
            nbdestdir = PropertyUtils.resolveFile((File)basedir, (String)nbdestdirS);
        } else {
            nbdestdir = customNbDestDir;
        }
        ModuleList binaries = ModuleList.findOrCreateModuleListFromBinaries(nbdestdir);
        ModuleList sources = (ModuleList)sourceLists.get(basedir);
        if (sources == null) {
            HashMap entries = new HashMap();
            ModuleList.scanPossibleProject(basedir, entries, false, true, null, nbdestdir, null, true);
            if (entries.isEmpty()) {
                throw new IOException("No module in " + basedir);
            }
            sources = new ModuleList(entries, basedir, false);
            sourceLists.put(basedir, sources);
        }
        return ModuleList.merge(new ModuleList[]{sources, binaries}, basedir);
    }

    static ModuleList findOrCreateModuleListFromBinaries(File root) throws IOException {
        ModuleList list = (ModuleList)binaryLists.get(root);
        if (list == null) {
            list = ModuleList.createModuleListFromBinaries(root);
            binaryLists.put(root, list);
        }
        return list;
    }

    private static ModuleList createModuleListFromBinaries(File root) throws IOException {
        Util.err.log("ModuleList.createModuleListFromBinaries: " + root);
        HashMap<String, BinaryEntry> entries = new HashMap<String, BinaryEntry>();
        File[] clusters = root.listFiles();
        if (clusters == null) {
            throw new IOException("Cannot examine dir " + root);
        }
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < MODULE_DIRS.length; ++j) {
                File dir = new File(clusters[i], MODULE_DIRS[j].replace('/', File.separatorChar));
                if (!dir.isDirectory()) continue;
                File[] jars = dir.listFiles();
                if (jars == null) {
                    throw new IOException("Cannot examine dir " + dir);
                }
                for (int k = 0; k < jars.length; ++k) {
                    File[] exts;
                    File m = jars[k];
                    if (!m.getName().endsWith(".jar")) continue;
                    ++jarsOpened;
                    ManifestManager mm = ManifestManager.getInstanceFromJAR(m);
                    String codenamebase = mm.getCodeNameBase();
                    if (codenamebase == null) continue;
                    String cp = mm.getClassPath();
                    if (cp == null) {
                        exts = new File[]{};
                    } else {
                        String[] pieces = cp.trim().split(" +");
                        exts = new File[pieces.length];
                        for (int l = 0; l < pieces.length; ++l) {
                            exts[l] = new File(dir, pieces[l].replace('/', File.separatorChar));
                        }
                    }
                    BinaryEntry entry = new BinaryEntry(codenamebase, m, exts, root, clusters[i], mm.getReleaseVersion(), mm.getSpecificationVersion(), mm.getProvidedTokens(), mm.getPublicPackages(), mm.getFriends(), mm.isDeprecated(), mm.getModuleDependencies());
                    if (entries.containsKey(codenamebase)) {
                        Util.err.log(16, "Warning: two modules found with the same code name base (" + codenamebase + "): " + entries.get(codenamebase) + " and " + entry);
                    } else {
                        entries.put(codenamebase, entry);
                    }
                    ModuleList.registerEntry(entry, ModuleList.findBinaryNBMFiles(clusters[i], codenamebase, m));
                }
            }
        }
        return new ModuleList(entries, root, false);
    }

    private static Set findBinaryNBMFiles(File cluster, String cnb, File jar) throws IOException {
        HashSet<File> files = new HashSet<File>();
        files.add(jar);
        File tracking = new File(new File(cluster, "update_tracking"), cnb.replace('.', '-') + ".xml");
        if (tracking.isFile()) {
            Document doc;
            files.add(tracking);
            try {
                ++xmlFilesParsed;
                timeSpentInXmlParsing -= System.currentTimeMillis();
                doc = XMLUtil.parse((InputSource)new InputSource(tracking.toURI().toString()), (boolean)false, (boolean)false, null, null);
                timeSpentInXmlParsing += System.currentTimeMillis();
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            Iterator it = Util.findSubElements(doc.getDocumentElement()).iterator();
            while (it.hasNext()) {
                Element moduleVersion = (Element)it.next();
                if (!moduleVersion.getTagName().equals("module_version") || !moduleVersion.getAttribute("last").equals("true")) continue;
                Iterator it2 = Util.findSubElements(moduleVersion).iterator();
                while (it2.hasNext()) {
                    String name;
                    File f;
                    Element fileEl = (Element)it2.next();
                    if (!fileEl.getTagName().equals("file") || !(f = new File(cluster, (name = fileEl.getAttribute("name")).replace('/', File.separatorChar))).isFile()) continue;
                    files.add(f);
                }
            }
        }
        return files;
    }

    static Element parseData(File basedir) throws IOException {
        Document doc;
        File projectXml = new File(basedir, PROJECT_XML);
        if (!projectXml.exists() || !projectXml.isFile()) {
            return null;
        }
        try {
            ++xmlFilesParsed;
            timeSpentInXmlParsing -= System.currentTimeMillis();
            doc = XMLUtil.parse((InputSource)new InputSource(projectXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
            timeSpentInXmlParsing += System.currentTimeMillis();
        }
        catch (SAXException e) {
            throw (IOException)new IOException(projectXml + ": " + e.toString()).initCause(e);
        }
        Element docel = doc.getDocumentElement();
        Element type = Util.findElement(docel, "type", "http://www.netbeans.org/ns/project/1");
        if (!Util.findText(type).equals("org.netbeans.modules.apisupport.project")) {
            return null;
        }
        Element cfg = Util.findElement(docel, "configuration", "http://www.netbeans.org/ns/project/1");
        return Util.findElement(cfg, "data", "http://www.netbeans.org/ns/nb-module-project/2");
    }

    static PropertyEvaluator parseProperties(File basedir, File root, boolean suiteComponent, boolean standalone, String cnb) throws IOException {
        boolean isNetBeansOrg;
        PropertyEvaluator eval;
        if (!$assertionsDisabled && suiteComponent && standalone) {
            throw new AssertionError(basedir);
        }
        HashMap<Object, Object> predefs = new HashMap<Object, Object>(System.getProperties());
        predefs.put("basedir", basedir.getAbsolutePath());
        PropertyProvider predefsProvider = PropertyUtils.fixedPropertyProvider(predefs);
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        if (suiteComponent) {
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "suite-private.properties")));
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "suite.properties")));
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            String suiteS = eval.getProperty("suite.dir");
            if (suiteS != null) {
                File suite = PropertyUtils.resolveFile((File)basedir, (String)suiteS);
                providers.add(ModuleList.loadPropertiesFile(new File(suite, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                providers.add(ModuleList.loadPropertiesFile(new File(suite, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (standalone) {
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "platform.properties")));
        }
        if (suiteComponent || standalone) {
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            String buildS = eval.getProperty("user.properties.file");
            if (buildS != null) {
                providers.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)basedir, (String)buildS)));
            } else {
                providers.add(PropertyUtils.globalPropertyProvider());
            }
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            String platformS = eval.getProperty("nbplatform.active");
            if (platformS != null) {
                providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + platformS + ".netbeans.dest.dir}")));
            }
        }
        providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "project.properties")));
        HashMap<String, String> defaults = new HashMap<String, String>();
        boolean bl = isNetBeansOrg = !suiteComponent && !standalone;
        if (isNetBeansOrg) {
            defaults.put("nb_all", root.getAbsolutePath());
            defaults.put("netbeans.dest.dir", new File(root, DEST_DIR_IN_NETBEANS_ORG).getAbsolutePath());
        }
        defaults.put("code.name.base.dashes", cnb.replace('.', '-'));
        defaults.put("module.jar.dir", "modules");
        defaults.put("module.jar.basename", "${code.name.base.dashes}.jar");
        defaults.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        providers.add(PropertyUtils.fixedPropertyProvider(defaults));
        if (suiteComponent) {
            defaults.put("cluster", "${suite.dir}/build/cluster");
        } else if (standalone) {
            defaults.put("cluster", "build/cluster");
        } else {
            String cluster = ModuleList.findClusterLocation(basedir, root);
            if (cluster == null) {
                cluster = "extra";
            }
            defaults.put("cluster", "${netbeans.dest.dir}/" + cluster);
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyProvider loadPropertiesFile(File f) throws IOException {
        if (!f.isFile()) {
            return PropertyUtils.fixedPropertyProvider((Map)Collections.EMPTY_MAP);
        }
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(f);
        try {
            p.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return PropertyUtils.fixedPropertyProvider((Map)p);
    }

    public static void refresh() {
        sourceLists.clear();
        binaryLists.clear();
    }

    public static void refreshSuiteModuleList(File suiteDir) {
        sourceLists.remove(suiteDir);
    }

    public static boolean isNetBeansOrg(File dir) {
        return new File(dir, "nbbuild").isDirectory() && new File(dir, "openide").isDirectory();
    }

    public static File findNetBeansOrg(File basedir) {
        File f = basedir;
        for (int i = 0; i < 3; ++i) {
            if ((f = f.getParentFile()) == null) {
                return null;
            }
            if (!ModuleList.isNetBeansOrg(f)) continue;
            return f;
        }
        return null;
    }

    private static Map getClusterProperties(File nbroot) throws IOException {
        Map clusterDefs = (Map)clusterPropertiesFiles.get(nbroot);
        if (clusterDefs == null) {
            PropertyProvider pp = ModuleList.loadPropertiesFile(new File(nbroot, "nbbuild" + File.separatorChar + "cluster.properties"));
            PropertyEvaluator clusterEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider((Map)Collections.EMPTY_MAP), (PropertyProvider[])new PropertyProvider[]{pp});
            clusterDefs = clusterEval.getProperties();
            if (clusterDefs == null) {
                clusterDefs = Collections.EMPTY_MAP;
            }
        }
        return clusterDefs;
    }

    private static String findClusterLocation(File basedir, File nbroot) throws IOException {
        String path = PropertyUtils.relativizeFile((File)nbroot, (File)basedir);
        if (!$assertionsDisabled && path.indexOf("..") != -1) {
            throw new AssertionError((Object)path);
        }
        HashMap<String, String> clusterLocationsHere = (HashMap<String, String>)clusterLocations.get(nbroot);
        if (clusterLocationsHere == null) {
            clusterLocationsHere = new HashMap<String, String>();
            Map clusterDefs = ModuleList.getClusterProperties(nbroot);
            Iterator it = clusterDefs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String clusterDir = (String)clusterDefs.get(key + ".dir");
                if (clusterDir == null) continue;
                String val = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(val, ", ");
                while (tok.hasMoreTokens()) {
                    String p = tok.nextToken();
                    clusterLocationsHere.put(p, clusterDir);
                }
            }
            clusterLocations.put(nbroot, clusterLocationsHere);
        }
        return (String)clusterLocationsHere.get(path);
    }

    private ModuleList(Map entries, File home, boolean lazyNetBeansOrgList) {
        this.entries = entries;
        this.home = home;
        this.lazyNetBeansOrgList = lazyNetBeansOrgList;
    }

    public String toString() {
        return "ModuleList[" + this.home + "]" + (this.lazyNetBeansOrgList ? "[lazy]" : "") + this.entries.values();
    }

    private static ModuleList merge(ModuleList[] lists, File home) {
        HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
        for (int i = 0; i < lists.length; ++i) {
            lists[i].maybeRescanNetBeansOrgSources();
            Iterator it = lists[i].entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                if (entries.containsKey(cnb)) continue;
                entries.put(cnb, (ModuleEntry)entry.getValue());
            }
        }
        return new ModuleList(entries, home, false);
    }

    private void maybeRescanNetBeansOrgSources() {
        if (this.lazyNetBeansOrgList) {
            this.lazyNetBeansOrgList = false;
            File nbdestdir = new File(this.home, DEST_DIR_IN_NETBEANS_ORG);
            HashMap _entries = new HashMap(this.entries);
            ModuleList.doScanNetBeansOrgSources(_entries, this.home, 3, this.home, nbdestdir, null, false);
            this.entries = _entries;
        }
    }

    public ModuleEntry getEntry(String codeNameBase) {
        ModuleEntry e = (ModuleEntry)this.entries.get(codeNameBase);
        if (e != null) {
            return e;
        }
        this.maybeRescanNetBeansOrgSources();
        return (ModuleEntry)this.entries.get(codeNameBase);
    }

    public Set getAllEntries() {
        this.maybeRescanNetBeansOrgSources();
        return new HashSet(this.entries.values());
    }

    public Set getAllEntriesSoft() {
        return new HashSet(this.entries.values());
    }

    public static LocalizedBundleInfo loadBundleInfo(File projectDir) {
        LocalizedBundleInfo bundleInfo = Util.findLocalizedBundleInfo(projectDir);
        return bundleInfo == null ? LocalizedBundleInfo.EMPTY : bundleInfo;
    }

    static {
        $assertionsDisabled = !ModuleList.class.desiredAssertionStatus();
        DEST_DIR_IN_NETBEANS_ORG = "nbbuild" + File.separatorChar + "netbeans";
        sourceLists = new HashMap();
        binaryLists = new HashMap();
        clusterPropertiesFiles = new HashMap();
        clusterLocations = new HashMap();
        knownEntries = new HashMap();
        EXCLUDED_DIR_NAMES = new HashSet();
        EXCLUDED_DIR_NAMES.add("CVS");
        EXCLUDED_DIR_NAMES.add("nbproject");
        EXCLUDED_DIR_NAMES.add("www");
        EXCLUDED_DIR_NAMES.add("test");
        EXCLUDED_DIR_NAMES.add("build");
        EXCLUDED_DIR_NAMES.add("src");
        EXCLUDED_DIR_NAMES.add("org");
        DIR_SCAN_CACHE = new HashMap();
        MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
        PROJECT_XML = "nbproject" + File.separatorChar + "project.xml";
    }
}

