/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.WLTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WLDeployer
implements ProgressObject,
Runnable {
    private static final String AUTO_DEPLOY_DIR = "/autodeploy";
    private static final int TIMEOUT = 60000;
    Target[] target;
    File file;
    File file2;
    String uri;
    TargetModuleID module_id;
    private Vector listeners = new Vector();
    private DeploymentStatus deploymentStatus;

    public WLDeployer(String serverUri) {
        this.uri = serverUri;
    }

    public ProgressObject deploy(Target[] target, File file, File file2, String host, String port) {
        WLTargetModuleID module_id = new WLTargetModuleID(target[0], file.getName());
        try {
            String server_url = "http://" + host + ":" + port;
            if (file.getName().endsWith(".war")) {
                String[] ctx = WeblogicWebApp.createGraph(file2).getContextRoot();
                if (ctx != null && ctx.length > 0) {
                    module_id.setContextURL(server_url + ctx[0]);
                }
            } else if (file.getName().endsWith(".ear")) {
                JarFileSystem jfs = new JarFileSystem();
                jfs.setJarFile(file);
                FileObject appXml = jfs.getRoot().getFileObject("META-INF/application.xml");
                if (appXml != null) {
                    Application ear = DDProvider.getDefault().getDDRoot(appXml);
                    Module[] modules = ear.getModule();
                    for (int i = 0; i < modules.length; ++i) {
                        WLTargetModuleID mod_id = new WLTargetModuleID(target[0]);
                        if (modules[i].getWeb() != null) {
                            mod_id.setContextURL(server_url + modules[i].getWeb().getContextRoot());
                        }
                        module_id.addChild(mod_id);
                    }
                } else {
                    System.out.println("Cannot file META-INF/application.xml in " + file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        this.target = target;
        this.file = file;
        this.file2 = file2;
        this.module_id = module_id;
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public void run() {
        String deployDir = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("domainRoot") + AUTO_DEPLOY_DIR;
        FileObject foIn = FileUtil.toFileObject((File)this.file);
        FileObject foDestDir = FileUtil.toFileObject((File)new File(deployDir));
        String fileName = this.file.getName();
        File toDeploy = new File(deployDir + File.separator + fileName);
        if (toDeploy.exists()) {
            toDeploy.delete();
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        String msg = NbBundle.getMessage(WLDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
        try {
            TargetModuleID[] ch;
            FileUtil.copyFile((FileObject)foIn, (FileObject)foDestDir, (String)fileName);
            System.out.println("Copying 1 file to: " + foDestDir.getPath());
            String webUrl = this.module_id.getWebURL();
            if (webUrl == null && (ch = this.module_id.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ch.length && (webUrl = ch[i].getWebURL()) == null; ++i) {
                }
            }
            if (webUrl != null) {
                URL url = new URL(webUrl);
                String waitingMsg = NbBundle.getMessage(WLDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
                for (int i = 0; i < 3; ++i) {
                    Thread.sleep(1000L);
                }
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 60000L && !URLWait.waitForUrlReady(url, 1000)) {
                }
            }
        }
        catch (Exception e) {
            this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.module_id};
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Vector targets = null;
        WLDeployer wLDeployer = this;
        synchronized (wLDeployer) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                ProgressListener target = (ProgressListener)targets.elementAt(i);
                target.handleProgressEvent(evt);
            }
        }
    }
}

