/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.PairMap;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider {
    private static final PairMap namesToIos = new PairMap();
    private static final String STDOUT = NbBundle.getMessage((Class)NbIOProvider.class, (String)"LBL_STDOUT");

    public OutputWriter getStdOut() {
        if (Controller.log) {
            Controller.log("NbIOProvider.getStdOut");
        }
        InputOutput stdout = this.getIO(STDOUT, false, null);
        NbWriter out = ((NbIO)stdout).writer();
        Controller.ensureViewInDefault((NbIO)stdout, true);
        if (out != null && out.isClosed()) {
            try {
                out.reset();
                out = (NbWriter)stdout.getOut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                stdout = this.getIO(STDOUT, true, null);
                out = (NbWriter)stdout.getOut();
            }
        } else {
            out = (NbWriter)stdout.getOut();
        }
        return out;
    }

    public InputOutput getIO(String name, boolean newIO) {
        return this.getIO(name, newIO, new Action[0]);
    }

    public InputOutput getIO(String name, Action[] toolbarActions) {
        return this.getIO(name, true, toolbarActions);
    }

    private InputOutput getIO(String name, boolean newIO, Action[] toolbarActions) {
        NbIO result;
        if (Controller.log) {
            Controller.log("GETIO: " + name + " new:" + newIO);
        }
        if ((result = namesToIos.get(name)) == null || newIO) {
            result = new NbIO(name, toolbarActions);
            namesToIos.add(name, result);
            Controller.ensureViewInDefault(result, newIO);
        }
        return result;
    }

    static void dispose(NbIO io) {
        namesToIos.remove(io);
    }

    static void setWeak(boolean value) {
        namesToIos.setWeak(value);
    }
}

