/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.safedelete.BaseRefactoringHelper;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class BaseRefactoring
implements J2EERefactoring {
    private final Collection childRefactorings = new LinkedList();
    protected BaseRefactoringHelper helper;

    public BaseRefactoring(BaseRefactoringHelper helper) {
        this.helper = helper;
    }

    public void addChildRefactoring(AbstractRefactoring refactoring) {
        this.childRefactorings.add(refactoring);
    }

    public Problem preCheck() {
        Problem problem = this.preCheckThis();
        for (AbstractRefactoring refactoring : this.childRefactorings) {
            problem = Utility.addProblemsToEnd(problem, refactoring.preCheck());
        }
        return problem;
    }

    public Problem checkParameters() {
        Problem problem = this.checkParametersThis();
        for (AbstractRefactoring refactoring : this.childRefactorings) {
            problem = Utility.addProblemsToEnd(problem, refactoring.checkParameters());
        }
        return problem;
    }

    public Problem fastCheckParameters() {
        Problem problem = this.fastCheckParametersThis();
        for (AbstractRefactoring refactoring : this.childRefactorings) {
            problem = Utility.addProblemsToEnd(problem, refactoring.fastCheckParameters());
        }
        return problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = this.prepareThis(refactoringElementsBag);
        RefactoringSession session = refactoringElementsBag.getSession();
        for (AbstractRefactoring refactoring : this.childRefactorings) {
            problem = Utility.addProblemsToEnd(problem, refactoring.prepare(session));
        }
        return problem;
    }

    protected Problem preCheckThis() {
        return null;
    }

    protected Problem checkParametersThis() {
        return null;
    }

    protected Problem fastCheckParametersThis() {
        return null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        return null;
    }

    public static class TldHelper
    extends BaseRefactoringHelper {
        private final Taglib taglib;

        public TldHelper(AbstractRefactoring refactoring, FileObject fileObject, Taglib taglib) {
            super(refactoring, fileObject);
            this.taglib = taglib;
        }

        public void writeDD() {
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.getFileObject());
                if (tdo != null) {
                    tdo.write(this.taglib);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Taglib getTaglib() {
            return this.taglib;
        }
    }

    public static class EjbHelper
    extends BaseRefactoringHelper {
        private final EjbJar ejbJar;

        public EjbHelper(AbstractRefactoring refactoring, FileObject fileObject, EjbJar ejbJar) {
            super(refactoring, fileObject);
            this.ejbJar = ejbJar;
        }

        public void writeDD() {
            try {
                this.ejbJar.write(this.getFileObject());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public EjbJar getEjbJar() {
            return this.ejbJar;
        }
    }
}

