/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.whereused;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.whereused.AbstractWhereUsedRefactoringElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceXmlWhereUsedRefactoring {
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) {
            return null;
        }
        JavaClass javaClass = (JavaClass)refObject;
        for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(javaClass)) {
            PUDataObject dataObject = ProviderUtil.getPUDataObject((FileObject)ddFile);
            if (!ProviderUtil.isValid((PUDataObject)dataObject)) {
                Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlWhereUsedRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ddFile.getPath()));
                problem = Utility.addProblemsToEnd(problem, newProblem);
                continue;
            }
            PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits((PUDataObject)dataObject);
            for (int i = 0; i < persistenceUnits.length; ++i) {
                PersistenceUnit unit = persistenceUnits[i];
                for (int j = 0; j < unit.getClass2().length; ++j) {
                    if (!unit.getClass2()[j].equals(javaClass.getName())) continue;
                    PersistenceXmlWhereUsedElement refactoringElem = new PersistenceXmlWhereUsedElement(javaClass.getName(), ddFile);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)refactoringElem);
                }
            }
        }
        return problem;
    }

    private static class PersistenceXmlWhereUsedElement
    extends AbstractWhereUsedRefactoringElement {
        public PersistenceXmlWhereUsedElement(String name, FileObject parentFile) {
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlWhereUsedRefactoring.class, (String)"TXT_PersistenceXmlClassWhereUsed"), args);
        }
    }
}

