/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.ProblemFindersRegistry;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.text.Line;
import org.openide.text.PositionBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemFindingUtils {
    public static Annotation findAnnotation(AnnotableElement element, String annotationName) {
        assert (element != null && annotationName != null);
        return ProblemFindingUtils.findFirstAnnotationFromGivenSet(element, Collections.singleton(annotationName));
    }

    public static Annotation findFirstAnnotationFromGivenSet(AnnotableElement element, Set annotationNames) {
        Annotation[] annots;
        assert (annotationNames != null);
        for (Annotation ann : annots = element.getAnnotations().toArray(new Annotation[0])) {
            AnnotationType atype = ann.getType();
            if (atype != null && annotationNames.contains(atype.getName())) {
                return ann;
            }
            if (atype != null) continue;
            JEEVerificationAnnotationProvider.tmpDbg("findFirstAnnotationFromGivenSet(): unresolved annotation type: " + ann.getTypeName().getName());
        }
        return null;
    }

    public static Line.Part getLinePartForElement(Line.Set lineSet, BaseDocument baseDoc, Element elem) {
        JavaMetamodel jmm = JavaMetamodel.getManager();
        PositionBounds pos = jmm.getElementPosition(elem);
        if (elem instanceof JavaClass || elem instanceof Field || elem instanceof Method) {
            pos = jmm.getElementPartPosition(elem, (ElementPartKind)ElementPartKindEnum.NAME, 0);
        }
        Line.Part ret = null;
        try {
            Line startLine = lineSet.getCurrent(pos.getBegin().getLine());
            int startColumn = pos.getBegin().getColumn();
            int endColumn = pos.getEnd().getColumn();
            if (lineSet.getCurrent(pos.getEnd().getLine()).getLineNumber() > startLine.getLineNumber()) {
                endColumn = startLine.getText().length();
            }
            ret = startLine.createPart(startColumn, endColumn - startColumn);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return ret;
    }

    public static Line.Part getLinePartForModifier(Line.Set lineSet, BaseDocument baseDoc, Element elem, int modifier) {
        BaseImageTokenID searchedTokenId;
        switch (modifier) {
            case 1: {
                searchedTokenId = JavaTokenContext.PUBLIC;
                break;
            }
            case 4: {
                searchedTokenId = JavaTokenContext.PROTECTED;
                break;
            }
            case 2: {
                searchedTokenId = JavaTokenContext.PRIVATE;
                break;
            }
            case 8: {
                searchedTokenId = JavaTokenContext.STATIC;
                break;
            }
            case 16: {
                searchedTokenId = JavaTokenContext.FINAL;
                break;
            }
            default: {
                searchedTokenId = null;
            }
        }
        if (searchedTokenId == null) {
            throw new IllegalArgumentException("Unsupported modifier constant");
        }
        int headerStart = elem.getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        int headerEnd = elem.getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        try {
            for (TokenItem tokenItm = ((JavaSyntaxSupport)baseDoc.getSyntaxSupport().get(JavaSyntaxSupport.class)).getTokenChain(headerStart, headerEnd); tokenItm != null && tokenItm.getOffset() <= headerEnd; tokenItm = tokenItm.getNext()) {
                if (searchedTokenId != tokenItm.getTokenID()) continue;
                int startOffset = tokenItm.getOffset();
                int endOffset = startOffset + tokenItm.getImage().length();
                int startLineNumber = Utilities.getLineOffset((BaseDocument)baseDoc, (int)startOffset);
                int startLineOffset = Utilities.getRowStartFromLineOffset((BaseDocument)baseDoc, (int)startLineNumber);
                Line startLine = lineSet.getCurrent(startLineNumber);
                Line.Part linePart = startLine.createPart(startOffset - startLineOffset, endOffset - startOffset);
                return linePart;
            }
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        return null;
    }

    public static boolean isAssignableFrom(String thisClass, JavaClass from) {
        HashSet<String> visited = new HashSet<String>();
        return ProblemFindingUtils.isAssignableFrom0(thisClass, from, visited);
    }

    private static boolean isAssignableFrom0(String thisClass, JavaClass from, Set<String> visited) {
        if (from instanceof ParameterizedType) {
            from = ((ParameterizedType)ParameterizedType.class.cast(from)).getDefinition();
        }
        if (!visited.add(from.getName())) {
            return false;
        }
        if (thisClass.equals(from.getName())) {
            return true;
        }
        for (JavaClass i : from.getInterfaces()) {
            if (!ProblemFindingUtils.isAssignableFrom0(thisClass, i, visited)) continue;
            return true;
        }
        JavaClass superClass = from.getSuperClass();
        if (superClass != null) {
            return ProblemFindingUtils.isAssignableFrom0(thisClass, from.getSuperClass(), visited);
        }
        return false;
    }

    public static String getPrimaryTableName(JavaClass entityClass) {
        Annotation annEntity;
        String nameDefinedByEntityAnn;
        String tableName = entityClass.getSimpleName();
        Annotation annTable = ProblemFindingUtils.findAnnotation((AnnotableElement)entityClass, "javax.persistence.Table");
        String nameDefinedByTableAnn = ProblemFindingUtils.getNameAttribute(annTable);
        tableName = nameDefinedByTableAnn != null ? nameDefinedByTableAnn : ((nameDefinedByEntityAnn = ProblemFindingUtils.getNameAttribute(annEntity = ProblemFindingUtils.findAnnotation((AnnotableElement)entityClass, "javax.persistence.Entity"))) == null ? tableName : nameDefinedByEntityAnn);
        tableName = nameDefinedByTableAnn == null ? tableName : nameDefinedByTableAnn;
        return tableName;
    }

    public static String getColumnName(Field field) {
        String nameDefinedByColumnAttr;
        String columnName = field.getName();
        Annotation annColumn = ProblemFindingUtils.findAnnotation((AnnotableElement)field, "javax.persistence.Column");
        if (annColumn == null) {
            annColumn = ProblemFindingUtils.findAnnotation((AnnotableElement)field, "javax.persistence.JoinColumn");
        }
        if (annColumn != null && (nameDefinedByColumnAttr = ProblemFindingUtils.getNameAttribute(annColumn)) != null) {
            columnName = nameDefinedByColumnAttr;
        }
        return columnName;
    }

    public static String getColumnName(Method persistentFieldAccessor) {
        String nameDefinedByColumnAttr;
        String columnName = persistentFieldAccessor.getName().substring("get".length());
        Annotation annColumn = ProblemFindingUtils.findAnnotation((AnnotableElement)persistentFieldAccessor, "javax.persistence.Column");
        if (annColumn == null) {
            annColumn = ProblemFindingUtils.findAnnotation((AnnotableElement)persistentFieldAccessor, "javax.persistence.JoinColumn");
        }
        if (annColumn != null && (nameDefinedByColumnAttr = ProblemFindingUtils.getNameAttribute(annColumn)) != null) {
            columnName = nameDefinedByColumnAttr;
        }
        return columnName;
    }

    private static String getNameAttribute(Annotation ann) {
        if (ann != null) {
            for (AttributeValue av : ann.getAttributeValues()) {
                if (!"name".equals(av.getName()) || !(av.getValue() instanceof StringLiteral)) continue;
                return ((StringLiteral)av.getValue()).getValue();
            }
        }
        return null;
    }

    public static boolean isSQLAndNotPersistenceQLKeyword(String text) {
        return SQLKeywords.isSQL99Keyword((String)text) && !JavaPersistenceQLKeywords.isKeyword((String)text);
    }

    static {
        ProblemFindersRegistry.intit();
    }
}

