/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ws.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

public class AttributeNotAllowedOnInterfaces
extends ProblemFinder {
    private static final Collection attrsNotAllowedOnInterfaces = new TreeSet<String>(Arrays.asList("serviceName", "endpointInterface"));

    public void parseDocument() {
        JavaClass javaClass = this.getMainJavaClass();
        if (!javaClass.isInterface()) {
            return;
        }
        Annotation wsAnnotation = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.jws.WebService");
        if (wsAnnotation != null) {
            for (AttributeValue attValue : wsAnnotation.getAttributeValues()) {
                String attrName = attValue.getName();
                if (attrName == null || !attrsNotAllowedOnInterfaces.contains(attrName)) continue;
                JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
                problemContext.setElement((Element)attValue);
                JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_attr_not_allowed_on_intefaces", NbBundle.getMessage(this.getClass(), (String)"MSG_AttributeNotAllowedOnIntefaces", (Object)attrName), problemContext);
                this.attachProblemMarkToElement(problemMark, (Element)attValue);
                this.addProblemMark(problemMark);
            }
        }
    }
}

