/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private EditableProperties cachedProperties;
    private Element cachedElement;
    private static final String TAG_MINIMUM_ANT_VERSION = "minimum-ant-version";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private ProjectUpdateListener projectUpdateListener = null;

    UpdateHelper(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg, GeneratedFilesHelper genFileHelper, Notifier notifier) {
        assert (project != null && helper != null && cfg != null && genFileHelper != null && notifier != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
        this.genFileHelper = genFileHelper;
        this.notifier = notifier;
    }

    public EditableProperties getProperties(final String path) {
        return (EditableProperties)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return UpdateHelper.this.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(props);
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate(null);
        return true;
    }

    public synchronized boolean isCurrent() {
        if (this.isCurrent == null) {
            this.isCurrent = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) == null && this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCurrent;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.notifier.canUpdate();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate(EditableProperties props) throws IOException {
        UpdateHelper refHelper;
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        if (this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) != null) {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
        } else {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
        }
        boolean putProps = false;
        if (props == null) {
            props = this.getProperties("nbproject/project.properties");
            putProps = true;
        }
        if (props != null) {
            props.put((Object)"test.src.dir", (Object)"test");
            props.put((Object)"build.test.classes.dir", (Object)"${build.dir}/test/classes");
            props.put((Object)"build.test.results.dir", (Object)"${build.dir}/test/results");
            props.put((Object)"conf.dir", (Object)"${source.root}/conf");
            props.put((Object)"jspcompilation.classpath", (Object)"${jspc.classpath}:${javac.classpath}");
            props.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}"});
            props.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
            props.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
            props.put((Object)"build.ear.classes.dir", (Object)"${build.ear.web.dir}/WEB-INF/classes");
            props.put((Object)"build.ear.web.dir", (Object)"${build.dir}/ear-module");
            props.put((Object)"war.ear.name", (Object)props.getProperty("war.name"));
            props.put((Object)"dist.ear.war", (Object)"${dist.dir}/${war.ear.name}");
            if (props.getProperty("lib.dir") == null) {
                props.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
            }
        }
        if (props != null) {
            refHelper = new ReferenceHelper(this.helper, this.cfg, this.helper.getStandardPropertyEvaluator());
            ClassPathSupport cs = new ClassPathSupport(this.helper.getStandardPropertyEvaluator(), (ReferenceHelper)refHelper, this.helper, WebProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
            Iterator items = cs.itemsIterator((String)props.get((Object)"javac.classpath"), "web-module-libraries");
            ArrayList<ClassPathSupport.Item> cpItems = new ArrayList<ClassPathSupport.Item>();
            while (items.hasNext()) {
                ClassPathSupport.Item cpti = (ClassPathSupport.Item)items.next();
                String propertyName = cpti.getReference();
                if (propertyName == null) continue;
                String libname = propertyName.substring("${libs.".length());
                if (libname != null && libname.indexOf(".classpath}") != -1) {
                    libname = libname.substring(0, libname.indexOf(".classpath}"));
                }
                if ("servlet24".equals(libname) || "jsp20".equals(libname)) continue;
                cpItems.add(cpti);
            }
            String[] javac_cp = cs.encodeToStrings(cpItems.iterator(), "web-module-libraries");
            props.setProperty("javac.classpath", javac_cp);
        }
        if (putProps) {
            this.helper.putProperties("nbproject/project.properties", props);
        }
        ProjectManager.getDefault().saveProject(this.project);
        refHelper = this;
        synchronized (refHelper) {
            this.isCurrent = Boolean.TRUE;
        }
        if (this.projectUpdateListener != null) {
            this.projectUpdateListener.projectUpdated();
        }
        try {
            FileObject prjFO = this.project.getProjectDirectory();
            FileObject confDirFO = prjFO.createFolder("conf");
            FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/MANIFEST.MF"), (FileObject)confDirFO, (String)"MANIFEST");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String ns;
            int version = 1;
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
            if (oldRoot == null) {
                version = 2;
                oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
            }
            String string = ns = version == 1 ? "http://www.netbeans.org/ns/web-project/1" : "http://www.netbeans.org/ns/web-project/2";
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "data");
                UpdateHelper.copyDocument(doc, oldRoot, newRoot);
                if (version == 1) {
                    Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    root.setAttribute("id", "src.dir");
                    sourceRoots.appendChild(root);
                    newRoot.appendChild(sourceRoots);
                    Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    root.setAttribute("id", "test.src.dir");
                    testRoots.appendChild(root);
                    newRoot.appendChild(testRoots);
                }
                if (version == 1 || version == 2) {
                    NodeList libList = newRoot.getElementsByTagNameNS(ns, TAG_LIBRARY);
                    for (int i = 0; i < libList.getLength(); ++i) {
                        if (libList.item(i).getNodeType() != 1) continue;
                        Element library = (Element)libList.item(i);
                        Node webFile = library.getElementsByTagNameNS(ns, TAG_FILE).item(0);
                        String webFileText = UpdateHelper.findText(webFile);
                        if (!(webFileText = webFileText.substring(2, webFileText.length() - 1)).startsWith("lib.")) continue;
                        String libName = webFileText.substring(6, webFileText.indexOf(".classpath"));
                        List roots = LibraryManager.getDefault().getLibrary(libName).getContent("classpath");
                        ArrayList<FileObject> files = new ArrayList<FileObject>();
                        ArrayList<FileObject> dirs = new ArrayList<FileObject>();
                        for (URL rootUrl : roots) {
                            FileObject root = URLMapper.findFileObject((URL)rootUrl);
                            if ("jar".equals(rootUrl.getProtocol())) {
                                root = FileUtil.getArchiveFile((FileObject)root);
                            }
                            if (root == null) continue;
                            if (root.isData()) {
                                files.add(root);
                                continue;
                            }
                            dirs.add(root);
                        }
                        if (files.size() > 0) {
                            library.setAttribute(ATTR_FILES, "" + files.size());
                        }
                        if (dirs.size() <= 0) continue;
                        library.setAttribute(ATTR_DIRS, "" + dirs.size());
                    }
                }
                this.cachedElement = UpdateHelper.updateMinAntVersion(newRoot, doc);
            }
        }
        return this.cachedElement;
    }

    private synchronized EditableProperties getUpdatedProjectProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = this.helper.getProperties("nbproject/project.properties");
            if (this.cachedProperties.get((Object)"javadoc.additionalparam") == null) {
                this.cachedProperties.put((Object)"javadoc.additionalparam", (Object)"");
            }
        }
        return this.cachedProperties;
    }

    private static void copyDocument(Document doc, Element from, Element to) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            Node newNode = null;
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", oldElement.getTagName());
                    NamedNodeMap m = oldElement.getAttributes();
                    Element newElement = (Element)newNode;
                    for (int index = 0; index < m.getLength(); ++index) {
                        Node attr = m.item(index);
                        newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                    UpdateHelper.copyDocument(doc, oldElement, (Element)newNode);
                    break;
                }
                case 3: {
                    Text oldText = (Text)node;
                    newNode = doc.createTextNode(oldText.getData());
                    break;
                }
                case 8: {
                    Comment oldComment = (Comment)node;
                    newNode = doc.createComment(oldComment.getData());
                }
            }
            if (newNode == null) continue;
            to.appendChild(newNode);
        }
    }

    private static Element updateMinAntVersion(Element root, Document doc) {
        Element me;
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", TAG_MINIMUM_ANT_VERSION);
        if (list.getLength() == 1 && (list = (me = (Element)list.item(0)).getChildNodes()).getLength() == 1) {
            me.replaceChild(doc.createTextNode("1.6"), list.item(0));
            return root;
        }
        assert (false) : "Invalid project file";
        return root;
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            public boolean canUpdate() {
                JButton updateOption = new JButton(NbBundle.getMessage(UpdateHelper.class, (String)"CTL_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
            }
        };
    }

    private static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public void setProjectUpdateListener(ProjectUpdateListener l) {
        this.projectUpdateListener = l;
    }

    public static interface ProjectUpdateListener {
        public void projectUpdated();
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

