/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.ClassPathSupport;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceClassPathProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;

public class WebPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
PersistenceClassPathProvider,
PropertyChangeListener {
    private final WebProject project;
    private final PropertyEvaluator evaluator;
    private final PersistenceScopeImplementation persistenceScopeImpl = new PersistenceScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.persistenceScopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private ClassPath projectSourcesClassPath;

    public WebPersistenceProvider(WebProject project, PropertyEvaluator evaluator) {
        this.project = project;
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.locationChanged();
    }

    public FileObject getLocation() {
        return this.project.getWebModule().getConfDir();
    }

    public FileObject createLocation() throws IOException {
        return this.project.getWebModule().getConfDir();
    }

    public PersistenceScope findPersistenceScope(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            WebPersistenceProvider provider = (WebPersistenceProvider)project.getLookup().lookup(WebPersistenceProvider.class);
            return provider.getPersistenceScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    public ClassPath getClassPath() {
        return this.getProjectSourcesClassPath();
    }

    private PersistenceScope getPersistenceScope() {
        FileObject persistenceXml = this.persistenceScope.getPersistenceXml();
        if (persistenceXml != null && persistenceXml.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        WebPersistenceProvider webPersistenceProvider = this;
        synchronized (webPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
                this.projectSourcesClassPath = ClassPathSupport.createWeakProxyClassPath((ClassPath[])new ClassPath[]{cpProvider.getProjectSourcesClassPath("classpath/source"), cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if (propName == null || propName.equals("conf.dir")) {
            this.locationChanged();
        }
    }

    private void locationChanged() {
        File confDirFile = this.project.getWebModule().getConfDirAsFile();
        if (confDirFile != null) {
            File persistenceXmlFile = new File(confDirFile, "persistence.xml");
            this.scopesHelper.changePersistenceScope(this.persistenceScope, persistenceXmlFile);
        } else {
            this.scopesHelper.changePersistenceScope(null, null);
        }
    }

    private final class PersistenceScopeImpl
    implements PersistenceScopeImplementation {
        private PersistenceScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject location = WebPersistenceProvider.this.getLocation();
            if (location == null) {
                return null;
            }
            return location.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return WebPersistenceProvider.this.getProjectSourcesClassPath();
        }
    }
}

