/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerCompile;
import org.netbeans.modules.web.project.ui.customizer.CustomizerFrameworks;
import org.netbeans.modules.web.project.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.web.project.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.web.project.ui.customizer.CustomizerRun;
import org.netbeans.modules.web.project.ui.customizer.CustomizerSources;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSClientHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSServiceHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWar;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private final Project project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private ProjectCustomizer.Category[] categories;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static Map project2Dialog = new HashMap();
    private static final String BUILD_CATEGORY = "BuildCategory";
    private static final String RUN_CATEGORY = "RunCategory";
    private static final String SOURCES = "Sources";
    private static final String LIBRARIES = "Libraries";
    private static final String FRAMEWORKS = "Frameworks";
    private static final String BUILD = "Build";
    private static final String BUILD_TESTS = "BuildTests";
    private static final String WAR = "War";
    private static final String JAVADOC = "Javadoc";
    private static final String RUN = "Run";
    private static final String RUN_TESTS = "RunTests";
    private static final String WEBSERVICE_CATEGORY = "WebServiceCategory";
    private static final String WEBSERVICES = "WebServices";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";

    public CustomizerProviderImpl(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        Dialog dialog = (Dialog)project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.show();
            return;
        }
        WebProjectProperties uiProperties = new WebProjectProperties((WebProject)this.project, this.updateHelper, this.evaluator, this.refHelper);
        this.init(uiProperties);
        OptionListener listener = new OptionListener(this.project, uiProperties);
        if (preselectedCategory != null && preselectedSubCategory != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                JComponent component;
                if (!preselectedCategory.equals(this.categories[i].getName()) || !((component = this.panelProvider.create(this.categories[i])) instanceof SubCategoryProvider)) continue;
                ((SubCategoryProvider)((Object)component)).showSubCategory(preselectedSubCategory);
            }
        }
        dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, (String)preselectedCategory, (ActionListener)listener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.show();
    }

    private void init(WebProjectProperties uiProperties) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category sources = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, null);
        ProjectCustomizer.Category frameworks = ProjectCustomizer.Category.create((String)FRAMEWORKS, (String)bundle.getString("LBL_Config_Frameworks"), null, null);
        ProjectCustomizer.Category libraries = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, null);
        ProjectCustomizer.Category build = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, null);
        ProjectCustomizer.Category war = ProjectCustomizer.Category.create((String)WAR, (String)bundle.getString("LBL_Config_War"), null, null);
        ProjectCustomizer.Category javadoc = ProjectCustomizer.Category.create((String)JAVADOC, (String)bundle.getString("LBL_Config_Javadoc"), null, null);
        ProjectCustomizer.Category run = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, null);
        ProjectCustomizer.Category runTests = ProjectCustomizer.Category.create((String)RUN_TESTS, (String)bundle.getString("LBL_Config_Test"), null, null);
        ProjectCustomizer.Category buildCategory = ProjectCustomizer.Category.create((String)BUILD_CATEGORY, (String)bundle.getString("LBL_Config_BuildCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{build, war, javadoc});
        ProjectCustomizer.Category webServices = null;
        ProjectCustomizer.Category services = null;
        ProjectCustomizer.Category clients = null;
        List servicesSettings = null;
        List serviceClientsSettings = null;
        ProjectWebModule wm = (ProjectWebModule)uiProperties.getProject().getLookup().lookup(ProjectWebModule.class);
        FileObject docBase = wm.getDocumentBase();
        if (docBase != null) {
            WebServicesClientSupport clientSupport;
            WebServicesSupport servicesSupport = WebServicesSupport.getWebServicesSupport((FileObject)docBase);
            if (servicesSupport != null) {
                servicesSettings = servicesSupport.getServices();
            }
            if ((clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)docBase)) != null) {
                serviceClientsSettings = clientSupport.getServiceClients();
            }
        }
        if (servicesSettings != null && servicesSettings.size() > 0 || serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
            services = ProjectCustomizer.Category.create((String)WEBSERVICES, (String)bundle.getString("LBL_Config_WebServices"), null, null);
            clients = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)bundle.getString("LBL_Config_WebServiceClients"), null, null);
            webServices = ProjectCustomizer.Category.create((String)WEBSERVICE_CATEGORY, (String)bundle.getString("LBL_Config_WebServicesRoot"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{services, clients});
            this.categories = new ProjectCustomizer.Category[]{sources, frameworks, libraries, buildCategory, run, webServices};
        } else {
            this.categories = new ProjectCustomizer.Category[]{sources, frameworks, libraries, buildCategory, run};
        }
        HashMap<ProjectCustomizer.Category, JPanel> panels = new HashMap<ProjectCustomizer.Category, JPanel>();
        panels.put(sources, new CustomizerSources(uiProperties));
        panels.put(frameworks, new CustomizerFrameworks(uiProperties));
        panels.put(libraries, new CustomizerLibraries(uiProperties));
        panels.put(build, new CustomizerCompile(uiProperties));
        panels.put(war, new CustomizerWar(uiProperties));
        panels.put(javadoc, new CustomizerJavadoc(uiProperties));
        panels.put(run, new CustomizerRun(uiProperties));
        if (servicesSettings != null && servicesSettings.size() > 0) {
            panels.put(services, new CustomizerWSServiceHost(uiProperties, servicesSettings));
        } else {
            panels.put(services, new NoWebServicesPanel());
        }
        if (serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
            panels.put(clients, new CustomizerWSClientHost(uiProperties, serviceClientsSettings));
        } else {
            panels.put(clients, new NoWebServiceClientsPanel());
        }
        this.panelProvider = new PanelProvider(panels);
    }

    private class NoWebServiceClientsPanel
    extends LabelPanelWithHelp {
        NoWebServiceClientsPanel() {
            super(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_CustomizeWsServiceClientHost_NoWebServiceClients"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(CustomizerWSClientHost.class.getName() + "Disabled");
        }
    }

    private class NoWebServicesPanel
    extends LabelPanelWithHelp {
        NoWebServicesPanel() {
            super(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_CustomizeWsServiceHost_NoWebServices"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(CustomizerWSServiceHost.class.getName() + "Disabled");
        }
    }

    private abstract class LabelPanelWithHelp
    extends LabelPanel
    implements HelpCtx.Provider {
        LabelPanelWithHelp(String text) {
            super(text);
        }
    }

    private class LabelPanel
    extends JPanel {
        private JLabel label;

        LabelPanel(String text) {
            this.setLayout(new GridBagLayout());
            this.label = new JLabel(text);
            this.label.setVerticalAlignment(0);
            this.label.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.label, gridBagConstraints);
        }
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private WebProjectProperties uiProperties;

        OptionListener(Project project, WebProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }
    }

    private static class PanelProvider
    implements ProjectCustomizer.CategoryComponentProvider {
        private JPanel EMPTY_PANEL = new JPanel();
        private Map panels;

        PanelProvider(Map panels) {
            this.panels = panels;
        }

        public JComponent create(ProjectCustomizer.Category category) {
            JComponent panel = (JComponent)this.panels.get(category);
            return panel == null ? this.EMPTY_PANEL : panel;
        }
    }
}

