/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.project.ui.customizer.WebSourceRootsUi;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements HelpCtx.Provider {
    private File projectFld;
    private JButton addSourceRoot;
    private JButton addTestRoot;
    private JButton downSourceRoot;
    private JButton downTestRoot;
    private JButton jButtonBrowse;
    private JComboBox jComboBoxSourceLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelSourceLevel;
    private JLabel jLabelWebPages;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextFieldWebPages;
    private JTextField projectLocation;
    private JButton removeSourceRoot;
    private JButton removeTestRoot;
    private JTable sourceRoots;
    private JPanel sourceRootsPanel;
    private JTable testRoots;
    private JPanel testRootsPanel;
    private JButton upSourceRoot;
    private JButton upTestRoot;

    public CustomizerSources(WebProjectProperties uiProperties) {
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.sourceRoots.getBackground());
        this.jScrollPane2.getViewport().setBackground(this.testRoots.getBackground());
        this.sourceRoots.setModel(uiProperties.SOURCE_ROOTS_MODEL);
        this.testRoots.setModel(uiProperties.TEST_ROOTS_MODEL);
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.testRoots.getTableHeader().setReorderingAllowed(false);
        FileObject projectFolder = uiProperties.getProject().getProjectDirectory();
        File pf = FileUtil.toFile((FileObject)projectFolder);
        this.projectLocation.setText(pf == null ? "" : pf.getPath());
        this.projectFld = pf;
        this.jTextFieldWebPages.setDocument(uiProperties.WEB_DOCBASE_DIR_MODEL);
        WebSourceRootsUi.EditMediator emSR = WebSourceRootsUi.registerEditMediator(uiProperties.getProject(), uiProperties.getProject().getSourceRoots(), this.sourceRoots, this.addSourceRoot, this.removeSourceRoot, this.upSourceRoot, this.downSourceRoot);
        WebSourceRootsUi.EditMediator emTSR = WebSourceRootsUi.registerEditMediator(uiProperties.getProject(), uiProperties.getProject().getTestSourceRoots(), this.testRoots, this.addTestRoot, this.removeTestRoot, this.upTestRoot, this.downTestRoot);
        emSR.setRelatedEditMediator(emTSR);
        emTSR.setRelatedEditMediator(emSR);
        this.jComboBoxSourceLevel.setModel(uiProperties.JAVAC_SOURCE_MODEL);
        uiProperties.JAVAC_SOURCE_MODEL.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }

            public void intervalRemoved(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }

            public void contentsChanged(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }
        });
        this.enableSourceLevel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private void enableSourceLevel() {
        this.jComboBoxSourceLevel.setEnabled(this.jComboBoxSourceLevel.getItemCount() > 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectLocation = new JTextField();
        this.jLabelWebPages = new JLabel();
        this.jTextFieldWebPages = new JTextField();
        this.jButtonBrowse = new JButton();
        this.sourceRootsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sourceRoots = new JTable();
        this.addSourceRoot = new JButton();
        this.removeSourceRoot = new JButton();
        this.upSourceRoot = new JButton();
        this.downSourceRoot = new JButton();
        this.testRootsPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.testRoots = new JTable();
        this.addTestRoot = new JButton();
        this.removeTestRoot = new JButton();
        this.upTestRoot = new JButton();
        this.downTestRoot = new JButton();
        this.jLabelSourceLevel = new JLabel();
        this.jComboBoxSourceLevel = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_ProjectFolder").charAt(0));
        this.jLabel1.setLabelFor(this.projectLocation);
        this.jLabel1.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_ProjectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.projectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_projectLocation"));
        this.jLabelWebPages.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_WebPages").charAt(0));
        this.jLabelWebPages.setLabelFor(this.jTextFieldWebPages);
        this.jLabelWebPages.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_WebPagesFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabelWebPages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextFieldWebPages, gridBagConstraints);
        this.jTextFieldWebPages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webPagesFolder"));
        this.jButtonBrowse.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_WebPagesBrowse").charAt(0));
        this.jButtonBrowse.setText(NbBundle.getMessage(CustomizerSources.class, (String)"LBL_Browse_JButton"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jButtonBrowse, gridBagConstraints);
        this.jButtonBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webPagesFolderBrowse"));
        this.sourceRootsPanel.setLayout(new GridBagLayout());
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_SourceRoots").charAt(0));
        this.jLabel2.setLabelFor(this.sourceRoots);
        this.jLabel2.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_SourceRoots"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.sourceRootsPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_sourceRoots"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.sourceRootsPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_AddSourceRoot").charAt(0));
        this.addSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_AddSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.sourceRootsPanel.add((Component)this.addSourceRoot, gridBagConstraints);
        this.addSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_addSourceRoot"));
        this.removeSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_RemoveSourceRoot").charAt(0));
        this.removeSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_RemoveSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.removeSourceRoot, gridBagConstraints);
        this.removeSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_removeSourceRoot"));
        this.upSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_UpSourceRoot").charAt(0));
        this.upSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_UpSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.upSourceRoot, gridBagConstraints);
        this.upSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_upSourceRoot"));
        this.downSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_DownSourceRoot").charAt(0));
        this.downSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_DownSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.downSourceRoot, gridBagConstraints);
        this.downSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_downSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourceRootsPanel, gridBagConstraints);
        this.testRootsPanel.setLayout(new GridBagLayout());
        this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_TestRoots").charAt(0));
        this.jLabel3.setLabelFor(this.testRoots);
        this.jLabel3.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_TestRoots"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.testRootsPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.testRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.testRoots);
        this.testRoots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_testRoots"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.testRootsPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.addTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_AddTestRoot").charAt(0));
        this.addTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_AddTestRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.testRootsPanel.add((Component)this.addTestRoot, gridBagConstraints);
        this.addTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_addTestRoot"));
        this.removeTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_RemoveTestRoot").charAt(0));
        this.removeTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_RemoveTestRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.testRootsPanel.add((Component)this.removeTestRoot, gridBagConstraints);
        this.removeTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_removeTestRoot"));
        this.upTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_UpTestRoot").charAt(0));
        this.upTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_UpTestRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.testRootsPanel.add((Component)this.upTestRoot, gridBagConstraints);
        this.upTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_upTestRoot"));
        this.downTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_DownTestRoot").charAt(0));
        this.downTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_DownTestRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.testRootsPanel.add((Component)this.downTestRoot, gridBagConstraints);
        this.downTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_downTestRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testRootsPanel, gridBagConstraints);
        this.jLabelSourceLevel.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_SourceLevel").charAt(0));
        this.jLabelSourceLevel.setLabelFor(this.jComboBoxSourceLevel);
        this.jLabelSourceLevel.setText(NbBundle.getMessage(CustomizerSources.class, (String)"TXT_SourceLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.jLabelSourceLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jComboBoxSourceLevel, gridBagConstraints);
        this.jComboBoxSourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"AN_SourceLevel"));
        this.jComboBoxSourceLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_SourceLevel"));
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        File webPages;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        File fileName = new File(this.jTextFieldWebPages.getText());
        File file = webPages = fileName.isAbsolute() ? fileName : new File(this.projectFld, fileName.getPath());
        if (webPages.exists()) {
            chooser.setSelectedFile(webPages);
        } else {
            chooser.setSelectedFile(this.projectFld);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File selected = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            String newWebPages = CollocationQuery.areCollocated((File)this.projectFld, (File)selected) ? PropertyUtils.relativizeFile((File)this.projectFld, (File)selected) : selected.getPath();
            this.jTextFieldWebPages.setText(newWebPages);
        }
    }
}

