/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.wizards.FileType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

abstract class Evaluator {
    private FileType fileType = null;
    private static final boolean debug = false;

    Evaluator(FileType fileType) {
        this.fileType = fileType;
    }

    abstract boolean isValid();

    abstract String getTargetPath();

    abstract String getErrorMessage();

    abstract Iterator getPathItems();

    abstract void setInitialFolder(DataFolder var1, Project var2);

    FileType getFileType() {
        return this.fileType;
    }

    String getTargetPath(Iterator pathItems) {
        StringBuffer buffer = new StringBuffer();
        while (pathItems.hasNext()) {
            buffer.append((String)pathItems.next());
            if (!pathItems.hasNext()) continue;
            buffer.append(File.separator);
        }
        buffer.append(".");
        buffer.append(this.fileType.getSuffix());
        return buffer.toString();
    }

    void checkFile(Iterator pathItems, FileObject root) throws IOException {
        FileObject fo = root;
        while (pathItems.hasNext()) {
            String pathItem = (String)pathItems.next();
            if (pathItems.hasNext()) {
                try {
                    fo = fo.getFileObject(pathItem, null);
                }
                catch (IllegalArgumentException iaex) {
                    throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)pathItem));
                }
                if (fo == null) {
                    return;
                }
                if (fo.isFolder()) continue;
                throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)pathItem));
            }
            try {
                fo = fo.getFileObject(pathItem, this.fileType.getSuffix());
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)pathItem));
            }
            if (fo == null) {
                return;
            }
            if (!fo.isData()) continue;
            throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_file_exists", (Object)pathItem));
        }
    }

    private static void log(String s) {
        System.out.println("Evaluator" + s);
    }
}

