/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.spi.strings.WeightedStringPainter;
import org.netbeans.modules.java.navigation.strings.Markup;
import org.netbeans.modules.java.navigation.strings.WeightedStringPainterImpl;

public final class WeightedStringImpl
extends WeightedString {
    private static final WeightedStringPainter painter = new WeightedStringPainterImpl();
    private Object[] chars = new Object[15];
    private float[] importances = new float[15];
    private int count = -1;
    int length = 0;
    private float minImportance = 10.0f;
    private float maxImportance = 0.0f;
    private final Markup markup = new Markup();

    public char[] getCharsSegment(int seg) {
        return (char[])this.chars[seg];
    }

    public int allMarkupTypes() {
        return this.markup.allMarkupTypes();
    }

    public void startMarkupRun(int bitmask) {
        this.markup.start(this.count + 1, bitmask);
    }

    public void endMarkupRun() {
        this.markup.end(this.count + 1);
    }

    public int getMarkupFor(int seg) {
        return this.markup.get(seg);
    }

    public float minImportance() {
        return (double)this.minImportance == 2.0 ? 0.0f : this.minImportance;
    }

    public float maxImportance() {
        return this.maxImportance;
    }

    public WeightedStringPainter getPainter() {
        return painter;
    }

    public void append(String s, float importance) {
        this.append(s.toCharArray(), importance);
    }

    public void append(char[] str, float importance) {
        if (str.length == 0) {
            return;
        }
        if (importance < 0.0f || importance > 1.0f) {
            throw new IllegalArgumentException("Importance must be between 0.0f and 1.0f but received " + importance);
        }
        ++this.count;
        this.ensureCapacity(this.count + 1);
        this.chars[this.count] = str;
        this.importances[this.count] = importance;
        this.length += str.length;
        this.minImportance = Math.min(this.minImportance, importance);
        this.maxImportance = Math.max(this.maxImportance, importance);
    }

    public void clear() {
        this.count = -1;
        this.length = 0;
        this.minImportance = 2.0f;
        this.maxImportance = 0.0f;
        this.markup.clear();
    }

    private void ensureCapacity(int val) {
        if (this.chars.length < val + 1) {
            Object[] oldChars = this.chars;
            this.chars = new Object[val * 2];
            System.arraycopy(oldChars, 0, this.chars, 0, oldChars.length);
            float[] oldImportances = this.importances;
            this.importances = new float[val * 2];
            System.arraycopy(oldImportances, 0, this.importances, 0, oldImportances.length);
        }
    }

    int getCount() {
        return this.count;
    }

    float getImportance(int seg) {
        return this.importances[seg];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.length + 1);
        for (int i = 0; i <= this.count; ++i) {
            sb.append((char[])this.chars[i]);
        }
        return sb.toString();
    }
}

