/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorEventAdapter;
import oracle.toplink.essentials.descriptors.DescriptorEventManager;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedMethodInvoker;

public class MetadataEntityListener
extends DescriptorEventAdapter {
    public static final String POST_BUILD = "postBuild";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_REFRESH = "postRefresh";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    private Object m_listener;
    private Class m_entityClass;
    private Hashtable<String, Method> m_methods = new Hashtable();
    private Hashtable<Integer, Boolean> m_overriddenEvents = new Hashtable();
    private static Hashtable<Integer, String> m_eventStrings;

    protected MetadataEntityListener() {
        if (m_eventStrings == null) {
            m_eventStrings = new Hashtable();
            m_eventStrings.put(new Integer(8), POST_BUILD);
            m_eventStrings.put(new Integer(10), POST_CLONE);
            m_eventStrings.put(new Integer(3), POST_DELETE);
            m_eventStrings.put(new Integer(5), POST_INSERT);
            m_eventStrings.put(new Integer(9), POST_REFRESH);
            m_eventStrings.put(new Integer(7), POST_UPDATE);
            m_eventStrings.put(new Integer(15), PRE_PERSIST);
            m_eventStrings.put(new Integer(16), PRE_REMOVE);
            m_eventStrings.put(new Integer(17), PRE_UPDATE_WITH_CHANGES);
        }
    }

    protected MetadataEntityListener(Class entityClass) {
        this();
        this.m_entityClass = entityClass;
    }

    public MetadataEntityListener(Class listenerClass, Class entityClass) {
        this(entityClass);
        try {
            this.m_listener = listenerClass.newInstance();
        }
        catch (Exception ex) {
            ValidationException.errorInstantiatingEntityListener(listenerClass, ex);
        }
    }

    public void addEventMethod(String event, Method method) {
        this.validateMethod(method);
        if (this.m_methods.containsKey(event)) {
            throw ValidationException.multipleLifecycleCallbackMethodsForSameLifecycleEvent(this.getListenerClass(), method, this.getEventMethod(event));
        }
        this.m_methods.put(event, method);
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    protected Method getEventMethod(int eventCode) {
        String eventString = m_eventStrings.get(eventCode);
        if (eventString != null) {
            return this.getEventMethod(eventString);
        }
        return null;
    }

    protected Method getEventMethod(String event) {
        return this.m_methods.get(event);
    }

    protected String getEventMethodName(String eventName) {
        Method method = this.getEventMethod(eventName);
        if (method != null) {
            return method.getName();
        }
        return null;
    }

    public Class getListenerClass() {
        return this.m_listener.getClass();
    }

    public Hashtable getMethods() {
        return this.m_methods;
    }

    public String getPostBuildMethodName() {
        return this.getEventMethodName(POST_BUILD);
    }

    public String getPostCloneMethodName() {
        return this.getEventMethodName(POST_CLONE);
    }

    public String getPostDeleteMethodName() {
        return this.getEventMethodName(POST_DELETE);
    }

    public String getPostInsertMethodName() {
        return this.getEventMethodName(POST_INSERT);
    }

    public String getPostRefreshMethodName() {
        return this.getEventMethodName(POST_REFRESH);
    }

    public String getPostUpdateMethodName() {
        return this.getEventMethodName(POST_UPDATE);
    }

    public String getPrePersistMethodName() {
        return this.getEventMethodName(PRE_PERSIST);
    }

    public String getPreRemoveMethodName() {
        return this.getEventMethodName(PRE_REMOVE);
    }

    public String getPreUpdateWithChangesMethodName() {
        return this.getEventMethodName(PRE_UPDATE_WITH_CHANGES);
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    public boolean hasOverriddenEventMethod(Method eventMethod, int eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethod(eventCode), eventMethod);
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod1, Method eventMethod2) {
        return eventMethod1 != null && eventMethod1.getName().equals(eventMethod2.getName());
    }

    public boolean hasOverriddenEventMethod(Method eventMethod, String eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethod(eventCode), eventMethod);
    }

    public void initializeCallbackMethods(ClassLoader classLoader) {
    }

    protected void invokeMethod(Method method, Object onObject, Object[] objectList, DescriptorEvent event) {
        block10: {
            if (method != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, onObject, objectList));
                            break block10;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                            }
                            Throwable cause = throwableException.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw (Error)cause;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(method, onObject, objectList);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw (Error)cause;
                }
            }
        }
    }

    protected void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        Object[] objectList = new Object[]{descriptorEvent.getSource()};
        this.invokeMethod(this.getEventMethod(event), this.m_listener, objectList, descriptorEvent);
    }

    public boolean isEntityClassListener() {
        return false;
    }

    public boolean isOverriddenEvent(DescriptorEvent event, Vector eventManagers) {
        int eventCode = event.getEventCode();
        if (!this.m_overriddenEvents.containsKey(eventCode)) {
            this.m_overriddenEvents.put(eventCode, false);
            Method eventMethod = this.getEventMethod(eventCode);
            if (eventMethod != null) {
                DescriptorEventManager eventManager;
                MetadataEntityListener childListener;
                Iterator i$ = eventManagers.iterator();
                while (i$.hasNext() && (childListener = (MetadataEntityListener)(eventManager = (DescriptorEventManager)i$.next()).getEntityEventListener()) != this) {
                    if (!childListener.hasOverriddenEventMethod(eventMethod, eventCode)) continue;
                    this.m_overriddenEvents.put(eventCode, true);
                    break;
                }
            }
        }
        return this.m_overriddenEvents.get(eventCode);
    }

    protected boolean isSessionPostBuildEvent(DescriptorEvent event) {
        if (m_eventStrings.get(event).equals(POST_BUILD)) {
            return !event.getSession().isUnitOfWork();
        }
        return false;
    }

    protected boolean noCallbackMethodAlreadySetFor(String event, Method method) {
        Method cbMethod = (Method)this.getMethods().get(event);
        if (cbMethod == null) {
            return true;
        }
        return !cbMethod.getName().equals(method.getName());
    }

    public void postBuild(DescriptorEvent event) {
        this.invokeMethod(POST_BUILD, event);
    }

    public void postClone(DescriptorEvent event) {
        this.invokeMethod(POST_CLONE, event);
    }

    public void postDelete(DescriptorEvent event) {
        this.invokeMethod(POST_DELETE, event);
    }

    public void postInsert(DescriptorEvent event) {
        this.invokeMethod(POST_INSERT, event);
    }

    public void postRefresh(DescriptorEvent event) {
        this.invokeMethod(POST_REFRESH, event);
    }

    public void postUpdate(DescriptorEvent event) {
        this.invokeMethod(POST_UPDATE, event);
    }

    public void prePersist(DescriptorEvent event) {
        this.invokeMethod(PRE_PERSIST, event);
    }

    public void preRemove(DescriptorEvent event) {
        this.invokeMethod(PRE_REMOVE, event);
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
        this.invokeMethod(PRE_UPDATE_WITH_CHANGES, event);
    }

    public void setEntityClass(Class entityClass) {
        this.m_entityClass = entityClass;
    }

    public void setListener(Object listener) {
        this.m_listener = listener;
    }

    public void setPostBuildMethod(Method method) {
        this.addEventMethod(POST_BUILD, method);
    }

    public void setPostCloneMethod(Method method) {
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostRefreshMethod(Method method) {
        this.addEventMethod(POST_REFRESH, method);
    }

    public void setPostUpdateMethod(Method method) {
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersistMethod(Method method) {
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemoveMethod(Method method) {
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    protected void validateMethod(Method method) {
        int numberOfParameters = method.getParameterTypes().length;
        Class<?> parameterClass = method.getParameterTypes()[0];
        if (numberOfParameters != 1 || !parameterClass.isAssignableFrom(this.m_entityClass)) {
            throw ValidationException.invalidEntityListenerCallbackMethodArguments(this.m_entityClass, parameterClass, this.m_listener.getClass(), method.getName());
        }
        this.validateMethodModifiers(method);
    }

    protected void validateMethodModifiers(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            throw ValidationException.invalidCallbackMethodModifier(this.getListenerClass(), method.getName());
        }
    }
}

