/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AdvancedActionPanel;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class RunTargetsAction
extends SystemAction
implements ContextAwareAction {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

    public String getName() {
        return NbBundle.getMessage((Class)RunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent e) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Action should never be called without a context");
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext);
    }

    private static JMenu createMenu(AntProjectCookie project) {
        return new LazyMenu(project);
    }

    static {
        $assertionsDisabled = !RunTargetsAction.class.desiredAssertionStatus();
    }

    private static final class AdvancedAction
    extends AbstractAction {
        private final AntProjectCookie project;
        private final Set allTargets;

        public AdvancedAction(AntProjectCookie project, Set allTargets) {
            super(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced"));
            this.project = project;
            this.allTargets = allTargets;
        }

        public void actionPerformed(ActionEvent e) {
            String title = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"TITLE_run_advanced");
            AdvancedActionPanel panel = new AdvancedActionPanel(this.project, this.allTargets);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
            dd.setOptionType(2);
            JButton run = new JButton(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced_run"));
            run.setDefaultCapable(true);
            JButton cancel = new JButton(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced_cancel"));
            dd.setOptions(new Object[]{run, cancel});
            dd.setModal(true);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (result.equals(run)) {
                try {
                    panel.run();
                }
                catch (IOException x) {
                    AntModule.err.notify((Throwable)x);
                }
            }
        }
    }

    private static final class TargetMenuItemHandler
    implements ActionListener,
    Runnable {
        private final AntProjectCookie project;
        private final String target;

        public TargetMenuItemHandler(AntProjectCookie project, String target) {
            this.project = project;
            this.target = target;
        }

        public void actionPerformed(ActionEvent ev) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            try {
                TargetExecutor te = new TargetExecutor(this.project, new String[]{this.target});
                te.execute();
            }
            catch (IOException ioe) {
                AntModule.err.notify((Throwable)ioe);
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final AntProjectCookie project;
        private boolean initialized = false;

        public LazyMenu(AntProjectCookie project) {
            super(SystemAction.get((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction)).getName());
            this.project = project;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                Set allTargets;
                this.initialized = true;
                try {
                    allTargets = TargetLister.getTargets(this.project);
                }
                catch (IOException e) {
                    AntModule.err.notify(1, (Throwable)e);
                    allTargets = Collections.EMPTY_SET;
                }
                String defaultTarget = null;
                TreeSet<Object> describedTargets = new TreeSet<Object>(Collator.getInstance());
                TreeSet<Object> otherTargets = new TreeSet<Object>(Collator.getInstance());
                Iterator it = allTargets.iterator();
                while (it.hasNext()) {
                    TargetLister.Target t = (TargetLister.Target)it.next();
                    if (t.isOverridden() || t.isInternal()) continue;
                    String name = t.getName();
                    if (t.isDefault()) {
                        defaultTarget = name;
                        continue;
                    }
                    if (t.isDescribed()) {
                        describedTargets.add(name);
                        continue;
                    }
                    otherTargets.add(name);
                }
                boolean needsep = false;
                if (defaultTarget != null) {
                    needsep = true;
                    JMenuItem menuitem = new JMenuItem(defaultTarget);
                    menuitem.addActionListener(new TargetMenuItemHandler(this.project, defaultTarget));
                    this.add(menuitem);
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                if (!describedTargets.isEmpty()) {
                    needsep = true;
                    it = describedTargets.iterator();
                    while (it.hasNext()) {
                        String target = (String)it.next();
                        JMenuItem menuitem = new JMenuItem(target);
                        menuitem.addActionListener(new TargetMenuItemHandler(this.project, target));
                        this.add(menuitem);
                    }
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                if (!otherTargets.isEmpty()) {
                    needsep = true;
                    JMenu submenu = new JMenu(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_other_targets"));
                    it = otherTargets.iterator();
                    while (it.hasNext()) {
                        String target = (String)it.next();
                        JMenuItem menuitem = new JMenuItem(target);
                        menuitem.addActionListener(new TargetMenuItemHandler(this.project, target));
                        submenu.add(menuitem);
                    }
                    this.add(submenu);
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                this.add(new AdvancedAction(this.project, allTargets));
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final AntProjectCookie project;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ContextAction(Lookup lkp) {
            super(SystemAction.get((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction)).getName());
            Collection apcs = lkp.lookup(new Lookup.Template(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = RunTargetsAction.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).allInstances();
            AntProjectCookie _project = null;
            if (apcs.size() == 1 && (_project = (AntProjectCookie)apcs.iterator().next()).getParseException() != null) {
                _project = null;
            }
            this.project = _project;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Action should not be called directly");
            }
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return RunTargetsAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean b) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"No modifications to enablement status permitted");
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction).desiredAssertionStatus();
        }
    }
}

