/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

final class BrokenDataShadow
extends MultiDataObject {
    private URL url;
    private static Map allDataShadows;
    private static final long serialVersionUID = -3046981691235483810L;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public BrokenDataShadow(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        try {
            this.url = DataShadow.readURL(fo);
        }
        catch (IOException ex) {
            try {
                this.url = new URL("file", null, "/UNKNOWN");
            }
            catch (MalformedURLException ex2) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex2);
            }
        }
        BrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    static synchronized Map getDataShadowsSet() {
        if (allDataShadows == null) {
            allDataShadows = new HashMap();
        }
        return allDataShadows;
    }

    private static synchronized void enqueueBrokenDataShadow(BrokenDataShadow ds) {
        Map m = BrokenDataShadow.getDataShadowsSet();
        String prim = ds.getUrl().toExternalForm();
        DataShadow.DSWeakReference ref = new DataShadow.DSWeakReference(ds);
        Set<DataShadow.DSWeakReference> s = (Set<DataShadow.DSWeakReference>)m.get(prim);
        if (s == null) {
            s = Collections.singleton(ref);
            BrokenDataShadow.getDataShadowsSet().put(prim, s);
        } else {
            if (!(s instanceof HashSet)) {
                s = new HashSet<DataShadow.DSWeakReference>(s);
                BrokenDataShadow.getDataShadowsSet().put(prim, s);
            }
            s.add(ref);
        }
    }

    private static synchronized List getAllDataShadows() {
        if (allDataShadows == null || allDataShadows.isEmpty()) {
            return null;
        }
        ArrayList ret = new ArrayList(allDataShadows.size());
        Iterator it = allDataShadows.values().iterator();
        while (it.hasNext()) {
            Set ref = (Set)it.next();
            Iterator refs = ref.iterator();
            while (refs.hasNext()) {
                Reference r = (Reference)refs.next();
                Object shadow = r.get();
                if (shadow == null) continue;
                ret.add(shadow);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkValidity(EventObject ev) {
        String key;
        DataObject src = null;
        if (ev instanceof OperationEvent) {
            src = ((OperationEvent)ev).getObject();
        }
        FileObject file = null;
        if (src != null) {
            file = src.getPrimaryFile();
        } else if (ev instanceof FileEvent) {
            file = ((FileEvent)ev).getFile();
        }
        try {
            if (!file.getFileSystem().equals(Repository.getDefault().getDefaultFileSystem())) {
                return;
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().log(16, e.toString());
            return;
        }
        Class e = BrokenDataShadow.class;
        synchronized (e) {
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                return;
            }
        }
        try {
            key = file.getURL().toExternalForm();
        }
        catch (FileStateInvalidException ex) {
            return;
        }
        Set shadows = null;
        Class clazz = BrokenDataShadow.class;
        synchronized (clazz) {
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                return;
            }
            if (src != null && (shadows = (Set)allDataShadows.get(key)) == null) {
                return;
            }
        }
        List all = BrokenDataShadow.getAllDataShadows();
        if (all == null) {
            return;
        }
        int size = all.size();
        for (int i = 0; i < size; ++i) {
            Object obj = all.get(i);
            ((BrokenDataShadow)obj).refresh();
        }
    }

    private BrokenDataShadow(FileObject fo) throws DataObjectExistsException {
        this(fo, DataLoaderPool.getShadowLoader());
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public void refresh() {
        try {
            if (URLMapper.findFileObject((URL)this.getUrl()) != null) {
                this.setValid(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    URL getUrl() {
        return this.url;
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/loaders/brokenShadow";

        public BrokenShadowNode(BrokenDataShadow par) {
            super(par, Children.LEAF);
            this.setIconBase(ICON_NAME);
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(DataObject.getString("FMT_brokenShadowName"));
            }
            return format.format(this.createArguments());
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BrokenDataShadow.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = BrokenDataShadow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BrokenDataShadow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BrokenDataShadow.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BrokenDataShadow.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BrokenDataShadow.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] sets = super.getPropertySets();
            Sheet s = new Sheet();
            for (int i = 0; i < sets.length; ++i) {
                Sheet.Set ss = new Sheet.Set();
                ss.put(sets[i].getProperties());
                ss.setName(sets[i].getName());
                ss.setDisplayName(sets[i].getDisplayName());
                ss.setShortDescription(sets[i].getShortDescription());
                this.modifySheetSet(ss);
                s.put(ss);
            }
            return s;
        }

        private void modifySheetSet(Sheet.Set ss) {
            Object p = ss.remove("name");
            if (p != null) {
                p = new PropertySupport.Name((Node)this);
                ss.put(p);
                p = new Name();
                ss.put(p);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            public Name() {
                super("BrokenLink", class$java$lang$String == null ? (class$java$lang$String = BrokenDataShadow.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowOriginalName"), DataObject.getString("HINT_brokenShadowOriginalName"));
            }

            public Object getValue() {
                BrokenDataShadow bds = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return bds.getUrl().toExternalForm();
            }

            public void setValue(Object val) {
                String newLink = (String)val;
                BrokenDataShadow bds = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                try {
                    URL u = new URL(newLink);
                    DataShadow.writeOriginal(bds.getPrimaryFile(), u);
                    bds.url = u;
                }
                catch (IOException ex) {
                    IllegalArgumentException e = new IllegalArgumentException(ex.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
                    throw e;
                }
                bds.refresh();
            }
        }
    }
}

