/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;
    static /* synthetic */ Class class$org$openide$loaders$FileEntry;

    public FileEntry(MultiDataObject obj, FileObject fo) {
        MultiDataObject multiDataObject = obj;
        multiDataObject.getClass();
        super(multiDataObject, fo);
    }

    public FileObject copy(FileObject f, String suffix) throws IOException {
        FileObject fo = this.getFile();
        String newName = fo.getName() + suffix;
        return fo.copy(f, newName, fo.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileObject rename(String name) throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().rename(lock, name, this.getFile().getExt());
            Object var5_4 = null;
            if (locked) return this.getFile();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (locked) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
        return this.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileObject f, String suffix) throws IOException {
        FileObject fileObject;
        block2: {
            boolean locked = this.isLocked();
            FileObject fo = this.getFile();
            FileLock lock = this.takeLock();
            try {
                FileObject dest;
                String newName = fo.getName() + suffix;
                fileObject = dest = fo.move(lock, f, newName, fo.getExt());
                Object var10_9 = null;
                if (locked) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var10_10 = null;
                    if (locked) break block3;
                    lock.releaseLock();
                }
                throw throwable;
            }
            lock.releaseLock();
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().delete(lock);
            Object var4_3 = null;
            if (locked) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (locked) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public FileObject createFromTemplate(FileObject f, String name) throws IOException {
        if (name == null) {
            name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)this.getFile().getExt());
        }
        FileObject fo = this.getFile().copy(f, name, this.getFile().getExt());
        DataObject.setTemplate(fo, false);
        return fo;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject obj, FileObject fo) {
            MultiDataObject multiDataObject = obj;
            multiDataObject.getClass();
            super(multiDataObject, fo);
        }

        public FileObject copy(FileObject f, String suffix) throws IOException {
            String add = suffix + (this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fo = FileUtil.createFolder((FileObject)f, (String)(this.getFile().getName() + add));
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            return fo;
        }

        public FileObject move(FileObject f, String suffix) throws IOException {
            return this.copy(f, suffix);
        }

        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)this.getFile().getExt());
            }
            FileObject fo = FileUtil.createFolder((FileObject)f, (String)name);
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            DataObject.setTemplate(fo, false);
            return fo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FileObject rename(String name) throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().rename(lock, name, null);
                Object var5_4 = null;
                if (locked) return this.getFile();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (locked) throw throwable;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return this.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void delete() throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
                Object var4_3 = null;
                if (locked) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (locked) throw throwable;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;

        public Numb(MultiDataObject obj, FileObject fo) {
            MultiDataObject multiDataObject = obj;
            multiDataObject.getClass();
            super(multiDataObject, fo);
        }

        public boolean isImportant() {
            return false;
        }

        public FileObject copy(FileObject f, String suffix) {
            return null;
        }

        public FileObject rename(String name) throws IOException {
            this.stdBehaving();
            return null;
        }

        public FileObject move(FileObject f, String suffix) throws IOException {
            this.stdBehaving();
            return null;
        }

        public void delete() throws IOException {
            this.stdBehaving();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle((Class)(class$org$openide$loaders$FileEntry == null ? (class$org$openide$loaders$FileEntry = FileEntry.class$("org.openide.loaders.FileEntry")) : class$org$openide$loaders$FileEntry)).getString("EXC_SharedAccess"));
            }
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
                Object var3_2 = null;
                if (lock == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (lock == null) throw throwable;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
        }

        public FileObject createFromTemplate(FileObject f, String name) {
            return null;
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            FileObject fo = f.createData(name, ext);
            java.text.Format frm = this.createFormat(f, name, ext);
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock lock = fo.lock();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock)));
                    try {
                        String current;
                        while ((current = r.readLine()) != null) {
                            w.write(frm.format(current));
                            w.newLine();
                        }
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        w.close();
                        throw throwable;
                    }
                    w.close();
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                r.close();
                throw throwable;
            }
            r.close();
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            DataObject.setTemplate(fo, false);
            return fo;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

