/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomainEditor {
    private static DeploymentManager dm;
    private static String HTTP_PROXY_HOST;
    private static String HTTP_PROXY_PORT;
    private static String HTTPS_PROXY_HOST;
    private static String HTTPS_PROXY_PORT;
    private static String HTTP_PROXY_NO_HOST;
    private static String SAMPLE_DATASOURCE;
    private static String SAMPLE_CONNPOOL;
    private static String NBPROFILERNAME;
    static final String[] sysDatasources;

    public DomainEditor(DeploymentManager dm) {
        DomainEditor.dm = dm;
    }

    public String getDomainLocation() {
        DeploymentManagerProperties dmProps = new DeploymentManagerProperties(dm);
        String domainScriptFilePath = dmProps.getLocation() + "/" + dmProps.getDomainName() + "/config/domain.xml";
        return domainScriptFilePath;
    }

    public Document getDomainDocument() {
        String domainLoc = this.getDomainLocation();
        Document domainScriptDocument = this.getDomainDocument(domainLoc);
        return domainScriptDocument;
    }

    public Document getDomainDocument(String domainLoc) {
        File domainScriptFile = new File(domainLoc);
        Document domainScriptDocument = this.loadDomainScriptFile(domainLoc);
        return domainScriptDocument;
    }

    public boolean addProfilerElements(Document domainDoc, String nativeLibraryPath, String[] jvmOptions) {
        String domainPath = this.getDomainLocation();
        this.removeProfiler(domainDoc);
        if (nativeLibraryPath != null || jvmOptions != null) {
            NodeList javaConfigNodeList;
            Element profilerElement = domainDoc.createElement("profiler");
            profilerElement.setAttribute("enabled", "true");
            profilerElement.setAttribute("name", NBPROFILERNAME);
            if (nativeLibraryPath != null) {
                profilerElement.setAttribute("native-library-path", nativeLibraryPath);
            }
            File appServerLocation = ((SunDeploymentManagerInterface)this.getDeploymentManager()).getPlatformRoot();
            if (jvmOptions != null) {
                for (int i = 0; i < jvmOptions.length; ++i) {
                    Element jvmOptionsElement = domainDoc.createElement("jvm-options");
                    Text tt = domainDoc.createTextNode(this.formatJvmOption(jvmOptions[i], appServerLocation));
                    jvmOptionsElement.appendChild(tt);
                    profilerElement.appendChild(jvmOptionsElement);
                }
            }
            if ((javaConfigNodeList = domainDoc.getElementsByTagName("java-config")) == null || javaConfigNodeList.getLength() == 0) {
                System.err.println("ConfigFilesUtils: cannot find 'java-config' section in domain config file " + domainPath);
                return false;
            }
            Node javaConfigNode = javaConfigNodeList.item(0);
            if (javaConfigNode.getFirstChild() != null) {
                javaConfigNode.insertBefore(profilerElement, javaConfigNode.getFirstChild());
            } else {
                javaConfigNode.appendChild(profilerElement);
            }
        }
        return this.saveDomainScriptFile(domainDoc, domainPath);
    }

    public boolean removeProfilerElements(Document domainDoc) {
        boolean eleRemoved = this.removeProfiler(domainDoc);
        if (eleRemoved) {
            return this.saveDomainScriptFile(domainDoc, this.getDomainLocation());
        }
        return true;
    }

    private boolean removeProfiler(Document domainDoc) {
        NodeList profilerElementNodeList = domainDoc.getElementsByTagName("profiler");
        if (profilerElementNodeList != null && profilerElementNodeList.getLength() > 0) {
            int i;
            Vector<Node> nodes = new Vector<Node>();
            for (i = 0; i < profilerElementNodeList.getLength(); ++i) {
                Node n = profilerElementNodeList.item(i);
                Node a = n.getAttributes().getNamedItem("name");
                if (a == null || !a.getNodeValue().equals(NBPROFILERNAME)) continue;
                nodes.add(n);
            }
            for (i = 0; i < nodes.size(); ++i) {
                Node nd = (Node)nodes.get(i);
                nd.getParentNode().removeChild(nd);
            }
            return true;
        }
        return false;
    }

    public String[] getHttpProxyOptions() {
        ArrayList<String> httpProxyOptions = new ArrayList<String>();
        Document domainDoc = this.getDomainDocument();
        NodeList javaConfigNodeList = domainDoc.getElementsByTagName("java-config");
        if (javaConfigNodeList == null || javaConfigNodeList.getLength() == 0) {
            return (String[])httpProxyOptions.toArray();
        }
        NodeList jvmOptionNodeList = domainDoc.getElementsByTagName("jvm-options");
        for (int i = 0; i < jvmOptionNodeList.getLength(); ++i) {
            Node childNode;
            String childValue;
            Node nd = jvmOptionNodeList.item(i);
            if (!nd.hasChildNodes() || (childValue = (childNode = nd.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && childValue.indexOf(HTTP_PROXY_PORT) == -1 && childValue.indexOf(HTTPS_PROXY_HOST) == -1 && childValue.indexOf(HTTPS_PROXY_PORT) == -1 && childValue.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            httpProxyOptions.add(childValue);
        }
        String[] opts = new String[httpProxyOptions.size()];
        return httpProxyOptions.toArray(opts);
    }

    public boolean setHttpProxyOptions(String[] httpProxyOptions) {
        Document domainDoc = this.getDomainDocument();
        NodeList javaConfigNodeList = domainDoc.getElementsByTagName("java-config");
        if (javaConfigNodeList == null || javaConfigNodeList.getLength() == 0) {
            return false;
        }
        this.removeProxyOptions(domainDoc, javaConfigNodeList.item(0));
        for (int j = 0; j < httpProxyOptions.length; ++j) {
            String option = httpProxyOptions[j];
            Element jvmOptionsElement = domainDoc.createElement("jvm-options");
            Text proxyOption = domainDoc.createTextNode(option);
            jvmOptionsElement.appendChild(proxyOption);
            javaConfigNodeList.item(0).appendChild(jvmOptionsElement);
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation(), false);
    }

    private boolean removeProxyOptions(Document domainDoc, Node javaConfigNode) {
        Node nd;
        int i;
        NodeList jvmOptionNodeList = domainDoc.getElementsByTagName("jvm-options");
        Vector<Node> nodes = new Vector<Node>();
        for (i = 0; i < jvmOptionNodeList.getLength(); ++i) {
            Node childNode;
            String childValue;
            nd = jvmOptionNodeList.item(i);
            if (!nd.hasChildNodes() || (childValue = (childNode = nd.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && childValue.indexOf(HTTP_PROXY_PORT) == -1 && childValue.indexOf(HTTPS_PROXY_HOST) == -1 && childValue.indexOf(HTTPS_PROXY_PORT) == -1 && childValue.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            nodes.add(nd);
        }
        for (i = 0; i < nodes.size(); ++i) {
            nd = (Node)nodes.get(i);
            javaConfigNode.removeChild((Node)nodes.get(i));
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation(), false);
    }

    private Document loadDomainScriptFile(String domainScriptFilePath) {
        Object document = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource source = new InputSource(reader);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
            });
            return dBuilder.parse(new File(domainScriptFilePath));
        }
        catch (Exception e) {
            System.err.println("ConfigFilesUtils: unable to parse domain config file " + domainScriptFilePath);
            return null;
        }
    }

    private boolean saveDomainScriptFile(Document domainScriptDocument, String domainScriptFilePath) {
        return this.saveDomainScriptFile(domainScriptDocument, domainScriptFilePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDomainScriptFile(Document domainScriptDocument, String domainScriptFilePath, boolean indent) {
        boolean result = false;
        FileWriter domainScriptFileWriter = null;
        try {
            domainScriptFileWriter = new FileWriter(domainScriptFilePath);
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (indent) {
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("doctype-public", domainScriptDocument.getDoctype().getPublicId());
                transformer.setOutputProperty("doctype-system", domainScriptDocument.getDoctype().getSystemId());
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource domSource = new DOMSource(domainScriptDocument);
                StreamResult streamResult = new StreamResult(domainScriptFileWriter);
                transformer.transform(domSource, streamResult);
                result = true;
            }
            catch (Exception e) {
                System.err.println("ConfigFilesUtils: Unable to save domain config file " + domainScriptFilePath);
                result = false;
            }
        }
        catch (IOException ioex) {
            System.err.println("ConfigFilesUtils: cannot create output stream for domain config file " + domainScriptFilePath);
            result = false;
        }
        finally {
            try {
                if (domainScriptFileWriter != null) {
                    domainScriptFileWriter.close();
                }
            }
            catch (IOException ioex2) {
                System.err.println("SunAS8IntegrationProvider: cannot close output stream for " + domainScriptFilePath);
            }
        }
        return result;
    }

    private String formatJvmOption(String jvmOption, File appServerLocation) {
        if (jvmOption.indexOf("\\\"") != -1) {
            String modifiedOption = jvmOption.replaceAll("\\\\\"", "#");
            modifiedOption = modifiedOption.replaceAll("\\\"", "");
            modifiedOption = modifiedOption.replaceAll("#", "\"");
            String osType = System.getProperty("os.name");
            if (osType.startsWith("Mac OS") || ServerLocationManager.isGlassFish((File)appServerLocation)) {
                modifiedOption = "\"" + modifiedOption.replaceAll("\\\"", "\\\\\"") + "\"";
            }
            return modifiedOption;
        }
        return jvmOption;
    }

    public HashMap getSunDatasourcesFromXml() {
        HashMap dSources = new HashMap();
        Document domainDoc = this.getDomainDocument();
        HashMap dsMap = this.getDataSourcesAttrMap(domainDoc);
        HashMap cpMap = this.getConnPoolsNodeMap(domainDoc);
        dsMap.keySet().removeAll(Arrays.asList(sysDatasources));
        String[] ds = dsMap.keySet().toArray(new String[dsMap.size()]);
        for (int i = 0; i < ds.length; ++i) {
            String jndiName = ds[i];
            HashMap<String, String> pValues = new HashMap<String, String>();
            NamedNodeMap dsAttrMap = (NamedNodeMap)dsMap.get(jndiName);
            String poolName = dsAttrMap.getNamedItem("pool-name").getNodeValue();
            Node cpNode = (Node)cpMap.get(poolName);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            String dsClassName = cpAttrMap.getNamedItem("datasource-classname").getNodeValue();
            Element cpElement = (Element)cpNode;
            NodeList propsNodeList = cpElement.getElementsByTagName("property");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < propsNodeList.getLength(); ++j) {
                Node propNode = propsNodeList.item(j);
                NamedNodeMap propsMap = propNode.getAttributes();
                for (int m = 0; m < propsMap.getLength(); ++m) {
                    String mkey = propsMap.getNamedItem("name").getNodeValue();
                    String mkeyValue = propsMap.getNamedItem("value").getNodeValue();
                    map.put(mkey, mkeyValue);
                }
            }
            pValues.put("User", (String)map.get("User"));
            pValues.put("Password", (String)map.get("Password"));
            pValues.put("URL", (String)map.get("URL"));
            pValues.put("databaseName", (String)map.get("databaseName"));
            pValues.put("serverName", (String)map.get("serverName"));
            pValues.put("PortNumber", (String)map.get("PortNumber"));
            pValues.put("portNumber", (String)map.get("portNumber"));
            pValues.put("DatabaseName", (String)map.get("DatabaseName"));
            pValues.put("SID", (String)map.get("SID"));
            pValues.put("dsClassName", dsClassName);
            dSources.put(jndiName, pValues);
        }
        return dSources;
    }

    public HashMap getConnPoolsFromXml() {
        HashMap pools = new HashMap();
        Document domainDoc = this.getDomainDocument();
        HashMap cpMap = this.getConnPoolsNodeMap(domainDoc);
        String[] cp = cpMap.keySet().toArray(new String[cpMap.size()]);
        for (int i = 0; i < cp.length; ++i) {
            String name = cp[i];
            HashMap<String, String> pValues = new HashMap<String, String>();
            Node cpNode = (Node)cpMap.get(name);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            String dsClassName = cpAttrMap.getNamedItem("datasource-classname").getNodeValue();
            Element cpElement = (Element)cpNode;
            NodeList propsNodeList = cpElement.getElementsByTagName("property");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < propsNodeList.getLength(); ++j) {
                Node propNode = propsNodeList.item(j);
                NamedNodeMap propsMap = propNode.getAttributes();
                for (int m = 0; m < propsMap.getLength(); ++m) {
                    String mkey = propsMap.getNamedItem("name").getNodeValue();
                    String mkeyValue = propsMap.getNamedItem("value").getNodeValue();
                    map.put(mkey, mkeyValue);
                }
            }
            pValues.put("User", (String)map.get("User"));
            pValues.put("Password", (String)map.get("Password"));
            pValues.put("URL", (String)map.get("URL"));
            pValues.put("databaseName", (String)map.get("databaseName"));
            pValues.put("serverName", (String)map.get("serverName"));
            pValues.put("PortNumber", (String)map.get("PortNumber"));
            pValues.put("portNumber", (String)map.get("portNumber"));
            pValues.put("DatabaseName", (String)map.get("DatabaseName"));
            pValues.put("SID", (String)map.get("SID"));
            pValues.put("dsClassName", dsClassName);
            pools.put(name, pValues);
        }
        return pools;
    }

    private HashMap getDataSourcesAttrMap(Document domainDoc) {
        HashMap<String, NamedNodeMap> dataSourceMap = new HashMap<String, NamedNodeMap>();
        this.updateWithSampleDataSource(domainDoc);
        NodeList dataSourceNodeList = domainDoc.getElementsByTagName("jdbc-resource");
        for (int i = 0; i < dataSourceNodeList.getLength(); ++i) {
            Node dsNode = dataSourceNodeList.item(i);
            NamedNodeMap dsAttrMap = dsNode.getAttributes();
            String jndiName = dsAttrMap.getNamedItem("jndi-name").getNodeValue();
            dataSourceMap.put(jndiName, dsAttrMap);
        }
        return dataSourceMap;
    }

    private boolean updateWithSampleDataSource(Document domainDoc) {
        boolean sampleExists = false;
        NodeList dataSourceNodeList = domainDoc.getElementsByTagName("jdbc-resource");
        for (int i = 0; i < dataSourceNodeList.getLength(); ++i) {
            Node dsNode = dataSourceNodeList.item(i);
            NamedNodeMap dsAttrMap = dsNode.getAttributes();
            String jndiName = dsAttrMap.getNamedItem("jndi-name").getNodeValue();
            if (!jndiName.equals(SAMPLE_DATASOURCE)) continue;
            sampleExists = true;
        }
        if (!sampleExists) {
            return this.createSampleDatasource(domainDoc);
        }
        return true;
    }

    private HashMap getConnPoolsNodeMap(Document domainDoc) {
        HashMap<String, Node> connPoolMap = new HashMap<String, Node>();
        NodeList connPoolNodeList = domainDoc.getElementsByTagName("jdbc-connection-pool");
        for (int i = 0; i < connPoolNodeList.getLength(); ++i) {
            Node cpNode = connPoolNodeList.item(i);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            String cpName = cpAttrMap.getNamedItem("name").getNodeValue();
            connPoolMap.put(cpName, cpNode);
        }
        return connPoolMap;
    }

    public boolean createSampleDatasource(Document domainDoc) {
        NodeList resourcesNodeList = domainDoc.getElementsByTagName("resources");
        NodeList serverNodeList = domainDoc.getElementsByTagName("server");
        if (resourcesNodeList == null || resourcesNodeList.getLength() == 0 || serverNodeList == null || serverNodeList.getLength() == 0) {
            return true;
        }
        Node resourcesNode = resourcesNodeList.item(0);
        HashMap cpMap = this.getConnPoolsNodeMap(domainDoc);
        if (!cpMap.containsKey(SAMPLE_CONNPOOL)) {
            Node oldNode = (Node)cpMap.get("DerbyPool");
            Node cpNode = oldNode.cloneNode(false);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            cpAttrMap.getNamedItem("name").setNodeValue(SAMPLE_CONNPOOL);
            HashMap<String, String> poolProps = new HashMap<String, String>();
            poolProps.put("serverName", "localhost");
            poolProps.put("Password", "app");
            poolProps.put("User", "app");
            poolProps.put("DatabaseName", "sample");
            poolProps.put("PortNumber", "1527");
            Object[] propNames = poolProps.keySet().toArray();
            for (int i = 0; i < propNames.length; ++i) {
                String keyName = (String)propNames[i];
                Element propElement = domainDoc.createElement("property");
                propElement.setAttribute("name", keyName);
                propElement.setAttribute("value", (String)poolProps.get(keyName));
                cpNode.appendChild(propElement);
            }
            resourcesNode.appendChild(cpNode);
        }
        Element dsElement = domainDoc.createElement("jdbc-resource");
        dsElement.setAttribute("jndi-name", SAMPLE_DATASOURCE);
        dsElement.setAttribute("pool-name", SAMPLE_CONNPOOL);
        dsElement.setAttribute("object-type", "user");
        dsElement.setAttribute("enabled", "true");
        if (resourcesNode.getFirstChild() != null) {
            resourcesNode.insertBefore(dsElement, resourcesNode.getFirstChild());
        } else {
            resourcesNode.appendChild(dsElement);
        }
        Element dsResRefElement = domainDoc.createElement("resource-ref");
        dsResRefElement.setAttribute("ref", SAMPLE_DATASOURCE);
        dsResRefElement.setAttribute("enabled", "true");
        Node serverNode = serverNodeList.item(0);
        if (serverNode.getLastChild() != null) {
            serverNode.insertBefore(dsResRefElement, serverNode.getLastChild());
        } else {
            serverNode.appendChild(dsResRefElement);
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation());
    }

    public DeploymentManager getDeploymentManager() {
        return dm;
    }

    static {
        HTTP_PROXY_HOST = "-Dhttp.proxyHost=";
        HTTP_PROXY_PORT = "-Dhttp.proxyPort=";
        HTTPS_PROXY_HOST = "-Dhttps.proxyHost=";
        HTTPS_PROXY_PORT = "-Dhttps.proxyPort=";
        HTTP_PROXY_NO_HOST = "-Dhttp.nonProxyHosts=";
        SAMPLE_DATASOURCE = "jdbc/sample";
        SAMPLE_CONNPOOL = "SamplePool";
        NBPROFILERNAME = "NetBeansProfiler";
        sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool", "jdbc/__default"};
    }
}

