/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Util {
    public static NumericDocument getNumericDocument() {
        return new NumericDocument();
    }

    public static void showInformation(final String msg, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static void showInformationWhenHolding(final String msg, final String title) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static void showInformation(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static Object showWarning(String msg) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    public static Object showWarning(String msg, String title) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, title, 2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    public static void showError(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static void showError(final String msg, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 0);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static void setStatusBar(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText(msg);
            }
        });
    }

    static File[] getRegisterableDefaultDomains(File location) {
        File[] noneRegisterable = new File[]{};
        String ext = File.separatorChar == '/' ? "conf" : "bat";
        File asenv = new File(location, "config/asenv." + ext);
        Asenv asenvContent = new Asenv(asenv);
        String defDomainsDirName = asenvContent.get("AS_DEF_DOMAINS_PATH");
        File domainsDir = new File(defDomainsDirName);
        if (!domainsDir.exists() && location.getAbsolutePath().startsWith("/opt/SUNWappserver")) {
            domainsDir = new File("/var/opt/SUNWappserver/domains");
        }
        if (!domainsDir.exists()) {
            return noneRegisterable;
        }
        File[] possibles = domainsDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.canWrite();
            }
        });
        if (null == possibles) {
            return noneRegisterable;
        }
        int realCount = 0;
        for (int i = 0; i < possibles.length; ++i) {
            if (Util.rootOfUsableDomain(possibles[i])) {
                ++realCount;
                continue;
            }
            possibles[i] = null;
        }
        File[] retVal = new File[realCount];
        int nextSlot = 0;
        for (int i = 0; i < possibles.length; ++i) {
            if (possibles[i] == null) continue;
            retVal[nextSlot] = possibles[i];
            ++nextSlot;
        }
        return retVal;
    }

    public static boolean rootOfUsableDomain(File f) {
        File testFile = new File(f, "logs");
        if (!(testFile.exists() && testFile.isDirectory() && testFile.canWrite())) {
            return false;
        }
        testFile = new File(f, "config");
        if (!(testFile.exists() && testFile.isDirectory() && testFile.canWrite())) {
            return false;
        }
        return (testFile = new File(testFile, "domain.xml")).exists() && testFile.canWrite();
    }

    public static String getHostPort(File domainDir, File platformDir) {
        File xmlRoot = File.pathSeparatorChar == ':' ? new File(domainDir.getAbsolutePath() + "/config/domain.xml") : new File(domainDir.getAbsolutePath() + "\\config\\domain.xml");
        String adminHostPort = null;
        try {
            Class[] argClass = new Class[]{File.class, File.class};
            Object[] argObject = new Object[]{xmlRoot, platformDir};
            ClassLoader loader = ServerLocationManager.getServerOnlyClassLoader((File)platformDir);
            if (loader != null) {
                Class<?> cc = loader.loadClass("org.netbeans.modules.j2ee.sun.bridge.AppServerBridge");
                Method getHostPort = cc.getMethod("getHostPort", argClass);
                adminHostPort = (String)getHostPort.invoke(null, argObject);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return adminHostPort;
    }

    static String getDeploymentUri(File domainDir, File platformDir) {
        return "deployer:Sun:AppServer::" + Util.getHostPort(domainDir, platformDir);
    }

    static File domainFile(File domainDir) {
        if (File.pathSeparatorChar == ';') {
            return new File(domainDir + "\\config\\domain.xml");
        }
        return new File(domainDir + "/config/domain.xml");
    }

    static void fillDescriptorFromDomainXml(WizardDescriptor wiz, File domainDir) {
        String hp = Util.getHostPort(domainDir, (File)wiz.getProperty("platform_location"));
        if (null != hp) {
            wiz.putProperty("domain_file", (Object)Util.domainFile(domainDir));
            int sepDex = hp.indexOf(58);
            wiz.putProperty("host", (Object)hp.substring(0, sepDex));
            wiz.putProperty("port", (Object)hp.substring(sepDex + 1));
            wiz.putProperty("domain", (Object)domainDir.getName());
            wiz.putProperty("install_location", (Object)domainDir.getParentFile().getAbsolutePath());
            wiz.putProperty("WizardPanel_errorMessage", null);
        } else {
            wiz.putProperty("host", (Object)"");
            wiz.putProperty("port", (Object)"");
            wiz.putProperty("domain", (Object)"");
            wiz.putProperty("install_location", (Object)"");
            wiz.putProperty("WizardPanel_errorMessage", null);
        }
    }

    static JFileChooser getJFileChooser(javax.swing.filechooser.FileFilter f) {
        JFileChooser chooser = new JFileChooser();
        Util.decorateChooser(chooser, null, NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        return chooser;
    }

    static void decorateChooser(JFileChooser chooser, String fname, String title) {
        chooser.setDialogTitle(title);
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(Util.class, (String)"Choose_Button_Mnemonic").charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        if (null != fname && fname.length() > 0) {
            File sel = new File(fname);
            if (sel.isDirectory()) {
                chooser.setCurrentDirectory(sel);
            } else {
                chooser.setSelectedFile(sel);
            }
        }
    }

    public static class NumericDocument
    extends PlainDocument {
        private Toolkit toolkit = Toolkit.getDefaultToolkit();

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] s = str.toCharArray();
            char[] r = new char[s.length];
            int j = 0;
            for (int i = 0; i < r.length; ++i) {
                if (Character.isDigit(s[i])) {
                    r[j++] = s[i];
                    continue;
                }
                this.toolkit.beep();
            }
            super.insertString(offs, new String(r, 0, j), a);
        }
    }
}

