/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.nodes.JBEjbModuleNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.Refreshable;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class JBEjbModulesChildren
extends Children.Keys
implements Refreshable {
    private Lookup lookup;

    public JBEjbModulesChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                LinkedList keys = new LinkedList();
                Object server = Util.getRMIServer(JBEjbModulesChildren.this.lookup);
                JBEjbModulesChildren.this.addEjbModules(server, keys);
                JBEjbModulesChildren.this.addEJB3Modules(server, keys);
                JBEjbModulesChildren.this.setKeys(keys);
            }
        }, 0);
    }

    private void addEjbModules(Object server, List keys) {
        try {
            ObjectName searchPattern;
            String propertyName;
            if (Util.isRemoteManagementSupported(this.lookup)) {
                propertyName = "name";
                searchPattern = new ObjectName("jboss.management.local:j2eeType=EJBModule,J2EEApplication=null,*");
            } else {
                propertyName = "module";
                searchPattern = new ObjectName("jboss.j2ee:service=EjbModule,*");
            }
            Set managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
            Iterator it = managedObj.iterator();
            while (it.hasNext()) {
                ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                String name = elem.getKeyProperty(propertyName);
                keys.add(new JBEjbModuleNode(name, this.lookup));
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private void addEJB3Modules(Object server, List keys) {
        try {
            ObjectName searchPattern = new ObjectName("jboss.j2ee:service=EJB3,*");
            Set managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
            Iterator it = managedObj.iterator();
            while (it.hasNext()) {
                try {
                    ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                    String name = elem.getKeyProperty("module");
                    keys.add(new JBEjbModuleNode(name, this.lookup, true));
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof JBEjbModuleNode) {
            return new Node[]{(JBEjbModuleNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }
}

