/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class IconEditor
extends PropertyEditorSupport
implements PropertyEditor,
XMLPropertyEditor,
ExPropertyEditor,
FormAwareEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    private static final String URL_PREFIX = "URL";
    private static final String FILE_PREFIX = "File";
    private static final String CLASSPATH_PREFIX = "Classpath";
    private PropertyEnv propertyEnv;
    private FormModel formModel;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";

    private static String getString(String key) {
        return NbBundle.getBundle(IconEditor.class).getString(key);
    }

    public static boolean isImage(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif") || s.endsWith(".jpeg") || s.endsWith(".jpe") || s.equals("jpg") || s.equals("gif") || s.equals("jpeg") || s.equals("jpe");
    }

    private static String convert(String s) {
        StringTokenizer st = new StringTokenizer(s, "\\");
        StringBuffer sb = new StringBuffer();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
            while (st.hasMoreElements()) {
                sb.append("\\\\").append(st.nextElement());
            }
        }
        return sb.toString();
    }

    public int getSourceType() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).type;
        }
        return 2;
    }

    public String getSourceName() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).name;
        }
        return null;
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object object) {
        if (this.propertyEnv != null) {
            if (object == null || object instanceof NbImageIcon && ((NbImageIcon)object).stateValid) {
                this.propertyEnv.setState(PropertyEnv.STATE_VALID);
            } else {
                this.propertyEnv.setState(PropertyEnv.STATE_INVALID);
            }
        }
        super.setValue(object instanceof NbImageIcon ? object : null);
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        if (val instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)val;
            switch (ii.type) {
                case 1: {
                    return "URL: " + ii.name;
                }
                case 2: {
                    return "File: " + ii.name;
                }
                case 3: {
                    return "Classpath: " + ii.name;
                }
            }
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)this.getValue();
            switch (ii.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(ii.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "new javax.swing.ImageIcon(\"" + IconEditor.convert(ii.name) + "\")";
                }
                case 3: {
                    return "new javax.swing.ImageIcon(getClass().getResource(\"" + IconEditor.convert(ii.name) + "\"))";
                }
            }
        }
        return "null";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    private URL findResource(String resource) {
        FileObject formFile;
        ClassPath classPath;
        FileObject resourceObject;
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if ((resourceObject = (classPath = ClassPath.getClassPath((FileObject)(formFile = FormEditor.getFormDataObject(this.formModel).getFormFile()), (String)"classpath/source")).findResource(resource)) == null) {
            classPath = ClassPath.getClassPath((FileObject)formFile, (String)"classpath/execute");
            resourceObject = classPath.findResource(resource);
        }
        if (resourceObject == null) {
            return null;
        }
        try {
            return resourceObject.getURL();
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify((Throwable)fsie);
            return null;
        }
    }

    public void setFormModel(FormModel model) {
        this.formModel = model;
    }

    private NbImageIcon iconFromText(String string) throws IllegalArgumentException {
        NbImageIcon ii;
        try {
            if (string.startsWith(FILE_PREFIX)) {
                String s = string.substring(FILE_PREFIX.length() + 1).trim();
                ii = new NbImageIcon(s);
                ii.type = 2;
                ii.name = s;
            } else if (string.startsWith(CLASSPATH_PREFIX)) {
                String s = string.substring(CLASSPATH_PREFIX.length() + 1).trim();
                if (s == null || "".equals(s) || "/".equals(s) || "///".equals(s) || s.endsWith("#")) {
                    return null;
                }
                URL u = this.findResource(s);
                ii = u == null ? new NbImageIcon() : new NbImageIcon(u);
                ii.type = 3;
                ii.name = s;
            } else if (string.startsWith(URL_PREFIX)) {
                String s = string.substring(URL_PREFIX.length() + 1).trim();
                URL url = new URL(s);
                ii = new NbImageIcon(url);
                ii.type = 1;
                ii.name = s;
            } else if (string.equals("null")) {
                ii = null;
            } else {
                ii = new NbImageIcon(string.trim());
                ii.type = 2;
                ii.name = string;
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            throw iae;
        }
        return ii;
    }

    public void readFromXML(org.w3c.dom.Node element) throws IOException {
        if (!XML_IMAGE.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            int type = Integer.parseInt(attributes.getNamedItem(ATTR_TYPE).getNodeValue());
            String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
            switch (type) {
                case 0: {
                    this.setValue(null);
                    break;
                }
                case 1: {
                    this.setAsText("URL: " + name);
                    break;
                }
                case 2: {
                    this.setAsText("File: " + name);
                    break;
                }
                case 3: {
                    this.setAsText("Classpath: " + name);
                }
            }
        }
        catch (NullPointerException e) {
            IOException ioe = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
    }

    public org.w3c.dom.Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_IMAGE);
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)this.getValue();
            el.setAttribute(ATTR_TYPE, Integer.toString(ii.type));
            el.setAttribute(ATTR_NAME, ii.name);
        } else {
            el.setAttribute(ATTR_TYPE, "0");
            el.setAttribute(ATTR_NAME, "null");
        }
        return el;
    }

    public void attachEnv(PropertyEnv env) {
        this.propertyEnv = env;
    }

    private static class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node root) {
            ResourceBundle bundle = NbBundle.getBundle(ResourceSelector.class);
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(root);
            BeanTreeView tree = new BeanTreeView();
            tree.setPopupAllowed(false);
            tree.setDefaultActionAllowed(false);
            tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            tree.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelectorView"));
            tree.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)tree, "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = Math.max(dim.height, Utilities.getUsableScreenBounds().height / 2);
            return dim;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static class RootNode
    extends FilterNode {
        RootNode(Node node, String displayName) {
            super(node);
            if (displayName != null) {
                this.disableDelegation(12);
                this.setDisplayName(displayName);
            }
        }
    }

    private class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor,
    ActionListener {
        static final long serialVersionUID = -6904264999063788703L;
        private JPanel jPanel1;
        private JLabel jLabel1;
        private JRadioButton rbUrl;
        private JRadioButton rbFile;
        private JRadioButton rbClasspath;
        private JRadioButton rbNoPicture;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JLabel jLabel5;
        private JPanel jPanel2;
        private JLabel lName;
        private JTextField tfName;
        private JButton bSelect;
        private JPanel jPanel3;
        private JLabel jLabel7;
        private JScrollPane spImage;
        private JLabel iconLabel;
        private NbImageIcon localIcon;

        public IconPanel() {
            this.iconLabel = new JLabel(){

                public boolean isFocusTraversable() {
                    return true;
                }
            };
            this.iconLabel.setPreferredSize(new Dimension(32, 32));
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.initComponents();
            this.spImage.setViewportView(this.iconLabel);
            this.jLabel1.setText(IconEditor.getString("CTL_ImageSourceType"));
            this.rbUrl.setText(IconEditor.getString("CTL_URL"));
            this.rbFile.setText(IconEditor.getString("CTL_File"));
            this.rbClasspath.setText(IconEditor.getString("CTL_Classpath"));
            this.rbNoPicture.setText(IconEditor.getString("CTL_NoPicture"));
            this.jLabel2.setText(IconEditor.getString("CTL_URLExample"));
            this.jLabel3.setText(IconEditor.getString("CTL_FileExample"));
            this.jLabel4.setText(IconEditor.getString("CTL_ClasspathExample"));
            this.jLabel5.setText(IconEditor.getString("CTL_Null"));
            this.lName.setText(IconEditor.getString("CTL_ImageSourceName"));
            this.lName.setDisplayedMnemonic(IconEditor.getString("CTL_ImageSourceName_mnemonic").charAt(0));
            this.lName.setLabelFor(this.tfName);
            this.jLabel7.setText(IconEditor.getString("CTL_Preview"));
            this.jLabel7.setDisplayedMnemonic(IconEditor.getString("CTL_Preview_mnemonic").charAt(0));
            this.bSelect.setText(IconEditor.getString("CTL_ButtonSelect"));
            this.bSelect.setMnemonic(IconEditor.getString("CTL_ButtonSelect_mnemonic").charAt(0));
            this.jLabel1.setLabelFor(this.jPanel1);
            this.jLabel2.setLabelFor(this.rbUrl);
            this.jLabel3.setLabelFor(this.rbFile);
            this.jLabel4.setLabelFor(this.rbClasspath);
            this.jLabel5.setLabelFor(this.rbNoPicture);
            this.jLabel7.setLabelFor(this.iconLabel);
            this.rbUrl.setMnemonic(IconEditor.getString("CTL_URL_mnemonic").charAt(0));
            this.rbFile.setMnemonic(IconEditor.getString("CTL_File_mnemonic").charAt(0));
            this.rbClasspath.setMnemonic(IconEditor.getString("CTL_Classpath_mnemonic").charAt(0));
            this.rbNoPicture.setMnemonic(IconEditor.getString("CTL_NoPicture_mnemonic").charAt(0));
            this.tfName.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ImageSourceName"));
            this.bSelect.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ButtonSelect"));
            this.iconLabel.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_Preview"));
            this.rbUrl.getAccessibleContext().setAccessibleDescription(this.jLabel2.getText());
            this.rbFile.getAccessibleContext().setAccessibleDescription(this.jLabel3.getText());
            this.rbClasspath.getAccessibleContext().setAccessibleDescription(this.jLabel4.getText());
            this.rbNoPicture.getAccessibleContext().setAccessibleDescription(this.jLabel5.getText());
            this.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_IconCustomEditor"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbUrl);
            bg.add(this.rbFile);
            bg.add(this.rbClasspath);
            bg.add(this.rbNoPicture);
            Object value = IconEditor.this.getValue();
            if (IconEditor.this.propertyEnv != null) {
                IconEditor.this.propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
            if (!(value instanceof NbImageIcon)) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            this.localIcon = (NbImageIcon)value;
            switch (this.localIcon.type) {
                case 1: {
                    this.rbUrl.setSelected(true);
                    this.bSelect.setEnabled(false);
                    break;
                }
                case 2: {
                    this.rbFile.setSelected(true);
                    this.bSelect.setEnabled(true);
                    break;
                }
                case 3: {
                    this.rbClasspath.setSelected(true);
                    this.bSelect.setEnabled(true);
                }
            }
            this.tfName.setText(this.localIcon.name);
            this.updateIcon();
        }

        private void initComponents() {
            this.jPanel1 = new JPanel();
            this.jLabel1 = new JLabel();
            this.rbUrl = new JRadioButton();
            this.rbFile = new JRadioButton();
            this.rbClasspath = new JRadioButton();
            this.rbNoPicture = new JRadioButton();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jPanel2 = new JPanel();
            this.lName = new JLabel();
            this.tfName = new JTextField();
            this.bSelect = new JButton();
            this.jPanel3 = new JPanel();
            this.jLabel7 = new JLabel();
            this.spImage = new JScrollPane();
            this.setLayout(new GridBagLayout());
            this.jPanel1.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new Insets(12, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbUrl, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbFile, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbClasspath, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbNoPicture, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new Insets(12, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel2, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel3, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel4, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            this.jPanel1.add((Component)this.jLabel5, gridBagConstraints1);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel1, gridBagConstraints2);
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.lName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(12, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            this.jPanel2.add((Component)this.tfName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 5, 0, 17);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.bSelect, gridBagConstraints3);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel2, gridBagConstraints2);
            this.jPanel3.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints4.anchor = 17;
            this.jPanel3.add((Component)this.jLabel7, gridBagConstraints4);
            gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 12, 0, 12);
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            this.jPanel3.add((Component)this.spImage, gridBagConstraints4);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.add((Component)this.jPanel3, gridBagConstraints2);
            this.tfName.addActionListener(this);
            this.rbFile.addActionListener(this);
            this.rbUrl.addActionListener(this);
            this.rbClasspath.addActionListener(this);
            this.rbNoPicture.addActionListener(this);
            this.bSelect.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.tfName) {
                this.setValue();
            } else if (source == this.rbFile) {
                this.bSelect.setEnabled(true);
                this.tfName.setEnabled(true);
                this.setValue();
                this.updateIcon();
            } else if (source == this.rbUrl) {
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(true);
                this.setValue();
            } else if (source == this.rbClasspath) {
                this.bSelect.setEnabled(true);
                this.tfName.setEnabled(true);
                this.setValue();
            } else if (source == this.rbNoPicture) {
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                this.localIcon = null;
                this.updateIcon();
            } else if (source == this.bSelect) {
                String name;
                if (this.rbFile.isSelected()) {
                    File f = this.selectFile();
                    if (f != null) {
                        this.tfName.setText(f.getAbsolutePath());
                        this.setValue();
                    }
                } else if (this.rbClasspath.isSelected() && (name = this.selectResource()) != null) {
                    this.tfName.setText("/" + name);
                    this.setValue();
                }
            }
        }

        private File selectFile() {
            final File[] ff = new File[1];
            final FeatureDescriptor fd = new FeatureDescriptor();
            ExPropertyModel epm = new ExPropertyModel(){

                public void setValue(Object val) {
                    ff[0] = (File)val;
                }

                public Object getValue() {
                    return ff[0];
                }

                public Class getPropertyType() {
                    return File.class;
                }

                public Class getPropertyEditorClass() {
                    return null;
                }

                public void addPropertyChangeListener(PropertyChangeListener l) {
                }

                public void removePropertyChangeListener(PropertyChangeListener l) {
                }

                public Object[] getBeans() {
                    return new Object[0];
                }

                public FeatureDescriptor getFeatureDescriptor() {
                    return fd;
                }
            };
            FileFilter filter = new FileFilter(){

                public boolean accept(File f) {
                    return IconEditor.isImage(f.getName()) || f.isDirectory();
                }

                public String getDescription() {
                    return IconEditor.getString("CTL_ImagesExtensionName");
                }
            };
            fd.setValue("directories", Boolean.FALSE);
            fd.setValue("files", Boolean.TRUE);
            fd.setValue("filter", filter);
            PropertyPanel panel = new PropertyPanel((PropertyModel)epm, 2);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, IconEditor.getString("CTL_OpenDialogName"), true, null);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (res == DialogDescriptor.OK_OPTION) {
                return ff[0];
            }
            return null;
        }

        private List getRoots(ClassPath cp) {
            ArrayList<FileObject> l = new ArrayList<FileObject>(cp.entries().size());
            for (ClassPath.Entry e : cp.entries()) {
                URL url = e.getURL();
                SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] fos = r.getRoots();
                if (fos.length > 0) {
                    for (int i = 0; i < fos.length; ++i) {
                        l.add(fos[i]);
                    }
                    continue;
                }
                if (e.getRoot() == null) continue;
                l.add(e.getRoot());
            }
            return l;
        }

        private String selectResource() {
            FileObject fob;
            DataObject dob;
            FileObject root;
            FileObject formFile = FormEditor.getFormDataObject(IconEditor.this.formModel).getFormFile();
            ClassPath executeClassPath = ClassPath.getClassPath((FileObject)formFile, (String)"classpath/execute");
            List roots = executeClassPath == null ? Collections.EMPTY_LIST : this.getRoots(executeClassPath);
            Project project = FileOwnerQuery.getOwner((FileObject)formFile);
            Node[] nodes = new Node[roots.size()];
            int selRoot = -1;
            try {
                ListIterator iter = roots.listIterator();
                while (iter.hasNext()) {
                    Project owner;
                    root = (FileObject)iter.next();
                    DataObject dob2 = DataObject.find((FileObject)root);
                    String displayName = this.rootDisplayName(root, owner, (owner = FileOwnerQuery.getOwner((FileObject)root)) != project);
                    nodes[iter.previousIndex()] = new RootNode(dob2.getNodeDelegate(), displayName);
                }
            }
            catch (DataObjectNotFoundException donfex) {
                ErrorManager.getDefault().notify(4096, (Throwable)donfex);
                return null;
            }
            Children.Array children = new Children.Array();
            children.add(nodes);
            root = new AbstractNode((Children)children);
            root.setIconBase("org/netbeans/modules/form/editors2/iconResourceRoot");
            root.setDisplayName(IconEditor.getString("CTL_ClassPathName"));
            ResourceSelector selector = new ResourceSelector((Node)root);
            DialogDescriptor dd = new DialogDescriptor((Object)selector, IconEditor.getString("CTL_OpenDialogName"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            nodes = res == DialogDescriptor.OK_OPTION ? selector.getNodes() : null;
            String name = null;
            if (nodes != null && nodes.length == 1 && (dob = (DataObject)nodes[0].getCookie(DataObject.class)) != null && (fob = dob.getPrimaryFile()) != null) {
                if (executeClassPath.contains(fob)) {
                    name = executeClassPath.getResourceName(fob);
                } else {
                    ClassPath sourceClassPath = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
                    name = sourceClassPath.getResourceName(fob);
                }
            }
            return name;
        }

        private String rootDisplayName(FileObject fo, Project owner, boolean withProjectName) {
            if (owner != null) {
                String name;
                SourceGroup grp = this.sourceGroup(fo, owner);
                String string = name = grp != null ? grp.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fo);
                if (withProjectName) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)owner);
                    name = name + " [" + pi.getDisplayName() + "]";
                }
                return name;
            }
            return FileUtil.getFileDisplayName((FileObject)fo);
        }

        private SourceGroup sourceGroup(FileObject file, Project prj) {
            Sources src = ProjectUtils.getSources((Project)prj);
            SourceGroup[] srcgrps = src.getSourceGroups("java");
            for (int i = 0; i < srcgrps.length; ++i) {
                if (file != srcgrps[i].getRootFolder()) continue;
                return srcgrps[i];
            }
            return null;
        }

        private Node findSelectedNode(Node root, String name) {
            Node node = root;
            StringTokenizer st = new StringTokenizer(name, "/");
            while (st.hasMoreTokens()) {
                int index;
                String subName;
                Children children = node.getChildren();
                Node nextNode = children.findChild(subName = st.nextToken());
                if (nextNode == null && !st.hasMoreTokens() && (index = subName.lastIndexOf(46)) != -1) {
                    subName = subName.substring(0, index);
                    nextNode = children.findChild(subName);
                }
                if (nextNode == null) break;
                node = nextNode;
            }
            return node;
        }

        public Object getPropertyValue() throws IllegalStateException {
            NbImageIcon ii = null;
            String s = this.tfName.getText().trim();
            if (s == null || "".equals(s) || "/".equals(s) || "///".equals(s) || s.endsWith("#")) {
                return null;
            }
            try {
                if (this.rbFile.isSelected()) {
                    ii = new NbImageIcon(s);
                    ii.type = 2;
                    ii.name = s;
                } else if (this.rbClasspath.isSelected()) {
                    URL url = IconEditor.this.findResource(s);
                    ii = new NbImageIcon(url);
                    ii.type = 3;
                    ii.name = s;
                } else if (this.rbUrl.isSelected()) {
                    URL url = new URL(s);
                    ii = new NbImageIcon(url);
                    ii.type = 1;
                    ii.name = s;
                }
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                ErrorManager.getDefault().annotate((Throwable)ise, 256, IconEditor.getString("MSG_IllegalValue"), IconEditor.getString("MSG_IllegalValue"), null, new Date());
                throw ise;
            }
            return ii;
        }

        void updateIcon() {
            IconEditor.this.setValue(this.localIcon);
            this.iconLabel.setIcon(this.localIcon == null ? null : this.localIcon.icon);
            this.iconLabel.setEnabled(this.localIcon != null);
            this.validate();
        }

        void setValue() {
            String val = this.tfName.getText();
            val.trim();
            if ("".equals(val)) {
                this.localIcon = null;
                this.updateIcon();
                return;
            }
            String pref = "";
            if (this.rbUrl.isSelected()) {
                pref = "URL: ";
            } else if (this.rbFile.isSelected()) {
                pref = "File: ";
            } else if (this.rbClasspath.isSelected()) {
                pref = "Classpath: ";
            }
            try {
                this.localIcon = IconEditor.this.iconFromText(pref + val);
            }
            catch (IllegalArgumentException ee) {
                this.localIcon = null;
            }
            this.updateIcon();
        }
    }

    public static class NbImageIcon
    implements FormDesignValue,
    Serializable {
        static final long serialVersionUID = 7018807466471349466L;
        private ImageIcon icon = null;
        private int type;
        private String name;
        private boolean stateValid;

        public NbImageIcon() {
            this.stateValid = false;
            this.icon = new ImageIcon("");
        }

        NbImageIcon(URL url) {
            this.type = 1;
            this.stateValid = true;
            this.icon = new ImageIcon(url);
        }

        NbImageIcon(String file) {
            this.type = 2;
            this.stateValid = true;
            this.icon = new ImageIcon(file);
        }

        public NbImageIcon(NbImageIcon nbIcon) {
            this.icon = nbIcon.icon;
            this.type = nbIcon.type;
            this.name = nbIcon.name;
            this.stateValid = nbIcon.stateValid;
        }

        String getName() {
            return this.name;
        }

        public Object getDesignValue() {
            return this.icon;
        }

        public String getDescription() {
            return this.name;
        }

        public FormDesignValue copy(FormModel formModel) {
            return new NbImageIcon(this);
        }
    }
}

