/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.SelectDatabasePanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategy;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class UseDatabaseAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        JavaClass beanClass = JMIUtils.getJavaClassFromNode((Node)nodes[0]);
        FileObject srcFile = JavaModel.getFileObject((Resource)beanClass.getResource());
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)srcFile);
        J2eeModuleProvider pwm = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
        SelectDatabasePanel p = new SelectDatabasePanel(pwm, erc.getServiceLocatorName());
        final DialogDescriptor nd = new DialogDescriptor((Object)p, NbBundle.getMessage(UseDatabaseAction.class, (String)"LBL_ChooseDatabase"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SelectDatabasePanel.class), null);
        nd.setValid(this.checkConnections());
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("SelectDatabasePanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    nd.setValid((Boolean)newvalue != false && UseDatabaseAction.this.checkConnections());
                }
            }
        });
        p.checkDatasource();
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (option == NotifyDescriptor.OK_OPTION) {
            try {
                Datasource ds = p.getDatasource();
                String serviceLocator = p.getServiceLocator();
                ServiceLocatorStrategy serviceLocatorStrategy = null;
                if (serviceLocator != null) {
                    serviceLocatorStrategy = ServiceLocatorStrategy.create(enterpriseProject, srcFile, serviceLocator);
                }
                if (Utils.isJavaEE5orHigher(enterpriseProject) && InjectionTargetQuery.isInjectionTarget((JavaClass)beanClass) && serviceLocatorStrategy == null) {
                    this.generateInjectedField(beanClass, ds.getJndiName());
                } else {
                    String jndiName = this.generateJNDILookup(ds.getJndiName(), erc, beanClass.getName(), ds.getUrl(), p.createServerResources());
                    this.generateLookupMethod(beanClass, jndiName, serviceLocatorStrategy);
                }
                if (serviceLocator != null) {
                    erc.setServiceLocatorName(serviceLocator);
                }
            }
            catch (IOException ioe) {
                NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ioe.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
            }
        }
    }

    private boolean checkConnections() {
        return ConnectionManager.getDefault().getConnections().length > 0;
    }

    public String getName() {
        return NbBundle.getMessage(UseDatabaseAction.class, (String)"LBL_UseDbAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String generateJNDILookup(String jndiName, EnterpriseReferenceContainer erc, String className, String nodeName, boolean createServerResources) throws IOException {
        ResourceRef ref = erc.createResourceRef(className);
        if (createServerResources) {
            ref.setDescription(nodeName);
        }
        ref.setResRefName(jndiName);
        ref.setResAuth("Container");
        ref.setResSharingScope("Shareable");
        ref.setResType(DataSource.class.getName());
        return erc.addResourceRef(ref, className);
    }

    private void generateLookupMethod(JavaClass ce, String jndiName, ServiceLocatorStrategy sl) {
        String methodName = "get" + Utils.jndiNameToCamelCase(jndiName, false, null);
        Method me = JMIUtils.createMethod((JavaClass)ce);
        me.setModifiers(2);
        me.setName(methodName);
        me.setType(JMIUtils.resolveType((String)DataSource.class.getName()));
        JMIUtils.addException((Method)me, (String)NamingException.class.getName());
        if (sl == null) {
            me.setBodyText(this.getLookupCode(jndiName));
        } else {
            me.setBodyText(this.getLookupCode(jndiName, sl, ce));
        }
        if (!Utils.containsFeature(ce, (Feature)me)) {
            ce.getContents().add(me);
            this.fixImports(ce, (Feature)me);
        }
    }

    private String getLookupCode(String jndiName, ServiceLocatorStrategy sl, JavaClass target) {
        String jdbcLookupString = sl.genDataSource(jndiName, target);
        return "return (javax.sql.DataSource) " + jdbcLookupString + ";\n";
    }

    private String getLookupCode(String jndiName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\nreturn (javax.sql.DataSource) c.lookup(\"java:comp/env/{0}\");\n", jndiName);
    }

    private void generateInjectedField(JavaClass javaClass, String jndiName) {
        int modifier = InjectionTargetQuery.isStaticReferenceRequired((JavaClass)javaClass) ? 10 : 2;
        String fieldName = Utils.jndiNameToCamelCase(jndiName, true, null);
        Field field = JMIGenerationUtil.createField((Element)javaClass, (String)fieldName, (int)modifier, (String)"javax.sql.DataSource");
        AttributeValue av = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)jndiName);
        Annotation a = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.annotation.Resource", Collections.singletonList(av));
        field.getAnnotations().add(a);
        if (!Utils.containsFeature(javaClass, (Feature)field)) {
            javaClass.getFeatures().add(0, field);
            this.fixImports(javaClass, (Feature)field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixImports(JavaClass beanClass, Feature f) {
        boolean failed = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JMIUtils.fixImports((JavaClass)beanClass, (Feature)f);
            failed = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(failed);
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return false;
        }
        JavaClass jc = JMIUtils.getJavaClassFromNode((Node)nodes[0]);
        return jc == null ? false : !jc.isInterface();
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(UseDatabaseAction.class, (String)"HINT_UseDbAction"));
    }
}

