/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;

public class SyntaxElement {
    public static final int TYPE_COMMENT = 0;
    public static final int TYPE_DECLARATION = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_TAG = 4;
    public static final int TYPE_ENDTAG = 5;
    public static final String[] TYPE_NAMES = new String[]{"comment", "declaration", "error", "text", "tag", "endtag"};
    private HTMLSyntaxSupport support;
    private SyntaxElement previous;
    private SyntaxElement next;
    int offset;
    int length;
    int type;

    public SyntaxElement(HTMLSyntaxSupport support, int from, int to, int type) {
        this.support = support;
        this.offset = from;
        this.length = to - from;
        this.type = type;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        try {
            return this.support.getDocument().getText(this.offset, this.length);
        }
        catch (BadLocationException exc) {
            throw new ConcurrentModificationException("SyntaxElement in inconsistent state");
        }
    }

    public SyntaxElement getPrevious() throws BadLocationException {
        if (this.previous == null) {
            this.previous = this.support.getPreviousElement(this.offset);
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        return this.previous;
    }

    public SyntaxElement getNext() throws BadLocationException {
        if (this.next == null) {
            this.next = this.support.getNextElement(this.offset + this.length);
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return this.next;
    }

    public String toString() {
        String textContent = this.getType() == 3 ? this.getText() : "";
        return "Element(" + TYPE_NAMES[this.type] + ")[" + this.offset + "," + (this.offset + this.length - 1) + "] \"" + textContent + "";
    }

    public static class Tag
    extends Named {
        Collection attribs;
        private boolean empty = false;

        public Tag(HTMLSyntaxSupport support, int from, int to, String name, Collection attribs) {
            this(support, from, to, name, attribs, false);
        }

        public Tag(HTMLSyntaxSupport support, int from, int to, String name, Collection attribs, boolean isEmpty) {
            super(support, from, to, 4, name);
            this.attribs = attribs;
            this.empty = isEmpty;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Collection getAttributes() {
            return this.attribs;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(super.toString());
            ret.append(" - {");
            Iterator i = this.attribs.iterator();
            while (i.hasNext()) {
                ret.append(i.next());
                ret.append(", ");
            }
            ret.append("}");
            if (this.isEmpty()) {
                ret.append(" (EMPTY TAG)");
            }
            return ret.toString();
        }
    }

    public static class Named
    extends SyntaxElement {
        String name;

        public Named(HTMLSyntaxSupport support, int from, int to, int type, String name) {
            super(support, from, to, type);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - \"" + this.name + '\"';
        }
    }

    public static class Declaration
    extends SyntaxElement {
        private String root;
        private String publicID;
        private String file;

        public Declaration(HTMLSyntaxSupport support, int from, int to, String doctypeRootElement, String doctypePI, String doctypeFile) {
            super(support, from, to, 1);
            this.root = doctypeRootElement;
            this.publicID = doctypePI;
            this.file = doctypeFile;
        }

        public String getRootElement() {
            return this.root;
        }

        public String getPublicIdentifier() {
            return this.publicID;
        }

        public String getDoctypeFile() {
            return this.file;
        }
    }
}

