/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Enumerations {
    private Enumerations() {
    }

    public static final Enumeration empty() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public static Enumeration singleton(Object obj) {
        return Collections.enumeration(Collections.singleton(obj));
    }

    public static Enumeration concat(Enumeration en1, Enumeration en2) {
        return new SeqEn(en1, en2);
    }

    public static Enumeration concat(Enumeration enumOfEnums) {
        return new SeqEn(enumOfEnums);
    }

    public static Enumeration removeDuplicates(Enumeration en) {
        class RDupls
        implements Processor {
            private Set set = new HashSet();

            RDupls() {
            }

            public Object process(Object o, Collection nothing) {
                return this.set.add(o) ? o : null;
            }
        }
        return Enumerations.filter(en, new RDupls());
    }

    public static Enumeration array(Object[] arr) {
        return Collections.enumeration(Arrays.asList(arr));
    }

    public static Enumeration removeNulls(Enumeration en) {
        return Enumerations.filter(en, new RNulls());
    }

    public static Enumeration convert(Enumeration en, Processor processor) {
        return new AltEn(en, processor);
    }

    public static Enumeration filter(Enumeration en, Processor filter) {
        return new FilEn(en, filter);
    }

    public static Enumeration queue(Enumeration en, Processor filter) {
        QEn q = new QEn(filter);
        while (en.hasMoreElements()) {
            q.put(en.nextElement());
        }
        return q;
    }

    private static class RNulls
    implements Processor {
        private RNulls() {
        }

        public Object process(Object original, Collection toAdd) {
            return original;
        }
    }

    private static final class FilEn
    implements Enumeration {
        private static final Object EMPTY = new Object();
        private Enumeration en;
        private Object next = EMPTY;
        private Processor filter;

        public FilEn(Enumeration en, Processor filter) {
            this.en = en;
            this.filter = filter;
        }

        public boolean hasMoreElements() {
            if (this.next != EMPTY) {
                return true;
            }
            while (this.en.hasMoreElements()) {
                this.next = this.filter.process(this.en.nextElement(), null);
                if (this.next == null) continue;
                return true;
            }
            this.next = EMPTY;
            return false;
        }

        public Object nextElement() {
            if (this.next == EMPTY && !this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            Object res = this.next;
            this.next = EMPTY;
            return res;
        }
    }

    private static class QEn
    implements Enumeration {
        private ListItem next = null;
        private ListItem last = null;
        private Processor processor;

        public QEn(Processor p) {
            this.processor = p;
        }

        public void put(Object o) {
            if (this.last != null) {
                ListItem li;
                this.last.next = li = new ListItem(o);
                this.last = li;
            } else {
                this.next = this.last = new ListItem(o);
            }
        }

        public void put(Object[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                this.put(arr[i]);
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object res = this.next.object;
            this.next = this.next.next;
            if (this.next == null) {
                this.last = null;
            }
            ToAdd toAdd = new ToAdd(this);
            res = this.processor.process(res, toAdd);
            toAdd.finish();
            return res;
        }

        private static final class ToAdd
        implements Collection {
            private QEn q;

            public ToAdd(QEn q) {
                this.q = q;
            }

            public void finish() {
                this.q = null;
            }

            public boolean add(Object o) {
                this.q.put(o);
                return true;
            }

            public boolean addAll(Collection c) {
                this.q.put(c.toArray());
                return true;
            }

            private String msg() {
                return "Only add and addAll are implemented";
            }

            public void clear() {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean contains(Object o) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean containsAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean isEmpty() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Iterator iterator() {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            public int size() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Object[] toArray() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Object[] toArray(Object[] a) {
                throw new UnsupportedOperationException(this.msg());
            }
        }

        private static final class ListItem {
            Object object;
            ListItem next;

            ListItem(Object o) {
                this.object = o;
            }
        }
    }

    private static final class SeqEn
    implements Enumeration {
        private Enumeration en;
        private Enumeration current;
        private boolean checked = false;

        public SeqEn(Enumeration en) {
            this.en = en;
        }

        public SeqEn(Enumeration first, Enumeration second) {
            this(Enumerations.array(new Enumeration[]{first, second}));
        }

        private void ensureCurrent() {
            while (this.current == null || !this.current.hasMoreElements()) {
                if (this.en.hasMoreElements()) {
                    this.current = (Enumeration)this.en.nextElement();
                    continue;
                }
                this.current = null;
                return;
            }
        }

        public boolean hasMoreElements() {
            if (!this.checked) {
                this.ensureCurrent();
                this.checked = true;
            }
            return this.current != null;
        }

        public Object nextElement() {
            if (!this.checked) {
                this.ensureCurrent();
            }
            if (this.current != null) {
                this.checked = false;
                return this.current.nextElement();
            }
            this.checked = true;
            throw new NoSuchElementException();
        }
    }

    private static final class AltEn
    implements Enumeration {
        private Enumeration en;
        private Processor process;

        public AltEn(Enumeration en, Processor process) {
            this.en = en;
            this.process = process;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return this.process.process(this.en.nextElement(), null);
        }
    }

    public static interface Processor {
        public Object process(Object var1, Collection var2);
    }
}

