/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.xml.catalog.impl.Util;
import org.netbeans.modules.xml.catalog.impl.XCatalog;

public class XCatalogCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -1437233290256708363L;
    XCatalog model = null;
    private JTextArea descTextArea;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JButton selectButton;

    public XCatalogCustomizer() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_XCatalogCustomizer"));
        this.locationLabel.setDisplayedMnemonic(Util.THIS.getString("XCatalogCustomizer.locationLabel.mne").charAt(0));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_locationTextField"));
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.descTextArea = new JTextArea();
        this.selectButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setLabelFor(this.locationTextField);
        this.locationLabel.setText(Util.THIS.getString("XCatalogCustomizer.locationLabel.text"));
        this.add((Component)this.locationLabel, new GridBagConstraints());
        this.locationTextField.setColumns(20);
        this.locationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XCatalogCustomizer.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.locationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                XCatalogCustomizer.this.locationTextFieldFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.locationTextField, gridBagConstraints);
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(Util.THIS.getString("DESC_xcatalog_fmts"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.selectButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/Bundle").getString("PROP_choose_file"));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XCatalogCustomizer.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.selectButton, gridBagConstraints);
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        File f = org.netbeans.modules.xml.catalog.lib.Util.selectCatalogFile("txt xml cat catalog");
        if (f == null) {
            return;
        }
        try {
            String location = f.toURL().toExternalForm();
            this.locationTextField.setText(location);
            this.model.setLocation(location);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void locationTextFieldFocusLost(FocusEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("FocusLost-setting location: " + this.locationTextField.getText());
        }
        this.model.setSource(this.locationTextField.getText());
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ActionPerformed-setting location: " + this.locationTextField.getText());
        }
        this.model.setSource(this.locationTextField.getText());
    }

    public void setObject(Object peer) {
        if (!(peer instanceof XCatalog)) {
            throw new IllegalArgumentException("XCatalog instance expected (" + peer.getClass() + ").");
        }
        this.model = (XCatalog)peer;
        this.locationTextField.setText(this.model.getSource());
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }
}

